/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.frameworkSupport;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;

public class BuildScriptDataBuilder {
    @NotNull
    private final VirtualFile myBuildScriptFile;
    protected final Set<String> imports = new TreeSet<String>();
    protected final Set<String> plugins = new TreeSet<String>();
    protected final Set<String> pluginsInGroup = new TreeSet<String>();
    protected final Set<String> repositories = new TreeSet<String>();
    protected final Set<String> dependencies = new TreeSet<String>();
    protected final Set<String> properties = new TreeSet<String>();
    protected final Set<String> buildScriptProperties = new TreeSet<String>();
    protected final Set<String> buildScriptRepositories = new TreeSet<String>();
    protected final Set<String> buildScriptDependencies = new TreeSet<String>();
    protected final Set<String> other = new TreeSet<String>();
    protected final GradleVersion myGradleVersion;

    public BuildScriptDataBuilder(@NotNull VirtualFile buildScriptFile) {
        this(buildScriptFile, GradleVersion.current());
    }

    public BuildScriptDataBuilder(@NotNull VirtualFile buildScriptFile, @NotNull GradleVersion gradleVersion) {
        this.myBuildScriptFile = buildScriptFile;
        this.myGradleVersion = gradleVersion;
    }

    @NotNull
    public VirtualFile getBuildScriptFile() {
        return this.myBuildScriptFile;
    }

    @NotNull
    public GradleVersion getGradleVersion() {
        return this.myGradleVersion;
    }

    public String buildImports() {
        if (!this.imports.isEmpty()) {
            return StringUtil.join(this.imports, (String)"\n") + "\n";
        }
        return "";
    }

    public String buildConfigurationPart() {
        ArrayList<String> lines = new ArrayList<String>();
        this.addBuildscriptLines(lines, (Function<? super String, String>)((Function)BuildScriptDataBuilder::padding));
        if (!this.pluginsInGroup.isEmpty()) {
            lines.add("plugins {");
            lines.addAll(ContainerUtil.map(this.pluginsInGroup, BuildScriptDataBuilder::padding));
            lines.add("}");
            lines.add("");
        }
        return StringUtil.join(lines, (String)"\n");
    }

    public String buildMainPart() {
        ArrayList<String> lines = new ArrayList<String>();
        this.addPluginsLines(lines, (Function<? super String, String>)((Function)BuildScriptDataBuilder::padding));
        if (!this.properties.isEmpty()) {
            lines.addAll(this.properties);
            lines.add("");
        }
        if (!this.repositories.isEmpty()) {
            lines.add("repositories {");
            lines.addAll(ContainerUtil.map(this.repositories, BuildScriptDataBuilder::padding));
            lines.add("}");
            lines.add("");
        }
        if (!this.dependencies.isEmpty()) {
            lines.add("dependencies {");
            lines.addAll(ContainerUtil.map(this.dependencies, BuildScriptDataBuilder::padding));
            lines.add("}");
            lines.add("");
        }
        if (!this.other.isEmpty()) {
            lines.addAll(this.other);
        }
        return StringUtil.join(lines, (String)"\n");
    }

    protected void addPluginsLines(@NotNull List<? super String> lines, @NotNull Function<? super String, String> padding) {
        if (!this.plugins.isEmpty()) {
            lines.addAll(this.plugins);
            lines.add("");
        }
    }

    private void addBuildscriptLines(@NotNull List<? super String> lines, @NotNull Function<? super String, String> padding) {
        if (!(this.buildScriptRepositories.isEmpty() && this.buildScriptDependencies.isEmpty() && this.buildScriptProperties.isEmpty())) {
            lines.add("buildscript {");
            SmartList buildScriptLines = new SmartList();
            if (!this.buildScriptProperties.isEmpty()) {
                buildScriptLines.addAll(this.buildScriptProperties);
                buildScriptLines.add("");
            }
            if (!this.buildScriptRepositories.isEmpty()) {
                buildScriptLines.add("repositories {");
                buildScriptLines.addAll(ContainerUtil.map(this.buildScriptRepositories, padding));
                buildScriptLines.add("}");
            }
            if (!this.buildScriptDependencies.isEmpty()) {
                buildScriptLines.add("dependencies {");
                buildScriptLines.addAll(ContainerUtil.map(this.buildScriptDependencies, padding));
                buildScriptLines.add("}");
            }
            lines.addAll(ContainerUtil.map((Collection)buildScriptLines, padding));
            lines.add("}");
            lines.add("");
        }
    }

    public BuildScriptDataBuilder addImport(@NotNull String importString) {
        this.imports.add(importString);
        return this;
    }

    public BuildScriptDataBuilder addBuildscriptPropertyDefinition(@NotNull String definition) {
        this.buildScriptProperties.add(definition.trim());
        return this;
    }

    public BuildScriptDataBuilder addBuildscriptRepositoriesDefinition(@NotNull String definition) {
        this.buildScriptRepositories.add(definition.trim());
        return this;
    }

    public BuildScriptDataBuilder addBuildscriptDependencyNotation(@NotNull String notation) {
        this.buildScriptDependencies.add(notation.trim());
        return this;
    }

    public BuildScriptDataBuilder addPluginDefinitionInPluginsGroup(@NotNull String definition) {
        this.pluginsInGroup.add(definition.trim());
        return this;
    }

    public BuildScriptDataBuilder addPluginDefinition(@NotNull String definition) {
        this.plugins.add(definition.trim());
        return this;
    }

    public BuildScriptDataBuilder addRepositoriesDefinition(@NotNull String definition) {
        this.repositories.add(definition.trim());
        return this;
    }

    public BuildScriptDataBuilder addDependencyNotation(@NotNull String notation) {
        this.dependencies.add(notation.trim());
        return this;
    }

    public BuildScriptDataBuilder addPropertyDefinition(@NotNull String definition) {
        this.properties.add(definition.trim());
        return this;
    }

    public BuildScriptDataBuilder addOther(@NotNull String definition) {
        this.other.add(definition.trim());
        return this;
    }

    private static String padding(String s) {
        return StringUtil.isNotEmpty((String)s) ? "    " + s : "";
    }
}

