/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.git4idea.editor;

import java.io.File;
import java.util.Arrays;
import org.jetbrains.git4idea.GitAppUtil;
import org.jetbrains.git4idea.GitExternalApp;
import org.jetbrains.git4idea.editor.GitRebaseEditorXmlRpcHandler;

public class GitRebaseEditorApp
implements GitExternalApp {
    public static void main(String[] args) {
        try {
            int xmlRpcPort;
            if (args.length != 2) {
                System.err.println("Invalid amount of arguments: " + Arrays.asList(args));
                System.exit(2);
                return;
            }
            try {
                xmlRpcPort = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException ex) {
                System.err.println("Invalid port number: " + args[0]);
                System.exit(2);
                return;
            }
            String handlerNo = GitAppUtil.getEnv("IDEA_REBASE_HANDER_NO");
            String token = GitAppUtil.getEnv("IDEA_REBASE_TOKEN");
            Integer response = (Integer)GitAppUtil.sendXmlRequest(GitRebaseEditorXmlRpcHandler.RPC_METHOD_NAME, token, xmlRpcPort, handlerNo, args[1], new File("").getAbsolutePath());
            int exitCode = response != null ? response : 2;
            System.exit(exitCode);
        }
        catch (Throwable t) {
            System.err.println(t.getMessage());
            t.printStackTrace(System.err);
            System.exit(2);
        }
    }
}

