/*
 * Decompiled with CFR 0.152.
 */
package dalvik.system;

import android.compat.annotation.UnsupportedAppUsage;
import com.android.internal.lang.System_Delegate;

public class CloseGuard {
    private static volatile boolean stackAndTrackingEnabled = true;
    private static volatile Reporter reporter = new DefaultReporter();
    private static volatile Tracker currentTracker = null;
    private static final String MESSAGE = "A resource was acquired at attached stack trace but never released. See java.io.Closeable for information on avoiding resource leaks.";
    private Object closerNameOrAllocationInfo;

    @UnsupportedAppUsage(trackingBug=111170242L)
    public static CloseGuard get() {
        return new CloseGuard();
    }

    @UnsupportedAppUsage
    public static void setEnabled(boolean enabled) {
        stackAndTrackingEnabled = enabled;
    }

    public static boolean isEnabled() {
        return stackAndTrackingEnabled;
    }

    @UnsupportedAppUsage
    public static void setReporter(Reporter rep) {
        if (rep == null) {
            throw new NullPointerException("reporter == null");
        }
        reporter = rep;
    }

    public static Reporter getReporter() {
        return reporter;
    }

    public static void setTracker(Tracker tracker) {
        currentTracker = tracker;
    }

    public static Tracker getTracker() {
        return currentTracker;
    }

    @UnsupportedAppUsage
    private CloseGuard() {
    }

    @UnsupportedAppUsage(trackingBug=111170242L)
    public void open(String closer) {
        this.openWithCallSite(closer, null);
    }

    public void openWithCallSite(String closer, String callsite) {
        if (closer == null) {
            throw new NullPointerException("closer == null");
        }
        if (!stackAndTrackingEnabled) {
            this.closerNameOrAllocationInfo = closer;
            return;
        }
        Tracker tracker = currentTracker;
        if (callsite == null || tracker != null) {
            String message = "Explicit termination method '" + closer + "' not called";
            Throwable stack = new Throwable(message);
            this.closerNameOrAllocationInfo = stack;
            if (tracker != null) {
                tracker.open(stack);
            }
        } else {
            this.closerNameOrAllocationInfo = callsite;
        }
    }

    @UnsupportedAppUsage
    public void close() {
        Tracker tracker = currentTracker;
        if (tracker != null && this.closerNameOrAllocationInfo instanceof Throwable) {
            tracker.close((Throwable)this.closerNameOrAllocationInfo);
        }
        this.closerNameOrAllocationInfo = null;
    }

    @UnsupportedAppUsage(trackingBug=111170242L)
    public void warnIfOpen() {
        if (this.closerNameOrAllocationInfo != null) {
            if (this.closerNameOrAllocationInfo instanceof Throwable) {
                reporter.report(MESSAGE, (Throwable)this.closerNameOrAllocationInfo);
            } else if (stackAndTrackingEnabled) {
                reporter.report("A resource was acquired at attached stack trace but never released. See java.io.Closeable for information on avoiding resource leaks. Callsite: " + this.closerNameOrAllocationInfo);
            } else {
                System_Delegate.log("A resource failed to call " + (String)this.closerNameOrAllocationInfo + ". ");
            }
        }
    }

    private static class DefaultReporter
    implements Reporter {
        @UnsupportedAppUsage
        private DefaultReporter() {
        }

        @Override
        public void report(String message, Throwable allocationSite) {
            System_Delegate.log(message, allocationSite);
        }

        @Override
        public void report(String message) {
            System_Delegate.log(message);
        }
    }

    public static interface Reporter {
        @UnsupportedAppUsage
        public void report(String var1, Throwable var2);

        default public void report(String message) {
        }
    }

    public static interface Tracker {
        public void open(Throwable var1);

        public void close(Throwable var1);
    }
}

