/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework;

import android.view.View;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheck;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityHierarchyCheck;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityHierarchyCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityViewCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.Parameters;
import com.google.android.apps.common.testing.accessibility.framework.uielement.AccessibilityHierarchyAndroid;
import com.google.android.apps.common.testing.accessibility.framework.uielement.ViewHierarchyElement;
import com.google.android.apps.common.testing.accessibility.framework.uielement.ViewHierarchyElementAndroid;
import com.google.android.libraries.accessibility.utils.log.LogUtils;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;

@Deprecated
public abstract class AccessibilityViewHierarchyCheck
extends AccessibilityCheck {
    private static final String TAG = "A11yViewHierarchyCheck";

    public abstract List<AccessibilityViewCheckResult> runCheckOnViewHierarchy(View var1, @Nullable Parameters var2);

    public List<AccessibilityViewCheckResult> runCheckOnViewHierarchy(View root) {
        return this.runCheckOnViewHierarchy(root, null);
    }

    protected List<AccessibilityViewCheckResult> runDelegationCheckOnView(View root, AccessibilityCheck fromCheck, AccessibilityHierarchyCheck toCheck, @Nullable Parameters parameters) {
        ViewHierarchyElementAndroid evalRoot;
        View actualRoot = root.getRootView();
        HashBiMap mapFromElementIdToView = HashBiMap.create();
        AccessibilityHierarchyAndroid hierarchy = AccessibilityHierarchyAndroid.newBuilder(actualRoot).setViewOriginMap((BiMap<Long, View>)mapFromElementIdToView).build();
        Long rootId = (Long)mapFromElementIdToView.inverse().get((Object)root);
        ViewHierarchyElementAndroid viewHierarchyElementAndroid = evalRoot = rootId != null ? hierarchy.getViewById(rootId) : null;
        if (evalRoot == null) {
            LogUtils.e(TAG, "Unable to determine root during accessibility check delegation, using full hierarchy.", new Object[0]);
        }
        List<AccessibilityHierarchyCheckResult> hierarchyCheckResults = toCheck.runCheckOnHierarchy(hierarchy, evalRoot, parameters);
        ArrayList<AccessibilityViewCheckResult> results = new ArrayList<AccessibilityViewCheckResult>(hierarchyCheckResults.size());
        for (AccessibilityHierarchyCheckResult hierarchyCheckResult : hierarchyCheckResults) {
            ViewHierarchyElement element = hierarchyCheckResult.getElement();
            View checkedView = element != null ? (View)mapFromElementIdToView.get((Object)element.getCondensedUniqueId()) : null;
            results.add(new AccessibilityViewCheckResult(toCheck.getClass(), hierarchyCheckResult, checkedView));
        }
        return results;
    }
}

