/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge;

import android.os.Handler_Delegate;
import android.os.SystemClock_Delegate;
import com.android.ide.common.rendering.api.RenderSession;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.Result;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.internal.lang.System_Delegate;
import com.android.internal.util.ArrayUtils_Delegate;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.impl.RenderAction;
import com.android.layoutlib.bridge.impl.RenderSessionImpl;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class BridgeRenderSession
extends RenderSession {
    private final RenderSessionImpl mSession;
    private Result mLastResult;
    private static final Runnable NOOP_RUNNABLE = () -> {};

    public Result getResult() {
        return this.mLastResult;
    }

    public BufferedImage getImage() {
        return this.mSession != null ? this.mSession.getImage() : new BufferedImage(1, 1, 2);
    }

    public List<ViewInfo> getRootViews() {
        return this.mSession != null ? this.mSession.getViewInfos() : Collections.emptyList();
    }

    public List<ViewInfo> getSystemRootViews() {
        return this.mSession != null ? this.mSession.getSystemViewInfos() : Collections.emptyList();
    }

    public Map<Object, Map<ResourceReference, ResourceValue>> getDefaultNamespacedProperties() {
        return this.mSession != null ? this.mSession.getDefaultNamespacedProperties() : Collections.emptyMap();
    }

    public Map<Object, ResourceReference> getDefaultNamespacedStyles() {
        return this.mSession != null ? this.mSession.getDefaultNamespacedStyles() : Collections.emptyMap();
    }

    public Result measure(long timeout) {
        if (this.mSession != null) {
            try {
                Bridge.prepareThread();
                this.mLastResult = this.mSession.acquire(timeout);
                if (this.mLastResult.isSuccess()) {
                    this.mSession.invalidateRenderingSize();
                    this.mLastResult = this.mSession.measure();
                }
            }
            finally {
                this.mSession.release();
                Bridge.cleanupThread();
            }
        }
        return this.mLastResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result render(long timeout, boolean forceMeasure) {
        if (this.mSession != null) {
            try {
                Bridge.prepareThread();
                this.mLastResult = this.mSession.acquire(timeout);
                if (this.mLastResult.isSuccess()) {
                    if (forceMeasure) {
                        this.mSession.invalidateRenderingSize();
                    }
                    this.mLastResult = this.mSession.render(false);
                }
            }
            finally {
                this.mSession.release();
                Bridge.cleanupThread();
            }
        }
        return this.mLastResult;
    }

    public void setSystemTimeNanos(long nanos) {
        this.execute(() -> System_Delegate.setNanosTime(nanos));
    }

    public void setSystemBootTimeNanos(long nanos) {
        this.execute(() -> System_Delegate.setBootTimeNanos(nanos));
    }

    public void setElapsedFrameTimeNanos(long nanos) {
        if (this.mSession != null) {
            this.mSession.setElapsedFrameTimeNanos(nanos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeCallbacks(long nanos) {
        if (this.mSession == null) {
            return false;
        }
        try {
            Bridge.prepareThread();
            this.mLastResult = this.mSession.acquire(250L);
            boolean hasMoreCallbacks = Handler_Delegate.executeCallbacks();
            long currentTimeMs = SystemClock_Delegate.uptimeMillis();
            RenderAction.getCurrentContext().getSessionInteractiveData().getChoreographerCallbacks().execute(currentTimeMs, Bridge.getLog());
            boolean bl = hasMoreCallbacks;
            return bl;
        }
        catch (Throwable t) {
            Bridge.getLog().error("broken", "Failed executing Choreographer#doFrame ", t, null, null);
            boolean bl = false;
            return bl;
        }
        finally {
            this.mSession.release();
            Bridge.cleanupThread();
        }
    }

    private static int toMotionEventType(RenderSession.TouchEventType eventType) {
        switch (eventType) {
            case PRESS: {
                return 0;
            }
            case RELEASE: {
                return 1;
            }
            case DRAG: {
                return 2;
            }
        }
        throw new IllegalStateException("Unexpected touch event type: " + eventType);
    }

    public void triggerTouchEvent(RenderSession.TouchEventType type, int x, int y) {
        this.execute(() -> {
            int motionEventType = BridgeRenderSession.toMotionEventType(type);
            this.mSession.dispatchTouchEvent(motionEventType, System_Delegate.nanoTime(), x, y);
        });
    }

    public void execute(Runnable r) {
        if (this.mSession != null) {
            try {
                Bridge.prepareThread();
                this.mLastResult = this.mSession.acquire(250L);
                r.run();
            }
            finally {
                this.mSession.release();
                Bridge.cleanupThread();
            }
        }
    }

    public void dispose() {
        this.execute(this.mSession::dispose);
        ArrayUtils_Delegate.clearCache();
    }

    BridgeRenderSession(RenderSessionImpl scene, Result lastResult) {
        this.mSession = scene;
        if (scene != null) {
            this.mSession.setScene(this);
        }
        this.mLastResult = lastResult;
    }

    public Object getValidationData() {
        if (this.mSession != null) {
            if (this.mSession.isLayoutValidatorOptimizationEnabled()) {
                return this.mSession.getValidatorHierarchy();
            }
            return this.mSession.getValidatorResult();
        }
        return null;
    }
}

