/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app.chooser;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.ResolveInfo;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.UserHandle;
import com.android.internal.app.ResolverActivity;
import com.android.internal.app.ResolverListAdapter;
import com.android.internal.app.chooser.TargetInfo;
import java.util.ArrayList;
import java.util.List;

public class DisplayResolveInfo
implements TargetInfo {
    private static final boolean ENABLE_CHOOSER_DELEGATE = false;
    private final ResolveInfo mResolveInfo;
    private CharSequence mDisplayLabel;
    private Drawable mDisplayIcon;
    private CharSequence mExtendedInfo;
    private final Intent mResolvedIntent;
    private final List<Intent> mSourceIntents = new ArrayList<Intent>();
    private boolean mIsSuspended;
    private ResolverListAdapter.ResolveInfoPresentationGetter mResolveInfoPresentationGetter;
    private boolean mPinned = false;

    public DisplayResolveInfo(Intent originalIntent, ResolveInfo pri, Intent pOrigIntent, ResolverListAdapter.ResolveInfoPresentationGetter resolveInfoPresentationGetter) {
        this(originalIntent, pri, null, null, pOrigIntent, resolveInfoPresentationGetter);
    }

    public DisplayResolveInfo(Intent originalIntent, ResolveInfo pri, CharSequence pLabel, CharSequence pInfo, Intent resolvedIntent, ResolverListAdapter.ResolveInfoPresentationGetter resolveInfoPresentationGetter) {
        this.mSourceIntents.add(originalIntent);
        this.mResolveInfo = pri;
        this.mDisplayLabel = pLabel;
        this.mExtendedInfo = pInfo;
        this.mResolveInfoPresentationGetter = resolveInfoPresentationGetter;
        Intent intent = new Intent(resolvedIntent);
        intent.addFlags(0x3000000);
        ActivityInfo ai = this.mResolveInfo.activityInfo;
        intent.setComponent(new ComponentName(ai.applicationInfo.packageName, ai.name));
        this.mIsSuspended = (ai.applicationInfo.flags & 0x40000000) != 0;
        this.mResolvedIntent = intent;
    }

    private DisplayResolveInfo(DisplayResolveInfo other, Intent fillInIntent, int flags, ResolverListAdapter.ResolveInfoPresentationGetter resolveInfoPresentationGetter) {
        this.mSourceIntents.addAll(other.getAllSourceIntents());
        this.mResolveInfo = other.mResolveInfo;
        this.mDisplayLabel = other.mDisplayLabel;
        this.mDisplayIcon = other.mDisplayIcon;
        this.mExtendedInfo = other.mExtendedInfo;
        this.mResolvedIntent = new Intent(other.mResolvedIntent);
        this.mResolvedIntent.fillIn(fillInIntent, flags);
        this.mResolveInfoPresentationGetter = resolveInfoPresentationGetter;
    }

    DisplayResolveInfo(DisplayResolveInfo other) {
        this.mSourceIntents.addAll(other.getAllSourceIntents());
        this.mResolveInfo = other.mResolveInfo;
        this.mDisplayLabel = other.mDisplayLabel;
        this.mDisplayIcon = other.mDisplayIcon;
        this.mExtendedInfo = other.mExtendedInfo;
        this.mResolvedIntent = other.mResolvedIntent;
        this.mResolveInfoPresentationGetter = other.mResolveInfoPresentationGetter;
    }

    @Override
    public ResolveInfo getResolveInfo() {
        return this.mResolveInfo;
    }

    @Override
    public CharSequence getDisplayLabel() {
        if (this.mDisplayLabel == null && this.mResolveInfoPresentationGetter != null) {
            this.mDisplayLabel = this.mResolveInfoPresentationGetter.getLabel();
            this.mExtendedInfo = this.mResolveInfoPresentationGetter.getSubLabel();
        }
        return this.mDisplayLabel;
    }

    public boolean hasDisplayLabel() {
        return this.mDisplayLabel != null;
    }

    public void setDisplayLabel(CharSequence displayLabel) {
        this.mDisplayLabel = displayLabel;
    }

    public void setExtendedInfo(CharSequence extendedInfo) {
        this.mExtendedInfo = extendedInfo;
    }

    @Override
    public Drawable getDisplayIcon(Context context) {
        return this.mDisplayIcon;
    }

    @Override
    public TargetInfo cloneFilledIn(Intent fillInIntent, int flags) {
        return new DisplayResolveInfo(this, fillInIntent, flags, this.mResolveInfoPresentationGetter);
    }

    @Override
    public List<Intent> getAllSourceIntents() {
        return this.mSourceIntents;
    }

    public void addAlternateSourceIntent(Intent alt) {
        this.mSourceIntents.add(alt);
    }

    public void setDisplayIcon(Drawable icon) {
        this.mDisplayIcon = icon;
    }

    public boolean hasDisplayIcon() {
        return this.mDisplayIcon != null;
    }

    @Override
    public CharSequence getExtendedInfo() {
        return this.mExtendedInfo;
    }

    @Override
    public Intent getResolvedIntent() {
        return this.mResolvedIntent;
    }

    @Override
    public ComponentName getResolvedComponentName() {
        return new ComponentName(this.mResolveInfo.activityInfo.packageName, this.mResolveInfo.activityInfo.name);
    }

    @Override
    public boolean start(Activity activity, Bundle options) {
        activity.startActivity(this.mResolvedIntent, options);
        return true;
    }

    @Override
    public boolean startAsCaller(ResolverActivity activity, Bundle options, int userId) {
        activity.startActivityAsCaller(this.mResolvedIntent, options, null, false, userId);
        return true;
    }

    @Override
    public boolean startAsUser(Activity activity, Bundle options, UserHandle user) {
        activity.startActivityAsUser(this.mResolvedIntent, options, user);
        return false;
    }

    @Override
    public boolean isSuspended() {
        return this.mIsSuspended;
    }

    @Override
    public boolean isPinned() {
        return this.mPinned;
    }

    public void setPinned(boolean pinned) {
        this.mPinned = pinned;
    }
}

