/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ViewAnimator;

public class ViewSwitcher
extends ViewAnimator {
    ViewFactory mFactory;

    public ViewSwitcher(Context context) {
        super(context);
    }

    public ViewSwitcher(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        if (this.getChildCount() >= 2) {
            throw new IllegalStateException("Can't add more than 2 views to a ViewSwitcher");
        }
        super.addView(child, index, params);
    }

    @Override
    public CharSequence getAccessibilityClassName() {
        return ViewSwitcher.class.getName();
    }

    public View getNextView() {
        int which = this.mWhichChild == 0 ? 1 : 0;
        return this.getChildAt(which);
    }

    private View obtainView() {
        View child = this.mFactory.makeView();
        FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)child.getLayoutParams();
        if (lp == null) {
            lp = new FrameLayout.LayoutParams(-1, -2);
        }
        this.addView(child, lp);
        return child;
    }

    public void setFactory(ViewFactory factory) {
        this.mFactory = factory;
        this.obtainView();
        this.obtainView();
    }

    public void reset() {
        this.mFirstTime = true;
        View v = this.getChildAt(0);
        if (v != null) {
            v.setVisibility(8);
        }
        if ((v = this.getChildAt(1)) != null) {
            v.setVisibility(8);
        }
    }

    public static interface ViewFactory {
        public View makeView();
    }
}

