/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;

public class PinResult
implements Parcelable {
    public static final int PIN_RESULT_TYPE_SUCCESS = 0;
    public static final int PIN_RESULT_TYPE_INCORRECT = 1;
    public static final int PIN_RESULT_TYPE_FAILURE = 2;
    private static final PinResult sFailedResult = new PinResult(2, -1);
    @PinResultType
    private final int mType;
    private final int mAttemptsRemaining;
    public static final Parcelable.Creator<PinResult> CREATOR = new Parcelable.Creator<PinResult>(){

        @Override
        public PinResult createFromParcel(Parcel in) {
            return new PinResult(in);
        }

        public PinResult[] newArray(int size) {
            return new PinResult[size];
        }
    };

    @PinResultType
    public int getType() {
        return this.mType;
    }

    public int getAttemptsRemaining() {
        return this.mAttemptsRemaining;
    }

    public static PinResult getDefaultFailedResult() {
        return sFailedResult;
    }

    public PinResult(@PinResultType int type, int attemptsRemaining) {
        this.mType = type;
        this.mAttemptsRemaining = attemptsRemaining;
    }

    private PinResult(Parcel in) {
        this.mType = in.readInt();
        this.mAttemptsRemaining = in.readInt();
    }

    public String toString() {
        return "type: " + this.getType() + ", attempts remaining: " + this.getAttemptsRemaining();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.mType);
        out.writeInt(this.mAttemptsRemaining);
    }

    public int hashCode() {
        return Objects.hash(this.mAttemptsRemaining, this.mType);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PinResult other = (PinResult)obj;
        return this.mType == other.mType && this.mAttemptsRemaining == other.mAttemptsRemaining;
    }

    public static @interface PinResultType {
    }
}

