/*
 * Decompiled with CFR 0.152.
 */
package android.telecom.Logging;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public abstract class TimedEvent<T> {
    public abstract long getTime();

    public abstract T getKey();

    public static <T> Map<T, Double> averageTimings(Collection<? extends TimedEvent<T>> events) {
        HashMap<T, Integer> counts = new HashMap<T, Integer>();
        HashMap<Object, Double> result = new HashMap<Object, Double>();
        for (TimedEvent<T> timedEvent : events) {
            if (counts.containsKey(timedEvent.getKey())) {
                counts.put(timedEvent.getKey(), (Integer)counts.get(timedEvent.getKey()) + 1);
                result.put(timedEvent.getKey(), (Double)result.get(timedEvent.getKey()) + (double)timedEvent.getTime());
                continue;
            }
            counts.put(timedEvent.getKey(), 1);
            result.put(timedEvent.getKey(), Double.valueOf(timedEvent.getTime()));
        }
        for (Map.Entry entry : result.entrySet()) {
            result.put(entry.getKey(), (Double)entry.getValue() / (double)((Integer)counts.get(entry.getKey())).intValue());
        }
        return result;
    }
}

