/*
 * Decompiled with CFR 0.152.
 */
package android.sysprop;

import android.os.SystemProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Function;

public class InitProperties {
    private InitProperties() {
    }

    private static Boolean tryParseBoolean(String str) {
        switch (str.toLowerCase(Locale.US)) {
            case "1": 
            case "true": {
                return Boolean.TRUE;
            }
            case "0": 
            case "false": {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    private static Integer tryParseInteger(String str) {
        try {
            return Integer.valueOf(str);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static Long tryParseLong(String str) {
        try {
            return Long.valueOf(str);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static Double tryParseDouble(String str) {
        try {
            return Double.valueOf(str);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static String tryParseString(String str) {
        return "".equals(str) ? null : str;
    }

    private static <T extends Enum<T>> T tryParseEnum(Class<T> enumType, String str) {
        try {
            return Enum.valueOf(enumType, str.toUpperCase(Locale.US));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static <T> List<T> tryParseList(Function<String, T> elementParser, String str) {
        if ("".equals(str)) {
            return new ArrayList();
        }
        ArrayList<T> ret = new ArrayList<T>();
        int p = 0;
        while (true) {
            StringBuilder sb = new StringBuilder();
            while (p < str.length() && str.charAt(p) != ',') {
                if (str.charAt(p) == '\\') {
                    ++p;
                }
                if (p == str.length()) break;
                sb.append(str.charAt(p++));
            }
            ret.add(elementParser.apply(sb.toString()));
            if (p == str.length()) break;
            ++p;
        }
        return ret;
    }

    private static <T extends Enum<T>> List<T> tryParseEnumList(Class<T> enumType, String str) {
        if ("".equals(str)) {
            return new ArrayList();
        }
        ArrayList<T> ret = new ArrayList<T>();
        for (String element : str.split(",")) {
            ret.add(InitProperties.tryParseEnum(enumType, element));
        }
        return ret;
    }

    private static String escape(String str) {
        return str.replaceAll("([\\\\,])", "\\\\$1");
    }

    private static <T> String formatList(List<T> list) {
        StringJoiner joiner = new StringJoiner(",");
        for (T element : list) {
            joiner.add(element == null ? "" : InitProperties.escape(element.toString()));
        }
        return joiner.toString();
    }

    private static <T extends Enum<T>> String formatEnumList(List<T> list, Function<T, String> elementFormatter) {
        StringJoiner joiner = new StringJoiner(",");
        for (Enum element : list) {
            joiner.add(element == null ? "" : (CharSequence)elementFormatter.apply(element));
        }
        return joiner.toString();
    }

    public static Optional<Boolean> userspace_reboot_in_progress() {
        String value = SystemProperties.get("sys.init.userspace_reboot.in_progress");
        return Optional.ofNullable(InitProperties.tryParseBoolean(value));
    }

    public static void userspace_reboot_in_progress(Boolean value) {
        SystemProperties.set("sys.init.userspace_reboot.in_progress", value == null ? "" : (value != false ? "1" : "0"));
    }

    public static Optional<Boolean> is_userspace_reboot_supported() {
        String value = SystemProperties.get("init.userspace_reboot.is_supported");
        return Optional.ofNullable(InitProperties.tryParseBoolean(value));
    }
}

