/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.media.AudioAttributes;
import android.os.Binder;
import android.os.IVibratorService;
import android.os.IVibratorStateListener;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.VibrationAttributes;
import android.os.VibrationEffect;
import android.os.Vibrator;
import android.util.ArrayMap;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import java.util.Objects;
import java.util.concurrent.Executor;

public class SystemVibrator
extends Vibrator {
    private static final String TAG = "Vibrator";
    private final IVibratorService mService;
    private final Binder mToken = new Binder();
    private final Context mContext;
    @GuardedBy(value={"mDelegates"})
    private final ArrayMap<Vibrator.OnVibratorStateChangedListener, OnVibratorStateChangedListenerDelegate> mDelegates = new ArrayMap();

    @UnsupportedAppUsage
    public SystemVibrator() {
        this.mContext = null;
        this.mService = IVibratorService.Stub.asInterface(ServiceManager.getService("vibrator"));
    }

    @UnsupportedAppUsage
    public SystemVibrator(Context context) {
        super(context);
        this.mContext = context;
        this.mService = IVibratorService.Stub.asInterface(ServiceManager.getService("vibrator"));
    }

    @Override
    public boolean hasVibrator() {
        if (this.mService == null) {
            Log.w(TAG, "Failed to vibrate; no vibrator service.");
            return false;
        }
        try {
            return this.mService.hasVibrator();
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    @Override
    public boolean isVibrating() {
        if (this.mService == null) {
            Log.w(TAG, "Failed to vibrate; no vibrator service.");
            return false;
        }
        try {
            return this.mService.isVibrating();
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addVibratorStateListener(Executor executor, Vibrator.OnVibratorStateChangedListener listener) {
        Objects.requireNonNull(listener);
        Objects.requireNonNull(executor);
        if (this.mService == null) {
            Log.w(TAG, "Failed to add vibrate state listener; no vibrator service.");
            return;
        }
        ArrayMap<Vibrator.OnVibratorStateChangedListener, OnVibratorStateChangedListenerDelegate> arrayMap = this.mDelegates;
        synchronized (arrayMap) {
            if (this.mDelegates.containsKey(listener)) {
                Log.w(TAG, "Listener already registered.");
                return;
            }
            try {
                OnVibratorStateChangedListenerDelegate delegate = new OnVibratorStateChangedListenerDelegate(listener, executor);
                if (!this.mService.registerVibratorStateListener(delegate)) {
                    Log.w(TAG, "Failed to register vibrate state listener");
                    return;
                }
                this.mDelegates.put(listener, delegate);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @Override
    public void addVibratorStateListener(Vibrator.OnVibratorStateChangedListener listener) {
        Objects.requireNonNull(listener);
        if (this.mContext == null) {
            Log.w(TAG, "Failed to add vibrate state listener; no vibrator context.");
            return;
        }
        this.addVibratorStateListener(this.mContext.getMainExecutor(), listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeVibratorStateListener(Vibrator.OnVibratorStateChangedListener listener) {
        Objects.requireNonNull(listener);
        if (this.mService == null) {
            Log.w(TAG, "Failed to remove vibrate state listener; no vibrator service.");
            return;
        }
        ArrayMap<Vibrator.OnVibratorStateChangedListener, OnVibratorStateChangedListenerDelegate> arrayMap = this.mDelegates;
        synchronized (arrayMap) {
            if (this.mDelegates.containsKey(listener)) {
                OnVibratorStateChangedListenerDelegate delegate = this.mDelegates.get(listener);
                try {
                    if (!this.mService.unregisterVibratorStateListener(delegate)) {
                        Log.w(TAG, "Failed to unregister vibrate state listener");
                        return;
                    }
                    this.mDelegates.remove(listener);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
        }
    }

    @Override
    public boolean hasAmplitudeControl() {
        if (this.mService == null) {
            Log.w(TAG, "Failed to check amplitude control; no vibrator service.");
            return false;
        }
        try {
            return this.mService.hasAmplitudeControl();
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    @Override
    public boolean setAlwaysOnEffect(int uid, String opPkg, int alwaysOnId, VibrationEffect effect, AudioAttributes attributes) {
        if (this.mService == null) {
            Log.w(TAG, "Failed to set always-on effect; no vibrator service.");
            return false;
        }
        try {
            VibrationAttributes atr = new VibrationAttributes.Builder(attributes, effect).build();
            return this.mService.setAlwaysOnEffect(uid, opPkg, alwaysOnId, effect, atr);
        }
        catch (RemoteException e) {
            Log.w(TAG, "Failed to set always-on effect.", e);
            return false;
        }
    }

    @Override
    public void vibrate(int uid, String opPkg, VibrationEffect effect, String reason, AudioAttributes attributes) {
        if (this.mService == null) {
            Log.w(TAG, "Failed to vibrate; no vibrator service.");
            return;
        }
        try {
            if (attributes == null) {
                attributes = new AudioAttributes.Builder().build();
            }
            VibrationAttributes atr = new VibrationAttributes.Builder(attributes, effect).build();
            this.mService.vibrate(uid, opPkg, effect, atr, reason, this.mToken);
        }
        catch (RemoteException e) {
            Log.w(TAG, "Failed to vibrate.", e);
        }
    }

    @Override
    public int[] areEffectsSupported(int ... effectIds) {
        try {
            return this.mService.areEffectsSupported(effectIds);
        }
        catch (RemoteException e) {
            Log.w(TAG, "Failed to query effect support");
            throw e.rethrowAsRuntimeException();
        }
    }

    @Override
    public boolean[] arePrimitivesSupported(int ... primitiveIds) {
        try {
            return this.mService.arePrimitivesSupported(primitiveIds);
        }
        catch (RemoteException e) {
            Log.w(TAG, "Failed to query effect support");
            throw e.rethrowAsRuntimeException();
        }
    }

    @Override
    public void cancel() {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.cancelVibrate(this.mToken);
        }
        catch (RemoteException e) {
            Log.w(TAG, "Failed to cancel vibration.", e);
        }
    }

    private class OnVibratorStateChangedListenerDelegate
    extends IVibratorStateListener.Stub {
        private final Executor mExecutor;
        private final Vibrator.OnVibratorStateChangedListener mListener;

        OnVibratorStateChangedListenerDelegate(Vibrator.OnVibratorStateChangedListener listener, Executor executor) {
            this.mExecutor = executor;
            this.mListener = listener;
        }

        @Override
        public void onVibrating(boolean isVibrating) {
            this.mExecutor.execute(() -> this.mListener.onVibratorStateChanged(isVibrating));
        }
    }
}

