/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.compat.annotation.UnsupportedAppUsage;
import android.os.StrictMode;
import android.os.UserHandle;
import android.os.ZygoteProcess;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.system.StructPollfd;
import android.util.Pair;
import android.webkit.WebViewZygote;
import com.android.internal.lang.System_Delegate;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.system.VMRuntime;
import java.io.FileDescriptor;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import libcore.io.IoUtils;

public class Process {
    private static final String LOG_TAG = "Process";
    public static final int INVALID_UID = -1;
    public static final int ROOT_UID = 0;
    public static final int SYSTEM_UID = 1000;
    public static final int PHONE_UID = 1001;
    public static final int SHELL_UID = 2000;
    @UnsupportedAppUsage
    public static final int LOG_UID = 1007;
    public static final int WIFI_UID = 1010;
    @UnsupportedAppUsage
    public static final int MEDIA_UID = 1013;
    @UnsupportedAppUsage
    public static final int DRM_UID = 1019;
    public static final int SDCARD_RW_GID = 1015;
    @UnsupportedAppUsage
    public static final int VPN_UID = 1016;
    public static final int KEYSTORE_UID = 1017;
    public static final int CREDSTORE_UID = 1076;
    @UnsupportedAppUsage
    public static final int NFC_UID = 1027;
    public static final int CLAT_UID = 1029;
    public static final int BLUETOOTH_UID = 1002;
    public static final int MEDIA_RW_GID = 1023;
    public static final int PACKAGE_INFO_GID = 1032;
    public static final int SHARED_RELRO_UID = 1037;
    public static final int AUDIOSERVER_UID = 1041;
    public static final int CAMERASERVER_UID = 1047;
    public static final int DNS_TETHER_UID = 1052;
    public static final int WEBVIEW_ZYGOTE_UID = 1053;
    public static final int OTA_UPDATE_UID = 1061;
    public static final int STATSD_UID = 1066;
    public static final int INCIDENTD_UID = 1067;
    public static final int SE_UID = 1068;
    public static final int NETWORK_STACK_UID = 1073;
    public static final int FSVERITY_CERT_UID = 1075;
    public static final int EXT_DATA_RW_GID = 1078;
    public static final int EXT_OBB_RW_GID = 1079;
    public static final int INET_GID = 3003;
    public static final int NOBODY_UID = 9999;
    public static final int FIRST_APPLICATION_UID = 10000;
    public static final int LAST_APPLICATION_UID = 19999;
    public static final int FIRST_APP_ZYGOTE_ISOLATED_UID = 90000;
    public static final int NUM_UIDS_PER_APP_ZYGOTE = 100;
    public static final int LAST_APP_ZYGOTE_ISOLATED_UID = 98999;
    @UnsupportedAppUsage
    public static final int FIRST_ISOLATED_UID = 99000;
    @UnsupportedAppUsage
    public static final int LAST_ISOLATED_UID = 99999;
    public static final int SHARED_USER_GID = 9997;
    public static final int FIRST_SHARED_APPLICATION_GID = 50000;
    public static final int LAST_SHARED_APPLICATION_GID = 59999;
    public static final int FIRST_APPLICATION_CACHE_GID = 20000;
    public static final int LAST_APPLICATION_CACHE_GID = 29999;
    public static final int THREAD_PRIORITY_DEFAULT = 0;
    public static final int THREAD_PRIORITY_LOWEST = 19;
    public static final int THREAD_PRIORITY_BACKGROUND = 10;
    public static final int THREAD_PRIORITY_FOREGROUND = -2;
    public static final int THREAD_PRIORITY_DISPLAY = -4;
    public static final int THREAD_PRIORITY_URGENT_DISPLAY = -8;
    public static final int THREAD_PRIORITY_VIDEO = -10;
    public static final int THREAD_PRIORITY_AUDIO = -16;
    public static final int THREAD_PRIORITY_URGENT_AUDIO = -19;
    public static final int THREAD_PRIORITY_MORE_FAVORABLE = -1;
    public static final int THREAD_PRIORITY_LESS_FAVORABLE = 1;
    public static final int SCHED_OTHER = 0;
    public static final int SCHED_FIFO = 1;
    public static final int SCHED_RR = 2;
    public static final int SCHED_BATCH = 3;
    public static final int SCHED_IDLE = 5;
    public static final int SCHED_RESET_ON_FORK = 0x40000000;
    public static final int THREAD_GROUP_DEFAULT = -1;
    public static final int THREAD_GROUP_BACKGROUND = 0;
    private static final int THREAD_GROUP_FOREGROUND = 1;
    public static final int THREAD_GROUP_SYSTEM = 2;
    public static final int THREAD_GROUP_AUDIO_APP = 3;
    public static final int THREAD_GROUP_AUDIO_SYS = 4;
    public static final int THREAD_GROUP_TOP_APP = 5;
    public static final int THREAD_GROUP_RT_APP = 6;
    public static final int THREAD_GROUP_RESTRICTED = 7;
    public static final int SIGNAL_QUIT = 3;
    public static final int SIGNAL_KILL = 9;
    public static final int SIGNAL_USR1 = 10;
    private static long sStartElapsedRealtime;
    private static long sStartUptimeMillis;
    private static final int PIDFD_UNKNOWN = 0;
    private static final int PIDFD_SUPPORTED = 1;
    private static final int PIDFD_UNSUPPORTED = 2;
    private static int sPidFdSupported;
    public static final int ZYGOTE_POLICY_FLAG_EMPTY = 0;
    public static final int ZYGOTE_POLICY_FLAG_LATENCY_SENSITIVE = 1;
    public static final int ZYGOTE_POLICY_FLAG_BATCH_LAUNCH = 2;
    public static final int ZYGOTE_POLICY_FLAG_SYSTEM_PROCESS = 4;
    public static final ZygoteProcess ZYGOTE_PROCESS;
    @UnsupportedAppUsage
    public static final int PROC_TERM_MASK = 255;
    @UnsupportedAppUsage
    public static final int PROC_ZERO_TERM = 0;
    @UnsupportedAppUsage
    public static final int PROC_SPACE_TERM = 32;
    @UnsupportedAppUsage
    public static final int PROC_TAB_TERM = 9;
    public static final int PROC_NEWLINE_TERM = 10;
    @UnsupportedAppUsage
    public static final int PROC_COMBINE = 256;
    @UnsupportedAppUsage
    public static final int PROC_PARENS = 512;
    @UnsupportedAppUsage
    public static final int PROC_QUOTES = 1024;
    public static final int PROC_CHAR = 2048;
    @UnsupportedAppUsage
    public static final int PROC_OUT_STRING = 4096;
    @UnsupportedAppUsage
    public static final int PROC_OUT_LONG = 8192;
    @UnsupportedAppUsage
    public static final int PROC_OUT_FLOAT = 16384;

    public static ProcessStartResult start(String processClass, String niceName, int uid, int gid, int[] gids, int runtimeFlags, int mountExternal, int targetSdkVersion, String seInfo, String abi, String instructionSet, String appDataDir, String invokeWith, String packageName, int zygotePolicyFlags, boolean isTopApp, long[] disabledCompatChanges, Map<String, Pair<String, Long>> pkgDataInfoMap, Map<String, Pair<String, Long>> whitelistedDataInfoMap, boolean bindMountAppsData, boolean bindMountAppStorageDirs, String[] zygoteArgs) {
        return ZYGOTE_PROCESS.start(processClass, niceName, uid, gid, gids, runtimeFlags, mountExternal, targetSdkVersion, seInfo, abi, instructionSet, appDataDir, invokeWith, packageName, zygotePolicyFlags, isTopApp, disabledCompatChanges, pkgDataInfoMap, whitelistedDataInfoMap, bindMountAppsData, bindMountAppStorageDirs, zygoteArgs);
    }

    public static ProcessStartResult startWebView(String processClass, String niceName, int uid, int gid, int[] gids, int runtimeFlags, int mountExternal, int targetSdkVersion, String seInfo, String abi, String instructionSet, String appDataDir, String invokeWith, String packageName, long[] disabledCompatChanges, String[] zygoteArgs) {
        return WebViewZygote.getProcess().start(processClass, niceName, uid, gid, gids, runtimeFlags, mountExternal, targetSdkVersion, seInfo, abi, instructionSet, appDataDir, invokeWith, packageName, 0, false, disabledCompatChanges, null, null, false, false, zygoteArgs);
    }

    public static long getElapsedCpuTime() {
        return OverrideMethod.invokeL("android.os.Process#getElapsedCpuTime()J", true, null);
    }

    public static long getStartElapsedRealtime() {
        return sStartElapsedRealtime;
    }

    public static long getStartUptimeMillis() {
        return sStartUptimeMillis;
    }

    public static void setStartTimes(long elapsedRealtime, long uptimeMillis) {
        sStartElapsedRealtime = elapsedRealtime;
        sStartUptimeMillis = uptimeMillis;
    }

    public static boolean is64Bit() {
        return VMRuntime.getRuntime().is64Bit();
    }

    public static int myPid() {
        return Os.getpid();
    }

    @UnsupportedAppUsage
    public static int myPpid() {
        return Os.getppid();
    }

    public static int myTid() {
        return Os.gettid();
    }

    public static int myUid() {
        return Os.getuid();
    }

    public static UserHandle myUserHandle() {
        return UserHandle.of(UserHandle.getUserId(Process.myUid()));
    }

    public static boolean isCoreUid(int uid) {
        return UserHandle.isCore(uid);
    }

    public static boolean isApplicationUid(int uid) {
        return UserHandle.isApp(uid);
    }

    public static boolean isIsolated() {
        return Process.isIsolated(Process.myUid());
    }

    @UnsupportedAppUsage
    public static boolean isIsolated(int uid) {
        return (uid = UserHandle.getAppId(uid)) >= 99000 && uid <= 99999 || uid >= 90000 && uid <= 98999;
    }

    public static int getUidForName(String string2) {
        return OverrideMethod.invokeI("android.os.Process#getUidForName(Ljava/lang/String;)I", true, null);
    }

    public static int getGidForName(String string2) {
        return OverrideMethod.invokeI("android.os.Process#getGidForName(Ljava/lang/String;)I", true, null);
    }

    @UnsupportedAppUsage
    public static int getUidForPid(int pid) {
        String[] procStatusLabels = new String[]{"Uid:"};
        long[] procStatusValues = new long[]{-1L};
        Process.readProcLines("/proc/" + pid + "/status", procStatusLabels, procStatusValues);
        return (int)procStatusValues[0];
    }

    @UnsupportedAppUsage
    public static int getParentPid(int pid) {
        String[] procStatusLabels = new String[]{"PPid:"};
        long[] procStatusValues = new long[]{-1L};
        Process.readProcLines("/proc/" + pid + "/status", procStatusLabels, procStatusValues);
        return (int)procStatusValues[0];
    }

    public static int getThreadGroupLeader(int tid) {
        String[] procStatusLabels = new String[]{"Tgid:"};
        long[] procStatusValues = new long[]{-1L};
        Process.readProcLines("/proc/" + tid + "/status", procStatusLabels, procStatusValues);
        return (int)procStatusValues[0];
    }

    public static void setThreadPriority(int n, int n2) throws IllegalArgumentException, SecurityException {
        OverrideMethod.invokeV("android.os.Process#setThreadPriority(II)V", true, null);
    }

    public static void setCanSelfBackground(boolean bl) {
        OverrideMethod.invokeV("android.os.Process#setCanSelfBackground(Z)V", true, null);
    }

    public static void setThreadGroup(int n, int n2) throws IllegalArgumentException, SecurityException {
        OverrideMethod.invokeV("android.os.Process#setThreadGroup(II)V", true, null);
    }

    public static void setThreadGroupAndCpuset(int n, int n2) throws IllegalArgumentException, SecurityException {
        OverrideMethod.invokeV("android.os.Process#setThreadGroupAndCpuset(II)V", true, null);
    }

    @UnsupportedAppUsage
    public static void setProcessGroup(int n, int n2) throws IllegalArgumentException, SecurityException {
        OverrideMethod.invokeV("android.os.Process#setProcessGroup(II)V", true, null);
    }

    public static void setProcessFrozen(int n, int n2, boolean bl) {
        OverrideMethod.invokeV("android.os.Process#setProcessFrozen(IIZ)V", true, null);
    }

    public static void enableFreezer(boolean bl) {
        OverrideMethod.invokeV("android.os.Process#enableFreezer(Z)V", true, null);
    }

    public static int getProcessGroup(int n) throws IllegalArgumentException, SecurityException {
        return OverrideMethod.invokeI("android.os.Process#getProcessGroup(I)I", true, null);
    }

    public static int[] getExclusiveCores() {
        return (int[])OverrideMethod.invokeA("android.os.Process#getExclusiveCores()[I", true, null);
    }

    public static void setThreadPriority(int n) throws IllegalArgumentException, SecurityException {
        OverrideMethod.invokeV("android.os.Process#setThreadPriority(I)V", true, null);
    }

    public static int getThreadPriority(int n) throws IllegalArgumentException {
        return OverrideMethod.invokeI("android.os.Process#getThreadPriority(I)I", true, null);
    }

    public static int getThreadScheduler(int n) throws IllegalArgumentException {
        return OverrideMethod.invokeI("android.os.Process#getThreadScheduler(I)I", true, null);
    }

    public static void setThreadScheduler(int n, int n2, int n3) throws IllegalArgumentException {
        OverrideMethod.invokeV("android.os.Process#setThreadScheduler(III)V", true, null);
    }

    @Deprecated
    public static boolean supportsProcesses() {
        return true;
    }

    public static boolean setSwappiness(int n, boolean bl) {
        return OverrideMethod.invokeI("android.os.Process#setSwappiness(IZ)Z", true, null) != 0;
    }

    @UnsupportedAppUsage
    public static void setArgV0(String string2) {
        OverrideMethod.invokeV("android.os.Process#setArgV0(Ljava/lang/String;)V", true, null);
    }

    public static void killProcess(int pid) {
        Process.sendSignal(pid, 9);
    }

    public static int setUid(int n) {
        return OverrideMethod.invokeI("android.os.Process#setUid(I)I", true, null);
    }

    public static int setGid(int n) {
        return OverrideMethod.invokeI("android.os.Process#setGid(I)I", true, null);
    }

    public static void sendSignal(int n, int n2) {
        OverrideMethod.invokeV("android.os.Process#sendSignal(II)V", true, null);
    }

    public static void killProcessQuiet(int pid) {
        Process.sendSignalQuiet(pid, 9);
    }

    @UnsupportedAppUsage(maxTargetSdk=28)
    public static void sendSignalQuiet(int n, int n2) {
        OverrideMethod.invokeV("android.os.Process#sendSignalQuiet(II)V", true, null);
    }

    @UnsupportedAppUsage
    public static long getFreeMemory() {
        return OverrideMethod.invokeL("android.os.Process#getFreeMemory()J", true, null);
    }

    @UnsupportedAppUsage
    public static long getTotalMemory() {
        return OverrideMethod.invokeL("android.os.Process#getTotalMemory()J", true, null);
    }

    @UnsupportedAppUsage
    public static void readProcLines(String string2, String[] stringArray, long[] lArray) {
        OverrideMethod.invokeV("android.os.Process#readProcLines(Ljava/lang/String;[Ljava/lang/String;[J)V", true, null);
    }

    @UnsupportedAppUsage
    public static int[] getPids(String string2, int[] nArray) {
        return (int[])OverrideMethod.invokeA("android.os.Process#getPids(Ljava/lang/String;[I)[I", true, null);
    }

    @UnsupportedAppUsage
    public static boolean readProcFile(String string2, int[] nArray, String[] stringArray, long[] lArray, float[] fArray) {
        return OverrideMethod.invokeI("android.os.Process#readProcFile(Ljava/lang/String;[I[Ljava/lang/String;[J[F)Z", true, null) != 0;
    }

    @UnsupportedAppUsage
    public static boolean parseProcLine(byte[] byArray, int n, int n2, int[] nArray, String[] stringArray, long[] lArray, float[] fArray) {
        return OverrideMethod.invokeI("android.os.Process#parseProcLine([BII[I[Ljava/lang/String;[J[F)Z", true, null) != 0;
    }

    @UnsupportedAppUsage
    public static int[] getPidsForCommands(String[] stringArray) {
        return (int[])OverrideMethod.invokeA("android.os.Process#getPidsForCommands([Ljava/lang/String;)[I", true, null);
    }

    @UnsupportedAppUsage
    public static long getPss(int n) {
        return OverrideMethod.invokeL("android.os.Process#getPss(I)J", true, null);
    }

    public static long[] getRss(int n) {
        return (long[])OverrideMethod.invokeA("android.os.Process#getRss(I)[J", true, null);
    }

    public static int killProcessGroup(int n, int n2) {
        return OverrideMethod.invokeI("android.os.Process#killProcessGroup(II)I", true, null);
    }

    public static void removeAllProcessGroups() {
        OverrideMethod.invokeV("android.os.Process#removeAllProcessGroups()V", true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isThreadInProcess(int tid, int pid) {
        StrictMode.ThreadPolicy oldPolicy = StrictMode.allowThreadDiskReads();
        try {
            if (Os.access("/proc/" + tid + "/task/" + pid, OsConstants.F_OK)) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            StrictMode.setThreadPolicy(oldPolicy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForProcessDeath(int pid, int timeout) throws InterruptedException, TimeoutException {
        boolean fallback;
        FileDescriptor pidfd = null;
        if (sPidFdSupported == 0) {
            int fd = -1;
            try {
                fd = Process.nativePidFdOpen(pid, 0);
                sPidFdSupported = 1;
            }
            catch (ErrnoException e) {
                sPidFdSupported = e.errno != OsConstants.ENOSYS ? 1 : 2;
            }
            finally {
                if (fd >= 0) {
                    pidfd = new FileDescriptor();
                    pidfd.setInt$(fd);
                }
            }
        }
        boolean bl = fallback = sPidFdSupported == 2;
        if (!fallback) {
            try {
                if (pidfd == null) {
                    int fd = Process.nativePidFdOpen(pid, 0);
                    if (fd >= 0) {
                        pidfd = new FileDescriptor();
                        pidfd.setInt$(fd);
                    } else {
                        fallback = true;
                    }
                }
                if (pidfd != null) {
                    StructPollfd[] fds = new StructPollfd[]{new StructPollfd()};
                    fds[0].fd = pidfd;
                    fds[0].events = (short)OsConstants.POLLIN;
                    fds[0].revents = 0;
                    fds[0].userData = null;
                    int res = Os.poll(fds, timeout);
                    if (res > 0) {
                        return;
                    }
                    if (res == 0) {
                        throw new TimeoutException();
                    }
                }
            }
            catch (ErrnoException e) {
                if (e.errno == OsConstants.EINTR) {
                    throw new InterruptedException();
                }
                fallback = true;
            }
            finally {
                if (pidfd != null) {
                    IoUtils.closeQuietly(pidfd);
                }
            }
        }
        if (fallback) {
            boolean infinity = timeout < 0;
            long now = System_Delegate.currentTimeMillis();
            long end = now + (long)timeout;
            while (infinity || now < end) {
                block28: {
                    try {
                        Os.kill(pid, 0);
                    }
                    catch (ErrnoException e) {
                        if (e.errno != OsConstants.ESRCH) break block28;
                        return;
                    }
                }
                Thread.sleep(1L);
                now = System_Delegate.currentTimeMillis();
            }
        }
        throw new TimeoutException();
    }

    private static int nativePidFdOpen(int n, int n2) throws ErrnoException {
        return OverrideMethod.invokeI("android.os.Process#nativePidFdOpen(II)I", true, null);
    }

    static {
        sPidFdSupported = 0;
        ZYGOTE_PROCESS = new ZygoteProcess();
    }

    public static class ProcessStartResult {
        public int pid;
        public boolean usingWrapper;
    }
}

