/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.net.IConnectivityManager;
import android.net.PlatformVpnProfile;
import android.os.RemoteException;
import com.android.internal.net.VpnProfile;
import com.android.internal.util.Preconditions;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.security.GeneralSecurityException;

public class VpnManager {
    public static final int TYPE_VPN_NONE = -1;
    public static final int TYPE_VPN_SERVICE = 1;
    public static final int TYPE_VPN_PLATFORM = 2;
    private final Context mContext;
    private final IConnectivityManager mService;

    private static Intent getIntentForConfirmation() {
        Intent intent = new Intent();
        ComponentName componentName = ComponentName.unflattenFromString(Resources.getSystem().getString(17039945));
        intent.setComponent(componentName);
        return intent;
    }

    public VpnManager(Context ctx, IConnectivityManager service) {
        this.mContext = Preconditions.checkNotNull(ctx, "missing Context");
        this.mService = Preconditions.checkNotNull(service, "missing IConnectivityManager");
    }

    public Intent provisionVpnProfile(PlatformVpnProfile profile) {
        VpnProfile internalProfile;
        try {
            internalProfile = profile.toVpnProfile();
        }
        catch (IOException | GeneralSecurityException e) {
            throw new IllegalArgumentException("Failed to serialize PlatformVpnProfile", e);
        }
        try {
            if (this.mService.provisionVpnProfile(internalProfile, this.mContext.getOpPackageName())) {
                return null;
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        return VpnManager.getIntentForConfirmation();
    }

    public void deleteProvisionedVpnProfile() {
        try {
            this.mService.deleteVpnProfile(this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void startProvisionedVpnProfile() {
        try {
            this.mService.startVpnProfile(this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void stopProvisionedVpnProfile() {
        try {
            this.mService.stopVpnProfile(this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface VpnType {
    }
}

