/*
 * Decompiled with CFR 0.152.
 */
package android.media.audiopolicy;

import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import android.media.AudioAttributes;
import android.os.Parcel;
import android.util.Log;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;

@SystemApi
public class AudioMixingRule {
    public static final int RULE_MATCH_ATTRIBUTE_USAGE = 1;
    public static final int RULE_MATCH_ATTRIBUTE_CAPTURE_PRESET = 2;
    public static final int RULE_MATCH_UID = 4;
    public static final int RULE_MATCH_USERID = 8;
    private static final int RULE_EXCLUSION_MASK = 32768;
    public static final int RULE_EXCLUDE_ATTRIBUTE_USAGE = 32769;
    public static final int RULE_EXCLUDE_ATTRIBUTE_CAPTURE_PRESET = 32770;
    public static final int RULE_EXCLUDE_UID = 32772;
    public static final int RULE_EXCLUDE_USERID = 32776;
    private final int mTargetMixType;
    @UnsupportedAppUsage
    private final ArrayList<AudioMixMatchCriterion> mCriteria;
    @UnsupportedAppUsage
    private boolean mAllowPrivilegedPlaybackCapture = false;
    @UnsupportedAppUsage
    private boolean mVoiceCommunicationCaptureAllowed = false;

    private AudioMixingRule(int mixType, ArrayList<AudioMixMatchCriterion> criteria, boolean allowPrivilegedPlaybackCapture, boolean voiceCommunicationCaptureAllowed) {
        this.mCriteria = criteria;
        this.mTargetMixType = mixType;
        this.mAllowPrivilegedPlaybackCapture = allowPrivilegedPlaybackCapture;
        this.mVoiceCommunicationCaptureAllowed = voiceCommunicationCaptureAllowed;
    }

    boolean isAffectingUsage(int usage) {
        for (AudioMixMatchCriterion criterion : this.mCriteria) {
            if ((criterion.mRule & 1) == 0 || criterion.mAttr == null || criterion.mAttr.getUsage() != usage) continue;
            return true;
        }
        return false;
    }

    boolean containsMatchAttributeRuleForUsage(int usage) {
        for (AudioMixMatchCriterion criterion : this.mCriteria) {
            if (criterion.mRule != 1 || criterion.mAttr == null || criterion.mAttr.getUsage() != usage) continue;
            return true;
        }
        return false;
    }

    private static boolean areCriteriaEquivalent(ArrayList<AudioMixMatchCriterion> cr1, ArrayList<AudioMixMatchCriterion> cr2) {
        if (cr1 == null || cr2 == null) {
            return false;
        }
        if (cr1 == cr2) {
            return true;
        }
        if (cr1.size() != cr2.size()) {
            return false;
        }
        return cr1.hashCode() == cr2.hashCode();
    }

    int getTargetMixType() {
        return this.mTargetMixType;
    }

    public ArrayList<AudioMixMatchCriterion> getCriteria() {
        return this.mCriteria;
    }

    public boolean allowPrivilegedPlaybackCapture() {
        return this.mAllowPrivilegedPlaybackCapture;
    }

    public boolean voiceCommunicationCaptureAllowed() {
        return this.mVoiceCommunicationCaptureAllowed;
    }

    public void setVoiceCommunicationCaptureAllowed(boolean allowed) {
        this.mVoiceCommunicationCaptureAllowed = allowed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AudioMixingRule that = (AudioMixingRule)o;
        return this.mTargetMixType == that.mTargetMixType && AudioMixingRule.areCriteriaEquivalent(this.mCriteria, that.mCriteria) && this.mAllowPrivilegedPlaybackCapture == that.mAllowPrivilegedPlaybackCapture && this.mVoiceCommunicationCaptureAllowed == that.mVoiceCommunicationCaptureAllowed;
    }

    public int hashCode() {
        return Objects.hash(this.mTargetMixType, this.mCriteria, this.mAllowPrivilegedPlaybackCapture, this.mVoiceCommunicationCaptureAllowed);
    }

    private static boolean isValidSystemApiRule(int rule) {
        switch (rule) {
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    private static boolean isValidAttributesSystemApiRule(int rule) {
        switch (rule) {
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    private static boolean isValidRule(int rule) {
        int match_rule = rule & 0xFFFF7FFF;
        switch (match_rule) {
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    private static boolean isPlayerRule(int rule) {
        int match_rule = rule & 0xFFFF7FFF;
        switch (match_rule) {
            case 1: 
            case 4: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    private static boolean isAudioAttributeRule(int match_rule) {
        switch (match_rule) {
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    public static class Builder {
        private ArrayList<AudioMixMatchCriterion> mCriteria = new ArrayList();
        private int mTargetMixType = -1;
        private boolean mAllowPrivilegedPlaybackCapture = false;
        private boolean mVoiceCommunicationCaptureAllowed = false;

        public Builder addRule(AudioAttributes attrToMatch, int rule) throws IllegalArgumentException {
            if (!AudioMixingRule.isValidAttributesSystemApiRule(rule)) {
                throw new IllegalArgumentException("Illegal rule value " + rule);
            }
            return this.checkAddRuleObjInternal(rule, attrToMatch);
        }

        public Builder excludeRule(AudioAttributes attrToMatch, int rule) throws IllegalArgumentException {
            if (!AudioMixingRule.isValidAttributesSystemApiRule(rule)) {
                throw new IllegalArgumentException("Illegal rule value " + rule);
            }
            return this.checkAddRuleObjInternal(rule | 0x8000, attrToMatch);
        }

        public Builder addMixRule(int rule, Object property) throws IllegalArgumentException {
            if (!AudioMixingRule.isValidSystemApiRule(rule)) {
                throw new IllegalArgumentException("Illegal rule value " + rule);
            }
            return this.checkAddRuleObjInternal(rule, property);
        }

        public Builder excludeMixRule(int rule, Object property) throws IllegalArgumentException {
            if (!AudioMixingRule.isValidSystemApiRule(rule)) {
                throw new IllegalArgumentException("Illegal rule value " + rule);
            }
            return this.checkAddRuleObjInternal(rule | 0x8000, property);
        }

        public Builder allowPrivilegedPlaybackCapture(boolean allow) {
            this.mAllowPrivilegedPlaybackCapture = allow;
            return this;
        }

        public Builder voiceCommunicationCaptureAllowed(boolean allowed) {
            this.mVoiceCommunicationCaptureAllowed = allowed;
            return this;
        }

        private Builder checkAddRuleObjInternal(int rule, Object property) throws IllegalArgumentException {
            if (property == null) {
                throw new IllegalArgumentException("Illegal null argument for mixing rule");
            }
            if (!AudioMixingRule.isValidRule(rule)) {
                throw new IllegalArgumentException("Illegal rule value " + rule);
            }
            int match_rule = rule & 0xFFFF7FFF;
            if (AudioMixingRule.isAudioAttributeRule(match_rule)) {
                if (!(property instanceof AudioAttributes)) {
                    throw new IllegalArgumentException("Invalid AudioAttributes argument");
                }
                return this.addRuleInternal((AudioAttributes)property, null, rule);
            }
            if (!(property instanceof Integer)) {
                throw new IllegalArgumentException("Invalid Integer argument");
            }
            return this.addRuleInternal(null, (Integer)property, rule);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Builder addRuleInternal(AudioAttributes attrToMatch, Integer intProp, int rule) throws IllegalArgumentException {
            if (this.mTargetMixType == -1) {
                this.mTargetMixType = AudioMixingRule.isPlayerRule(rule) ? 0 : 1;
            } else if (this.mTargetMixType == 0 && !AudioMixingRule.isPlayerRule(rule) || this.mTargetMixType == 1 && AudioMixingRule.isPlayerRule(rule)) {
                throw new IllegalArgumentException("Incompatible rule for mix");
            }
            ArrayList<AudioMixMatchCriterion> arrayList = this.mCriteria;
            synchronized (arrayList) {
                Iterator<AudioMixMatchCriterion> crIterator = this.mCriteria.iterator();
                int match_rule = rule & 0xFFFF7FFF;
                while (crIterator.hasNext()) {
                    AudioMixMatchCriterion criterion = crIterator.next();
                    if ((criterion.mRule & 0xFFFF7FFF) != match_rule) continue;
                    switch (match_rule) {
                        case 1: {
                            if (criterion.mAttr.getUsage() != attrToMatch.getUsage()) break;
                            if (criterion.mRule == rule) {
                                return this;
                            }
                            throw new IllegalArgumentException("Contradictory rule exists for " + attrToMatch);
                        }
                        case 2: {
                            if (criterion.mAttr.getCapturePreset() != attrToMatch.getCapturePreset()) break;
                            if (criterion.mRule == rule) {
                                return this;
                            }
                            throw new IllegalArgumentException("Contradictory rule exists for " + attrToMatch);
                        }
                        case 4: {
                            if (criterion.mIntProp != intProp) break;
                            if (criterion.mRule == rule) {
                                return this;
                            }
                            throw new IllegalArgumentException("Contradictory rule exists for UID " + intProp);
                        }
                        case 8: {
                            if (criterion.mIntProp != intProp) break;
                            if (criterion.mRule == rule) {
                                return this;
                            }
                            throw new IllegalArgumentException("Contradictory rule exists for userId " + intProp);
                        }
                    }
                }
                switch (match_rule) {
                    case 1: 
                    case 2: {
                        this.mCriteria.add(new AudioMixMatchCriterion(attrToMatch, rule));
                        break;
                    }
                    case 4: 
                    case 8: {
                        this.mCriteria.add(new AudioMixMatchCriterion(intProp, rule));
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unreachable code in addRuleInternal()");
                    }
                }
            }
            return this;
        }

        Builder addRuleFromParcel(Parcel in) throws IllegalArgumentException {
            int rule = in.readInt();
            int match_rule = rule & 0xFFFF7FFF;
            AudioAttributes attr2 = null;
            Integer intProp = null;
            switch (match_rule) {
                case 1: {
                    int usage = in.readInt();
                    attr2 = new AudioAttributes.Builder().setUsage(usage).build();
                    break;
                }
                case 2: {
                    int preset = in.readInt();
                    attr2 = new AudioAttributes.Builder().setInternalCapturePreset(preset).build();
                    break;
                }
                case 4: 
                case 8: {
                    intProp = new Integer(in.readInt());
                    break;
                }
                default: {
                    in.readInt();
                    throw new IllegalArgumentException("Illegal rule value " + rule + " in parcel");
                }
            }
            return this.addRuleInternal(attr2, intProp, rule);
        }

        public AudioMixingRule build() {
            return new AudioMixingRule(this.mTargetMixType, this.mCriteria, this.mAllowPrivilegedPlaybackCapture, this.mVoiceCommunicationCaptureAllowed);
        }
    }

    public static class AudioMixMatchCriterion {
        @UnsupportedAppUsage
        final AudioAttributes mAttr;
        @UnsupportedAppUsage
        final int mIntProp;
        @UnsupportedAppUsage
        final int mRule;

        AudioMixMatchCriterion(AudioAttributes attributes, int rule) {
            this.mAttr = attributes;
            this.mIntProp = Integer.MIN_VALUE;
            this.mRule = rule;
        }

        AudioMixMatchCriterion(Integer intProp, int rule) {
            this.mAttr = null;
            this.mIntProp = intProp;
            this.mRule = rule;
        }

        public int hashCode() {
            return Objects.hash(this.mAttr, this.mIntProp, this.mRule);
        }

        void writeToParcel(Parcel dest) {
            dest.writeInt(this.mRule);
            int match_rule = this.mRule & 0xFFFF7FFF;
            switch (match_rule) {
                case 1: {
                    dest.writeInt(this.mAttr.getUsage());
                    break;
                }
                case 2: {
                    dest.writeInt(this.mAttr.getCapturePreset());
                    break;
                }
                case 4: 
                case 8: {
                    dest.writeInt(this.mIntProp);
                    break;
                }
                default: {
                    Log.e("AudioMixMatchCriterion", "Unknown match rule" + match_rule + " when writing to Parcel");
                    dest.writeInt(-1);
                }
            }
        }

        public AudioAttributes getAudioAttributes() {
            return this.mAttr;
        }

        public int getIntProp() {
            return this.mIntProp;
        }

        public int getRule() {
            return this.mRule;
        }
    }
}

