/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class GnssAntennaInfo
implements Parcelable {
    private final double mCarrierFrequencyMHz;
    private final PhaseCenterOffset mPhaseCenterOffset;
    private final SphericalCorrections mPhaseCenterVariationCorrections;
    private final SphericalCorrections mSignalGainCorrections;
    public static final Parcelable.Creator<GnssAntennaInfo> CREATOR = new Parcelable.Creator<GnssAntennaInfo>(){

        @Override
        public GnssAntennaInfo createFromParcel(Parcel in) {
            double carrierFrequencyMHz = in.readDouble();
            ClassLoader classLoader = this.getClass().getClassLoader();
            PhaseCenterOffset phaseCenterOffset = (PhaseCenterOffset)in.readParcelable(classLoader);
            SphericalCorrections phaseCenterVariationCorrections = (SphericalCorrections)in.readParcelable(classLoader);
            SphericalCorrections signalGainCorrections = (SphericalCorrections)in.readParcelable(classLoader);
            return new GnssAntennaInfo(carrierFrequencyMHz, phaseCenterOffset, phaseCenterVariationCorrections, signalGainCorrections);
        }

        public GnssAntennaInfo[] newArray(int size) {
            return new GnssAntennaInfo[size];
        }
    };

    private GnssAntennaInfo(double carrierFrequencyMHz, PhaseCenterOffset phaseCenterOffset, SphericalCorrections phaseCenterVariationCorrections, SphericalCorrections signalGainCorrectionDbi) {
        if (phaseCenterOffset == null) {
            throw new IllegalArgumentException("Phase Center Offset Coordinates cannot be null.");
        }
        this.mCarrierFrequencyMHz = carrierFrequencyMHz;
        this.mPhaseCenterOffset = phaseCenterOffset;
        this.mPhaseCenterVariationCorrections = phaseCenterVariationCorrections;
        this.mSignalGainCorrections = signalGainCorrectionDbi;
    }

    public double getCarrierFrequencyMHz() {
        return this.mCarrierFrequencyMHz;
    }

    public PhaseCenterOffset getPhaseCenterOffset() {
        return this.mPhaseCenterOffset;
    }

    public SphericalCorrections getPhaseCenterVariationCorrections() {
        return this.mPhaseCenterVariationCorrections;
    }

    public SphericalCorrections getSignalGainCorrections() {
        return this.mSignalGainCorrections;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeDouble(this.mCarrierFrequencyMHz);
        parcel.writeParcelable(this.mPhaseCenterOffset, flags);
        parcel.writeParcelable(this.mPhaseCenterVariationCorrections, flags);
        parcel.writeParcelable(this.mSignalGainCorrections, flags);
    }

    public String toString() {
        return "GnssAntennaInfo{CarrierFrequencyMHz=" + this.mCarrierFrequencyMHz + ", PhaseCenterOffset=" + this.mPhaseCenterOffset + ", PhaseCenterVariationCorrections=" + this.mPhaseCenterVariationCorrections + ", SignalGainCorrections=" + this.mSignalGainCorrections + '}';
    }

    public static class Builder {
        private double mCarrierFrequencyMHz;
        private PhaseCenterOffset mPhaseCenterOffset;
        private SphericalCorrections mPhaseCenterVariationCorrections;
        private SphericalCorrections mSignalGainCorrections;

        public Builder setCarrierFrequencyMHz(double carrierFrequencyMHz) {
            this.mCarrierFrequencyMHz = carrierFrequencyMHz;
            return this;
        }

        public Builder setPhaseCenterOffset(PhaseCenterOffset phaseCenterOffset) {
            this.mPhaseCenterOffset = Objects.requireNonNull(phaseCenterOffset);
            return this;
        }

        public Builder setPhaseCenterVariationCorrections(SphericalCorrections phaseCenterVariationCorrections) {
            this.mPhaseCenterVariationCorrections = phaseCenterVariationCorrections;
            return this;
        }

        public Builder setSignalGainCorrections(SphericalCorrections signalGainCorrections) {
            this.mSignalGainCorrections = signalGainCorrections;
            return this;
        }

        public GnssAntennaInfo build() {
            return new GnssAntennaInfo(this.mCarrierFrequencyMHz, this.mPhaseCenterOffset, this.mPhaseCenterVariationCorrections, this.mSignalGainCorrections);
        }
    }

    public static class SphericalCorrections
    implements Parcelable {
        private final double[][] mCorrections;
        private final double[][] mCorrectionUncertainties;
        private final double mDeltaTheta;
        private final double mDeltaPhi;
        private final int mNumRows;
        private final int mNumColumns;
        public static final Parcelable.Creator<SphericalCorrections> CREATOR = new Parcelable.Creator<SphericalCorrections>(){

            @Override
            public SphericalCorrections createFromParcel(Parcel in) {
                return new SphericalCorrections(in);
            }

            public SphericalCorrections[] newArray(int size) {
                return new SphericalCorrections[size];
            }
        };

        public SphericalCorrections(double[][] corrections, double[][] correctionUncertainties) {
            if (corrections.length != correctionUncertainties.length || corrections[0].length != correctionUncertainties[0].length) {
                throw new IllegalArgumentException("Correction and correction uncertainty arrays must have the same dimensions.");
            }
            this.mNumRows = corrections.length;
            if (this.mNumRows < 1) {
                throw new IllegalArgumentException("Arrays must have at least one row.");
            }
            this.mNumColumns = corrections[0].length;
            if (this.mNumColumns < 2) {
                throw new IllegalArgumentException("Arrays must have at least two columns.");
            }
            this.mCorrections = corrections;
            this.mCorrectionUncertainties = correctionUncertainties;
            this.mDeltaTheta = 360.0 / (double)this.mNumRows;
            this.mDeltaPhi = 180.0 / (double)(this.mNumColumns - 1);
        }

        SphericalCorrections(Parcel in) {
            int row;
            int numRows = in.readInt();
            int numColumns = in.readInt();
            double[][] corrections = new double[numRows][numColumns];
            double[][] correctionUncertainties = new double[numRows][numColumns];
            for (row = 0; row < numRows; ++row) {
                in.readDoubleArray(corrections[row]);
            }
            for (row = 0; row < numRows; ++row) {
                in.readDoubleArray(correctionUncertainties[row]);
            }
            this.mNumRows = numRows;
            this.mNumColumns = numColumns;
            this.mCorrections = corrections;
            this.mCorrectionUncertainties = correctionUncertainties;
            this.mDeltaTheta = 360.0 / (double)this.mNumRows;
            this.mDeltaPhi = 180.0 / (double)(this.mNumColumns - 1);
        }

        public double[][] getCorrectionsArray() {
            return this.mCorrections;
        }

        public double[][] getCorrectionUncertaintiesArray() {
            return this.mCorrectionUncertainties;
        }

        public double getDeltaTheta() {
            return this.mDeltaTheta;
        }

        public double getDeltaPhi() {
            return this.mDeltaPhi;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mNumRows);
            dest.writeInt(this.mNumColumns);
            for (double[] row : this.mCorrections) {
                dest.writeDoubleArray(row);
            }
            for (double[] row : this.mCorrectionUncertainties) {
                dest.writeDoubleArray(row);
            }
        }

        public String toString() {
            return "SphericalCorrections{Corrections=" + Arrays.toString((Object[])this.mCorrections) + ", CorrectionUncertainties=" + Arrays.toString((Object[])this.mCorrectionUncertainties) + ", DeltaTheta=" + this.mDeltaTheta + ", DeltaPhi=" + this.mDeltaPhi + '}';
        }
    }

    public static class PhaseCenterOffset
    implements Parcelable {
        private final double mOffsetXMm;
        private final double mOffsetXUncertaintyMm;
        private final double mOffsetYMm;
        private final double mOffsetYUncertaintyMm;
        private final double mOffsetZMm;
        private final double mOffsetZUncertaintyMm;
        public static final Parcelable.Creator<PhaseCenterOffset> CREATOR = new Parcelable.Creator<PhaseCenterOffset>(){

            @Override
            public PhaseCenterOffset createFromParcel(Parcel in) {
                return new PhaseCenterOffset(in.readDouble(), in.readDouble(), in.readDouble(), in.readDouble(), in.readDouble(), in.readDouble());
            }

            public PhaseCenterOffset[] newArray(int size) {
                return new PhaseCenterOffset[size];
            }
        };

        public PhaseCenterOffset(double offsetXMm, double offsetXUncertaintyMm, double offsetYMm, double offsetYUncertaintyMm, double offsetZMm, double offsetZUncertaintyMm) {
            this.mOffsetXMm = offsetXMm;
            this.mOffsetYMm = offsetYMm;
            this.mOffsetZMm = offsetZMm;
            this.mOffsetXUncertaintyMm = offsetXUncertaintyMm;
            this.mOffsetYUncertaintyMm = offsetYUncertaintyMm;
            this.mOffsetZUncertaintyMm = offsetZUncertaintyMm;
        }

        public double getXOffsetMm() {
            return this.mOffsetXMm;
        }

        public double getXOffsetUncertaintyMm() {
            return this.mOffsetXUncertaintyMm;
        }

        public double getYOffsetMm() {
            return this.mOffsetYMm;
        }

        public double getYOffsetUncertaintyMm() {
            return this.mOffsetYUncertaintyMm;
        }

        public double getZOffsetMm() {
            return this.mOffsetZMm;
        }

        public double getZOffsetUncertaintyMm() {
            return this.mOffsetZUncertaintyMm;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeDouble(this.mOffsetXMm);
            dest.writeDouble(this.mOffsetXUncertaintyMm);
            dest.writeDouble(this.mOffsetYMm);
            dest.writeDouble(this.mOffsetYUncertaintyMm);
            dest.writeDouble(this.mOffsetZMm);
            dest.writeDouble(this.mOffsetZUncertaintyMm);
        }

        public String toString() {
            return "PhaseCenterOffset{OffsetXMm=" + this.mOffsetXMm + " +/-" + this.mOffsetXUncertaintyMm + ", OffsetYMm=" + this.mOffsetYMm + " +/-" + this.mOffsetYUncertaintyMm + ", OffsetZMm=" + this.mOffsetZMm + " +/-" + this.mOffsetZUncertaintyMm + '}';
        }
    }

    public static interface Listener {
        public void onGnssAntennaInfoReceived(List<GnssAntennaInfo> var1);
    }
}

