/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.face;

import android.hardware.face.Face;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IFaceServiceReceiver
extends IInterface {
    public void onEnrollResult(long var1, int var3, int var4) throws RemoteException;

    public void onAcquired(long var1, int var3, int var4) throws RemoteException;

    public void onAuthenticationSucceeded(long var1, Face var3, int var4, boolean var5) throws RemoteException;

    public void onAuthenticationFailed(long var1) throws RemoteException;

    public void onError(long var1, int var3, int var4) throws RemoteException;

    public void onRemoved(long var1, int var3, int var4) throws RemoteException;

    public void onEnumerated(long var1, int var3, int var4) throws RemoteException;

    public void onFeatureSet(boolean var1, int var2) throws RemoteException;

    public void onFeatureGet(boolean var1, int var2, boolean var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IFaceServiceReceiver {
        private static final String DESCRIPTOR = "android.hardware.face.IFaceServiceReceiver";
        static final int TRANSACTION_onEnrollResult = 1;
        static final int TRANSACTION_onAcquired = 2;
        static final int TRANSACTION_onAuthenticationSucceeded = 3;
        static final int TRANSACTION_onAuthenticationFailed = 4;
        static final int TRANSACTION_onError = 5;
        static final int TRANSACTION_onRemoved = 6;
        static final int TRANSACTION_onEnumerated = 7;
        static final int TRANSACTION_onFeatureSet = 8;
        static final int TRANSACTION_onFeatureGet = 9;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IFaceServiceReceiver asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IFaceServiceReceiver) {
                return (IFaceServiceReceiver)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onEnrollResult";
                }
                case 2: {
                    return "onAcquired";
                }
                case 3: {
                    return "onAuthenticationSucceeded";
                }
                case 4: {
                    return "onAuthenticationFailed";
                }
                case 5: {
                    return "onError";
                }
                case 6: {
                    return "onRemoved";
                }
                case 7: {
                    return "onEnumerated";
                }
                case 8: {
                    return "onFeatureSet";
                }
                case 9: {
                    return "onFeatureGet";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 1: {
                    data.enforceInterface(descriptor);
                    long _arg0 = data.readLong();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    this.onEnrollResult(_arg0, _arg1, _arg2);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    long _arg0 = data.readLong();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    this.onAcquired(_arg0, _arg1, _arg2);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    long _arg0 = data.readLong();
                    Face _arg1 = 0 != data.readInt() ? Face.CREATOR.createFromParcel(data) : null;
                    int _arg2 = data.readInt();
                    boolean _arg3 = 0 != data.readInt();
                    this.onAuthenticationSucceeded(_arg0, _arg1, _arg2, _arg3);
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    long _arg0 = data.readLong();
                    this.onAuthenticationFailed(_arg0);
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    long _arg0 = data.readLong();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    this.onError(_arg0, _arg1, _arg2);
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    long _arg0 = data.readLong();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    this.onRemoved(_arg0, _arg1, _arg2);
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    long _arg0 = data.readLong();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    this.onEnumerated(_arg0, _arg1, _arg2);
                    return true;
                }
                case 8: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    int _arg1 = data.readInt();
                    this.onFeatureSet(_arg0, _arg1);
                    return true;
                }
                case 9: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    int _arg1 = data.readInt();
                    boolean _arg2 = 0 != data.readInt();
                    this.onFeatureGet(_arg0, _arg1, _arg2);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IFaceServiceReceiver impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IFaceServiceReceiver getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IFaceServiceReceiver {
            private IBinder mRemote;
            public static IFaceServiceReceiver sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onEnrollResult(long deviceId, int faceId, int remaining) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(deviceId);
                    _data.writeInt(faceId);
                    _data.writeInt(remaining);
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onEnrollResult(deviceId, faceId, remaining);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAcquired(long deviceId, int acquiredInfo, int vendorCode) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(deviceId);
                    _data.writeInt(acquiredInfo);
                    _data.writeInt(vendorCode);
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onAcquired(deviceId, acquiredInfo, vendorCode);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAuthenticationSucceeded(long deviceId, Face face, int userId, boolean isStrongBiometric) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(deviceId);
                    if (face != null) {
                        _data.writeInt(1);
                        face.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(userId);
                    _data.writeInt(isStrongBiometric ? 1 : 0);
                    boolean _status = this.mRemote.transact(3, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onAuthenticationSucceeded(deviceId, face, userId, isStrongBiometric);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAuthenticationFailed(long deviceId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(deviceId);
                    boolean _status = this.mRemote.transact(4, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onAuthenticationFailed(deviceId);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(long deviceId, int error, int vendorCode) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(deviceId);
                    _data.writeInt(error);
                    _data.writeInt(vendorCode);
                    boolean _status = this.mRemote.transact(5, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onError(deviceId, error, vendorCode);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRemoved(long deviceId, int faceId, int remaining) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(deviceId);
                    _data.writeInt(faceId);
                    _data.writeInt(remaining);
                    boolean _status = this.mRemote.transact(6, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onRemoved(deviceId, faceId, remaining);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onEnumerated(long deviceId, int faceId, int remaining) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(deviceId);
                    _data.writeInt(faceId);
                    _data.writeInt(remaining);
                    boolean _status = this.mRemote.transact(7, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onEnumerated(deviceId, faceId, remaining);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFeatureSet(boolean success, int feature) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(success ? 1 : 0);
                    _data.writeInt(feature);
                    boolean _status = this.mRemote.transact(8, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onFeatureSet(success, feature);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFeatureGet(boolean success, int feature, boolean value) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(success ? 1 : 0);
                    _data.writeInt(feature);
                    _data.writeInt(value ? 1 : 0);
                    boolean _status = this.mRemote.transact(9, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onFeatureGet(success, feature, value);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IFaceServiceReceiver {
        @Override
        public void onEnrollResult(long deviceId, int faceId, int remaining) throws RemoteException {
        }

        @Override
        public void onAcquired(long deviceId, int acquiredInfo, int vendorCode) throws RemoteException {
        }

        @Override
        public void onAuthenticationSucceeded(long deviceId, Face face, int userId, boolean isStrongBiometric) throws RemoteException {
        }

        @Override
        public void onAuthenticationFailed(long deviceId) throws RemoteException {
        }

        @Override
        public void onError(long deviceId, int error, int vendorCode) throws RemoteException {
        }

        @Override
        public void onRemoved(long deviceId, int faceId, int remaining) throws RemoteException {
        }

        @Override
        public void onEnumerated(long deviceId, int faceId, int remaining) throws RemoteException {
        }

        @Override
        public void onFeatureSet(boolean success, int feature) throws RemoteException {
        }

        @Override
        public void onFeatureGet(boolean success, int feature, boolean value) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

