/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.animation.Animator;
import android.animation.StateListAnimator;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.pm.ActivityInfo;
import android.content.res.AssetFileDescriptor;
import android.content.res.AssetManager;
import android.content.res.ColorStateList;
import android.content.res.CompatibilityInfo;
import android.content.res.ComplexColor;
import android.content.res.Configuration;
import android.content.res.ConfigurationBoundResourceCache;
import android.content.res.ConstantState;
import android.content.res.DrawableCache;
import android.content.res.FontResourcesParser;
import android.content.res.GradientColor;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlBlock;
import android.content.res.XmlResourceParser;
import android.graphics.Bitmap;
import android.graphics.ImageDecoder;
import android.graphics.Typeface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.ColorStateListDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.DrawableContainer;
import android.icu.text.PluralRules;
import android.os.LocaleList;
import android.os.Process;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.Trace;
import android.os._Original_Build;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.LongSparseArray;
import android.util.TypedValue;
import android.util.Xml;
import android.view.DisplayAdjustments;
import com.android.internal.lang.System_Delegate;
import com.android.internal.util.GrowingArrayUtils;
import com.android.tools.layoutlib.java.util.LocaleAdjustLanguageCodeReplacement;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Locale;
import org.xmlpull.v1.XmlPullParserException;

public class ResourcesImpl {
    static final String TAG = "Resources";
    private static final boolean DEBUG_LOAD = false;
    private static final boolean DEBUG_CONFIG = false;
    static final String TAG_PRELOAD = "Resources.preload";
    @UnsupportedAppUsage
    private static final boolean TRACE_FOR_PRELOAD = false;
    @UnsupportedAppUsage
    private static final boolean TRACE_FOR_MISS_PRELOAD = false;
    public static final boolean TRACE_FOR_DETAILED_PRELOAD = SystemProperties.getBoolean("debug.trace_resource_preload", false);
    private static int sPreloadTracingNumLoadedDrawables;
    private long mPreloadTracingPreloadStartTime;
    private long mPreloadTracingStartBitmapSize;
    private long mPreloadTracingStartBitmapCount;
    private static final int ID_OTHER = 0x1000004;
    private static final Object sSync;
    private static boolean sPreloaded;
    @UnsupportedAppUsage
    private boolean mPreloading;
    @UnsupportedAppUsage
    private static final LongSparseArray<Drawable.ConstantState>[] sPreloadedDrawables;
    @UnsupportedAppUsage
    private static final LongSparseArray<Drawable.ConstantState> sPreloadedColorDrawables;
    @UnsupportedAppUsage
    private static final LongSparseArray<ConstantState<ComplexColor>> sPreloadedComplexColors;
    @UnsupportedAppUsage
    private final Object mAccessLock = new Object();
    private final Configuration mTmpConfig = new Configuration();
    @UnsupportedAppUsage
    private final DrawableCache mDrawableCache = new DrawableCache();
    @UnsupportedAppUsage
    private final DrawableCache mColorDrawableCache = new DrawableCache();
    private final ConfigurationBoundResourceCache<ComplexColor> mComplexColorCache = new ConfigurationBoundResourceCache();
    @UnsupportedAppUsage
    private final ConfigurationBoundResourceCache<Animator> mAnimatorCache = new ConfigurationBoundResourceCache();
    @UnsupportedAppUsage
    private final ConfigurationBoundResourceCache<StateListAnimator> mStateListAnimatorCache = new ConfigurationBoundResourceCache();
    private final ThreadLocal<LookupStack> mLookupStack = ThreadLocal.withInitial(() -> new LookupStack());
    private static final int XML_BLOCK_CACHE_SIZE = 4;
    private int mLastCachedXmlBlockIndex = -1;
    private final int[] mCachedXmlBlockCookies = new int[4];
    private final String[] mCachedXmlBlockFiles = new String[4];
    private final XmlBlock[] mCachedXmlBlocks = new XmlBlock[4];
    @UnsupportedAppUsage
    final AssetManager mAssets;
    private final DisplayMetrics mMetrics = new DisplayMetrics();
    private final DisplayAdjustments mDisplayAdjustments;
    private PluralRules mPluralRule;
    @UnsupportedAppUsage
    private final Configuration mConfiguration = new Configuration();

    @UnsupportedAppUsage
    public ResourcesImpl(AssetManager assets, DisplayMetrics metrics, Configuration config, DisplayAdjustments displayAdjustments) {
        this.mAssets = assets;
        this.mMetrics.setToDefaults();
        this.mDisplayAdjustments = displayAdjustments;
        this.mConfiguration.setToDefaults();
        this.updateConfiguration(config, metrics, displayAdjustments.getCompatibilityInfo());
    }

    public DisplayAdjustments getDisplayAdjustments() {
        return this.mDisplayAdjustments;
    }

    @UnsupportedAppUsage
    public AssetManager getAssets() {
        return this.mAssets;
    }

    @UnsupportedAppUsage
    DisplayMetrics getDisplayMetrics() {
        return this.mMetrics;
    }

    Configuration getConfiguration() {
        return this.mConfiguration;
    }

    Configuration[] getSizeConfigurations() {
        return this.mAssets.getSizeConfigurations();
    }

    CompatibilityInfo getCompatibilityInfo() {
        return this.mDisplayAdjustments.getCompatibilityInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PluralRules getPluralRule() {
        Object object = sSync;
        synchronized (object) {
            if (this.mPluralRule == null) {
                this.mPluralRule = PluralRules.forLocale(this.mConfiguration.getLocales().get(0));
            }
            return this.mPluralRule;
        }
    }

    @UnsupportedAppUsage
    void getValue(int id2, TypedValue outValue, boolean resolveRefs) throws Resources.NotFoundException {
        boolean found = this.mAssets.getResourceValue(id2, 0, outValue, resolveRefs);
        if (found) {
            return;
        }
        throw new Resources.NotFoundException("Resource ID #0x" + Integer.toHexString(id2));
    }

    void getValueForDensity(int id2, int density, TypedValue outValue, boolean resolveRefs) throws Resources.NotFoundException {
        boolean found = this.mAssets.getResourceValue(id2, density, outValue, resolveRefs);
        if (found) {
            return;
        }
        throw new Resources.NotFoundException("Resource ID #0x" + Integer.toHexString(id2));
    }

    void getValue(String name, TypedValue outValue, boolean resolveRefs) throws Resources.NotFoundException {
        int id2 = this.getIdentifier(name, "string", null);
        if (id2 != 0) {
            this.getValue(id2, outValue, resolveRefs);
            return;
        }
        throw new Resources.NotFoundException("String resource name " + name);
    }

    int getIdentifier(String name, String defType, String defPackage) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        try {
            return Integer.parseInt(name);
        }
        catch (Exception exception) {
            return this.mAssets.getResourceIdentifier(name, defType, defPackage);
        }
    }

    String getResourceName(int resid) throws Resources.NotFoundException {
        String str = this.mAssets.getResourceName(resid);
        if (str != null) {
            return str;
        }
        throw new Resources.NotFoundException("Unable to find resource ID #0x" + Integer.toHexString(resid));
    }

    String getResourcePackageName(int resid) throws Resources.NotFoundException {
        String str = this.mAssets.getResourcePackageName(resid);
        if (str != null) {
            return str;
        }
        throw new Resources.NotFoundException("Unable to find resource ID #0x" + Integer.toHexString(resid));
    }

    String getResourceTypeName(int resid) throws Resources.NotFoundException {
        String str = this.mAssets.getResourceTypeName(resid);
        if (str != null) {
            return str;
        }
        throw new Resources.NotFoundException("Unable to find resource ID #0x" + Integer.toHexString(resid));
    }

    String getResourceEntryName(int resid) throws Resources.NotFoundException {
        String str = this.mAssets.getResourceEntryName(resid);
        if (str != null) {
            return str;
        }
        throw new Resources.NotFoundException("Unable to find resource ID #0x" + Integer.toHexString(resid));
    }

    String getLastResourceResolution() throws Resources.NotFoundException {
        String str = this.mAssets.getLastResourceResolution();
        if (str != null) {
            return str;
        }
        throw new Resources.NotFoundException("Associated AssetManager hasn't resolved a resource");
    }

    CharSequence getQuantityText(int id2, int quantity) throws Resources.NotFoundException {
        PluralRules rule = this.getPluralRule();
        CharSequence res = this.mAssets.getResourceBagText(id2, ResourcesImpl.attrForQuantityCode(rule.select(quantity)));
        if (res != null) {
            return res;
        }
        res = this.mAssets.getResourceBagText(id2, 0x1000004);
        if (res != null) {
            return res;
        }
        throw new Resources.NotFoundException("Plural resource ID #0x" + Integer.toHexString(id2) + " quantity=" + quantity + " item=" + rule.select(quantity));
    }

    private static int attrForQuantityCode(String quantityCode) {
        switch (quantityCode) {
            case "zero": {
                return 0x1000005;
            }
            case "one": {
                return 0x1000006;
            }
            case "two": {
                return 0x1000007;
            }
            case "few": {
                return 0x1000008;
            }
            case "many": {
                return 0x1000009;
            }
        }
        return 0x1000004;
    }

    AssetFileDescriptor openRawResourceFd(int id2, TypedValue tempValue) throws Resources.NotFoundException {
        this.getValue(id2, tempValue, true);
        try {
            return this.mAssets.openNonAssetFd(tempValue.assetCookie, tempValue.string.toString());
        }
        catch (Exception e) {
            throw new Resources.NotFoundException("File " + tempValue.string.toString() + " from resource ID #0x" + Integer.toHexString(id2), e);
        }
    }

    InputStream openRawResource(int id2, TypedValue value) throws Resources.NotFoundException {
        this.getValue(id2, value, true);
        try {
            return this.mAssets.openNonAsset(value.assetCookie, value.string.toString(), 2);
        }
        catch (Exception e) {
            Resources.NotFoundException rnf = new Resources.NotFoundException("File " + (value.string == null ? "(null)" : value.string.toString()) + " from resource ID #0x" + Integer.toHexString(id2));
            rnf.initCause(e);
            throw rnf;
        }
    }

    ConfigurationBoundResourceCache<Animator> getAnimatorCache() {
        return this.mAnimatorCache;
    }

    ConfigurationBoundResourceCache<StateListAnimator> getStateListAnimatorCache() {
        return this.mStateListAnimatorCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateConfiguration(Configuration config, DisplayMetrics metrics, CompatibilityInfo compat) {
        Trace.traceBegin(8192L, "ResourcesImpl#updateConfiguration");
        try {
            Object object = this.mAccessLock;
            synchronized (object) {
                int height;
                int width;
                if (compat != null) {
                    this.mDisplayAdjustments.setCompatibilityInfo(compat);
                }
                if (metrics != null) {
                    this.mMetrics.setTo(metrics);
                }
                this.mDisplayAdjustments.getCompatibilityInfo().applyToDisplayMetrics(this.mMetrics);
                int configChanges = this.calcConfigChanges(config);
                LocaleList locales = this.mConfiguration.getLocales();
                if (locales.isEmpty()) {
                    locales = LocaleList.getDefault();
                    this.mConfiguration.setLocales(locales);
                }
                if ((configChanges & 4) != 0 && locales.size() > 1) {
                    Locale bestLocale;
                    String[] availableLocales = this.mAssets.getNonSystemLocales();
                    if (LocaleList.isPseudoLocalesOnly(availableLocales) && LocaleList.isPseudoLocalesOnly(availableLocales = this.mAssets.getLocales())) {
                        availableLocales = null;
                    }
                    if (availableLocales != null && (bestLocale = locales.getFirstMatchWithEnglishSupported(availableLocales)) != null && bestLocale != locales.get(0)) {
                        this.mConfiguration.setLocales(new LocaleList(bestLocale, locales));
                    }
                }
                if (this.mConfiguration.densityDpi != 0) {
                    this.mMetrics.densityDpi = this.mConfiguration.densityDpi;
                    this.mMetrics.density = (float)this.mConfiguration.densityDpi * 0.00625f;
                }
                this.mMetrics.scaledDensity = this.mMetrics.density * (this.mConfiguration.fontScale != 0.0f ? this.mConfiguration.fontScale : 1.0f);
                if (this.mMetrics.widthPixels >= this.mMetrics.heightPixels) {
                    width = this.mMetrics.widthPixels;
                    height = this.mMetrics.heightPixels;
                } else {
                    width = this.mMetrics.heightPixels;
                    height = this.mMetrics.widthPixels;
                }
                int keyboardHidden = this.mConfiguration.keyboardHidden == 1 && this.mConfiguration.hardKeyboardHidden == 2 ? 3 : this.mConfiguration.keyboardHidden;
                this.mAssets.setConfiguration(this.mConfiguration.mcc, this.mConfiguration.mnc, ResourcesImpl.adjustLanguageTag(this.mConfiguration.getLocales().get(0).toLanguageTag()), this.mConfiguration.orientation, this.mConfiguration.touchscreen, this.mConfiguration.densityDpi, this.mConfiguration.keyboard, keyboardHidden, this.mConfiguration.navigation, width, height, this.mConfiguration.smallestScreenWidthDp, this.mConfiguration.screenWidthDp, this.mConfiguration.screenHeightDp, this.mConfiguration.screenLayout, this.mConfiguration.uiMode, this.mConfiguration.colorMode, _Original_Build.VERSION.RESOURCES_SDK_INT);
                this.mDrawableCache.onConfigurationChange(configChanges);
                this.mColorDrawableCache.onConfigurationChange(configChanges);
                this.mComplexColorCache.onConfigurationChange(configChanges);
                this.mAnimatorCache.onConfigurationChange(configChanges);
                this.mStateListAnimatorCache.onConfigurationChange(configChanges);
                this.flushLayoutCache();
            }
            object = sSync;
            synchronized (object) {
                if (this.mPluralRule != null) {
                    this.mPluralRule = PluralRules.forLocale(this.mConfiguration.getLocales().get(0));
                }
            }
        }
        finally {
            Trace.traceEnd(8192L);
        }
    }

    public int calcConfigChanges(Configuration config) {
        if (config == null) {
            return -1;
        }
        this.mTmpConfig.setTo(config);
        int density = config.densityDpi;
        if (density == 0) {
            density = this.mMetrics.noncompatDensityDpi;
        }
        this.mDisplayAdjustments.getCompatibilityInfo().applyToConfiguration(density, this.mTmpConfig);
        if (this.mTmpConfig.getLocales().isEmpty()) {
            this.mTmpConfig.setLocales(LocaleList.getDefault());
        }
        return this.mConfiguration.updateFrom(this.mTmpConfig);
    }

    private static String adjustLanguageTag(String languageTag) {
        String remainder;
        String language;
        int separator = languageTag.indexOf(45);
        if (separator == -1) {
            language = languageTag;
            remainder = "";
        } else {
            language = languageTag.substring(0, separator);
            remainder = languageTag.substring(separator);
        }
        return LocaleAdjustLanguageCodeReplacement.adjustLanguageCode(language) + remainder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushLayoutCache() {
        XmlBlock[] xmlBlockArray = this.mCachedXmlBlocks;
        synchronized (this.mCachedXmlBlocks) {
            Arrays.fill(this.mCachedXmlBlockCookies, 0);
            Arrays.fill(this.mCachedXmlBlockFiles, null);
            Object[] cachedXmlBlocks = this.mCachedXmlBlocks;
            for (int i = 0; i < 4; ++i) {
                XmlBlock oldBlock = cachedXmlBlocks[i];
                if (oldBlock == null) continue;
                oldBlock.close();
            }
            Arrays.fill(cachedXmlBlocks, null);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAllCaches() {
        Object object = this.mAccessLock;
        synchronized (object) {
            this.mDrawableCache.clear();
            this.mColorDrawableCache.clear();
            this.mComplexColorCache.clear();
            this.mAnimatorCache.clear();
            this.mStateListAnimatorCache.clear();
            this.flushLayoutCache();
        }
    }

    Drawable loadDrawable(Resources wrapper, TypedValue value, int id2, int density, Resources.Theme theme) throws Resources.NotFoundException {
        boolean useCache;
        boolean bl = useCache = density == 0 || value.density == this.mMetrics.densityDpi;
        if (density > 0 && value.density > 0 && value.density != 65535) {
            value.density = value.density == density ? this.mMetrics.densityDpi : value.density * this.mMetrics.densityDpi / density;
        }
        try {
            boolean canApplyTheme;
            Drawable dr;
            Drawable cachedDrawable;
            long key;
            DrawableCache caches;
            boolean isColorDrawable;
            if (value.type >= 28 && value.type <= 31) {
                isColorDrawable = true;
                caches = this.mColorDrawableCache;
                key = value.data;
            } else {
                isColorDrawable = false;
                caches = this.mDrawableCache;
                key = (long)value.assetCookie << 32 | (long)value.data;
            }
            if (!this.mPreloading && useCache && (cachedDrawable = caches.getInstance(key, wrapper, theme)) != null) {
                cachedDrawable.setChangingConfigurations(value.changingConfigurations);
                return cachedDrawable;
            }
            Drawable.ConstantState cs = isColorDrawable ? sPreloadedColorDrawables.get(key) : sPreloadedDrawables[this.mConfiguration.getLayoutDirection()].get(key);
            boolean needsNewDrawableAfterCache = false;
            if (cs != null) {
                String name;
                if (TRACE_FOR_DETAILED_PRELOAD && id2 >>> 24 == 1 && Process.myUid() != 0 && (name = this.getResourceName(id2)) != null) {
                    Log.d(TAG_PRELOAD, "Hit preloaded FW drawable #" + Integer.toHexString(id2) + " " + name);
                }
                dr = cs.newDrawable(wrapper);
            } else {
                dr = isColorDrawable ? new ColorDrawable(value.data) : this.loadDrawableForCookie(wrapper, value, id2, density);
            }
            if (dr instanceof DrawableContainer) {
                needsNewDrawableAfterCache = true;
            }
            boolean bl2 = canApplyTheme = dr != null && dr.canApplyTheme();
            if (canApplyTheme && theme != null) {
                dr = dr.mutate();
                dr.applyTheme(theme);
                dr.clearMutated();
            }
            if (dr != null) {
                dr.setChangingConfigurations(value.changingConfigurations);
                if (useCache) {
                    Drawable.ConstantState state;
                    this.cacheDrawable(value, isColorDrawable, caches, theme, canApplyTheme, key, dr);
                    if (needsNewDrawableAfterCache && (state = dr.getConstantState()) != null) {
                        dr = state.newDrawable(wrapper);
                    }
                }
            }
            return dr;
        }
        catch (Exception e) {
            String name;
            try {
                name = this.getResourceName(id2);
            }
            catch (Resources.NotFoundException e2) {
                name = "(missing name)";
            }
            Resources.NotFoundException nfe = new Resources.NotFoundException("Drawable " + name + " with resource ID #0x" + Integer.toHexString(id2), e);
            nfe.setStackTrace(new StackTraceElement[0]);
            throw nfe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheDrawable(TypedValue value, boolean isColorDrawable, DrawableCache caches, Resources.Theme theme, boolean usesTheme, long key, Drawable dr) {
        Drawable.ConstantState cs = dr.getConstantState();
        if (cs == null) {
            return;
        }
        if (this.mPreloading) {
            int changingConfigs = cs.getChangingConfigurations();
            if (isColorDrawable) {
                if (this.verifyPreloadConfig(changingConfigs, 0, value.resourceId, "drawable")) {
                    sPreloadedColorDrawables.put(key, cs);
                }
            } else if (this.verifyPreloadConfig(changingConfigs, 8192, value.resourceId, "drawable")) {
                if ((changingConfigs & 0x2000) == 0) {
                    sPreloadedDrawables[0].put(key, cs);
                    sPreloadedDrawables[1].put(key, cs);
                } else {
                    sPreloadedDrawables[this.mConfiguration.getLayoutDirection()].put(key, cs);
                }
            }
        } else {
            Object object = this.mAccessLock;
            synchronized (object) {
                caches.put(key, theme, cs, usesTheme);
            }
        }
    }

    private boolean verifyPreloadConfig(int changingConfigurations, int allowVarying, int resourceId, String name) {
        if ((changingConfigurations & 0xBFFFEFFF & ~allowVarying) != 0) {
            String resName;
            try {
                resName = this.getResourceName(resourceId);
            }
            catch (Resources.NotFoundException e) {
                resName = "?";
            }
            Log.w(TAG, "Preloaded " + name + " resource #0x" + Integer.toHexString(resourceId) + " (" + resName + ") that varies with configuration!!");
            return false;
        }
        return true;
    }

    private Drawable decodeImageDrawable(AssetManager.AssetInputStream ais, Resources wrapper, TypedValue value) {
        ImageDecoder.AssetInputStreamSource src = new ImageDecoder.AssetInputStreamSource(ais, wrapper, value);
        try {
            return ImageDecoder.decodeDrawable(src, (decoder, info, s) -> decoder.setAllocator(1));
        }
        catch (IOException ioe) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Drawable loadDrawableForCookie(Resources wrapper, TypedValue value, int id2, int density) {
        String name;
        Drawable dr;
        if (value.string == null) {
            throw new Resources.NotFoundException("Resource \"" + this.getResourceName(id2) + "\" (" + Integer.toHexString(id2) + ") is not a Drawable (color or path): " + value);
        }
        String file = value.string.toString();
        long startTime = 0L;
        int startBitmapCount = 0;
        long startBitmapSize = 0L;
        int startDrawableCount = 0;
        if (TRACE_FOR_DETAILED_PRELOAD) {
            startTime = System_Delegate.nanoTime();
            startBitmapCount = Bitmap.sPreloadTracingNumInstantiatedBitmaps;
            startBitmapSize = Bitmap.sPreloadTracingTotalBitmapsSize;
            startDrawableCount = sPreloadTracingNumLoadedDrawables;
        }
        Trace.traceBegin(8192L, file);
        LookupStack stack = this.mLookupStack.get();
        try {
            if (stack.contains(id2)) {
                throw new Exception("Recursive reference in drawable");
            }
            stack.push(id2);
            try {
                if (file.endsWith(".xml")) {
                    String typeName = this.getResourceTypeName(id2);
                    dr = typeName != null && typeName.equals("color") ? this.loadColorOrXmlDrawable(wrapper, value, id2, density, file) : this.loadXmlDrawable(wrapper, value, id2, density, file);
                } else {
                    InputStream is = this.mAssets.openNonAsset(value.assetCookie, file, 2);
                    AssetManager.AssetInputStream ais = (AssetManager.AssetInputStream)is;
                    dr = this.decodeImageDrawable(ais, wrapper, value);
                }
            }
            finally {
                stack.pop();
            }
        }
        catch (Exception | StackOverflowError e) {
            Trace.traceEnd(8192L);
            Resources.NotFoundException rnf = new Resources.NotFoundException("File " + file + " from drawable resource ID #0x" + Integer.toHexString(id2));
            rnf.initCause(e);
            throw rnf;
        }
        Trace.traceEnd(8192L);
        if (TRACE_FOR_DETAILED_PRELOAD && id2 >>> 24 == 1 && (name = this.getResourceName(id2)) != null) {
            long time = System_Delegate.nanoTime() - startTime;
            int loadedBitmapCount = Bitmap.sPreloadTracingNumInstantiatedBitmaps - startBitmapCount;
            long loadedBitmapSize = Bitmap.sPreloadTracingTotalBitmapsSize - startBitmapSize;
            int loadedDrawables = sPreloadTracingNumLoadedDrawables - startDrawableCount;
            ++sPreloadTracingNumLoadedDrawables;
            boolean isRoot = Process.myUid() == 0;
            Log.d(TAG_PRELOAD, (isRoot ? "Preloaded FW drawable #" : "Loaded non-preloaded FW drawable #") + Integer.toHexString(id2) + " " + name + " " + file + " " + dr.getClass().getCanonicalName() + " #nested_drawables= " + loadedDrawables + " #bitmaps= " + loadedBitmapCount + " total_bitmap_size= " + loadedBitmapSize + " in[us] " + time / 1000L);
        }
        return dr;
    }

    private Drawable loadColorOrXmlDrawable(Resources wrapper, TypedValue value, int id2, int density, String file) {
        try {
            ColorStateList csl = this.loadColorStateList(wrapper, value, id2, null);
            return new ColorStateListDrawable(csl);
        }
        catch (Resources.NotFoundException originalException) {
            try {
                return this.loadXmlDrawable(wrapper, value, id2, density, file);
            }
            catch (Exception ignored) {
                throw originalException;
            }
        }
    }

    private Drawable loadXmlDrawable(Resources wrapper, TypedValue value, int id2, int density, String file) throws IOException, XmlPullParserException {
        try (XmlResourceParser rp = this.loadXmlResourceParser(file, id2, value.assetCookie, "drawable");){
            Drawable drawable2 = Drawable.createFromXmlForDensity(wrapper, rp, density, null);
            return drawable2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Typeface loadFont(Resources wrapper, TypedValue value, int id2) {
        if (value.string == null) {
            throw new Resources.NotFoundException("Resource \"" + this.getResourceName(id2) + "\" (" + Integer.toHexString(id2) + ") is not a Font: " + value);
        }
        String file = value.string.toString();
        if (!file.startsWith("res/")) {
            return null;
        }
        Typeface cached = Typeface.findFromCache(this.mAssets, file);
        if (cached != null) {
            return cached;
        }
        Trace.traceBegin(8192L, file);
        try {
            if (file.endsWith("xml")) {
                XmlResourceParser rp = this.loadXmlResourceParser(file, id2, value.assetCookie, "font");
                FontResourcesParser.FamilyResourceEntry familyEntry = FontResourcesParser.parse(rp, wrapper);
                if (familyEntry == null) {
                    Typeface typeface = null;
                    return typeface;
                }
                Typeface typeface = Typeface.createFromResources(familyEntry, this.mAssets, file);
                return typeface;
            }
            Typeface rp = new Typeface.Builder(this.mAssets, file, false, value.assetCookie).build();
            return rp;
        }
        catch (XmlPullParserException e) {
            Log.e(TAG, "Failed to parse xml resource " + file, e);
        }
        catch (IOException e) {
            Log.e(TAG, "Failed to read xml resource " + file, e);
        }
        finally {
            Trace.traceEnd(8192L);
        }
        return null;
    }

    private ComplexColor loadComplexColorFromName(Resources wrapper, Resources.Theme theme, TypedValue value, int id2) {
        ConfigurationBoundResourceCache<ComplexColor> cache = this.mComplexColorCache;
        long key = (long)value.assetCookie << 32 | (long)value.data;
        ComplexColor complexColor = cache.getInstance(key, wrapper, theme);
        if (complexColor != null) {
            return complexColor;
        }
        ConstantState<ComplexColor> factory = sPreloadedComplexColors.get(key);
        if (factory != null) {
            complexColor = factory.newInstance(wrapper, theme);
        }
        if (complexColor == null) {
            complexColor = this.loadComplexColorForCookie(wrapper, value, id2, theme);
        }
        if (complexColor != null) {
            complexColor.setBaseChangingConfigurations(value.changingConfigurations);
            if (this.mPreloading) {
                if (this.verifyPreloadConfig(complexColor.getChangingConfigurations(), 0, value.resourceId, "color")) {
                    sPreloadedComplexColors.put(key, complexColor.getConstantState());
                }
            } else {
                cache.put(key, theme, complexColor.getConstantState());
            }
        }
        return complexColor;
    }

    ComplexColor loadComplexColor(Resources wrapper, TypedValue value, int id2, Resources.Theme theme) {
        ComplexColor complexColor;
        long key = (long)value.assetCookie << 32 | (long)value.data;
        if (value.type >= 28 && value.type <= 31) {
            return this.getColorStateListFromInt(value, key);
        }
        String file = value.string.toString();
        if (file.endsWith(".xml")) {
            try {
                complexColor = this.loadComplexColorFromName(wrapper, theme, value, id2);
            }
            catch (Exception e) {
                Resources.NotFoundException rnf = new Resources.NotFoundException("File " + file + " from complex color resource ID #0x" + Integer.toHexString(id2));
                rnf.initCause(e);
                throw rnf;
            }
        } else {
            throw new Resources.NotFoundException("File " + file + " from drawable resource ID #0x" + Integer.toHexString(id2) + ": .xml extension required");
        }
        return complexColor;
    }

    ColorStateList loadColorStateList(Resources wrapper, TypedValue value, int id2, Resources.Theme theme) throws Resources.NotFoundException {
        long key = (long)value.assetCookie << 32 | (long)value.data;
        if (value.type >= 28 && value.type <= 31) {
            return this.getColorStateListFromInt(value, key);
        }
        ComplexColor complexColor = this.loadComplexColorFromName(wrapper, theme, value, id2);
        if (complexColor != null && complexColor instanceof ColorStateList) {
            return (ColorStateList)complexColor;
        }
        throw new Resources.NotFoundException("Can't find ColorStateList from drawable resource ID #0x" + Integer.toHexString(id2));
    }

    private ColorStateList getColorStateListFromInt(TypedValue value, long key) {
        ConstantState<ComplexColor> factory = sPreloadedComplexColors.get(key);
        if (factory != null) {
            return (ColorStateList)factory.newInstance();
        }
        ColorStateList csl = ColorStateList.valueOf(value.data);
        if (this.mPreloading && this.verifyPreloadConfig(value.changingConfigurations, 0, value.resourceId, "color")) {
            sPreloadedComplexColors.put(key, csl.getConstantState());
        }
        return csl;
    }

    private ComplexColor loadComplexColorForCookie(Resources wrapper, TypedValue value, int id2, Resources.Theme theme) {
        if (value.string == null) {
            throw new UnsupportedOperationException("Can't convert to ComplexColor: type=0x" + value.type);
        }
        String file = value.string.toString();
        ComplexColor complexColor = null;
        Trace.traceBegin(8192L, file);
        if (file.endsWith(".xml")) {
            try {
                int type;
                XmlResourceParser parser = this.loadXmlResourceParser(file, id2, value.assetCookie, "ComplexColor");
                AttributeSet attrs = Xml.asAttributeSet(parser);
                while ((type = parser.next()) != 2 && type != 1) {
                }
                if (type != 2) {
                    throw new XmlPullParserException("No start tag found");
                }
                String name = parser.getName();
                if (name.equals("gradient")) {
                    complexColor = GradientColor.createFromXmlInner(wrapper, parser, attrs, theme);
                } else if (name.equals("selector")) {
                    complexColor = ColorStateList.createFromXmlInner(wrapper, parser, attrs, theme);
                }
                parser.close();
            }
            catch (Exception e) {
                Trace.traceEnd(8192L);
                Resources.NotFoundException rnf = new Resources.NotFoundException("File " + file + " from ComplexColor resource ID #0x" + Integer.toHexString(id2));
                rnf.initCause(e);
                throw rnf;
            }
        } else {
            Trace.traceEnd(8192L);
            throw new Resources.NotFoundException("File " + file + " from drawable resource ID #0x" + Integer.toHexString(id2) + ": .xml extension required");
        }
        Trace.traceEnd(8192L);
        return complexColor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    XmlResourceParser loadXmlResourceParser(String file, int id2, int assetCookie, String type) throws Resources.NotFoundException {
        if (id2 != 0) {
            try {
                XmlBlock[] xmlBlockArray = this.mCachedXmlBlocks;
                synchronized (this.mCachedXmlBlocks) {
                    int[] cachedXmlBlockCookies = this.mCachedXmlBlockCookies;
                    String[] cachedXmlBlockFiles = this.mCachedXmlBlockFiles;
                    XmlBlock[] cachedXmlBlocks = this.mCachedXmlBlocks;
                    int num = cachedXmlBlockFiles.length;
                    for (int i = 0; i < num; ++i) {
                        if (cachedXmlBlockCookies[i] != assetCookie || cachedXmlBlockFiles[i] == null || !cachedXmlBlockFiles[i].equals(file)) continue;
                        // ** MonitorExit[var5_5] (shouldn't be in output)
                        return cachedXmlBlocks[i].newParser(id2);
                    }
                    XmlBlock block = this.mAssets.openXmlBlockAsset(assetCookie, file);
                    if (block != null) {
                        int pos;
                        this.mLastCachedXmlBlockIndex = pos = (this.mLastCachedXmlBlockIndex + 1) % num;
                        XmlBlock oldBlock = cachedXmlBlocks[pos];
                        if (oldBlock != null) {
                            oldBlock.close();
                        }
                        cachedXmlBlockCookies[pos] = assetCookie;
                        cachedXmlBlockFiles[pos] = file;
                        cachedXmlBlocks[pos] = block;
                        // ** MonitorExit[var5_5] (shouldn't be in output)
                        return block.newParser(id2);
                    }
                    // ** MonitorExit[var5_5] (shouldn't be in output)
                }
            }
            catch (Exception e) {
                Resources.NotFoundException rnf = new Resources.NotFoundException("File " + file + " from xml type " + type + " resource ID #0x" + Integer.toHexString(id2));
                rnf.initCause(e);
                throw rnf;
            }
        }
        {
            throw new Resources.NotFoundException("File " + file + " from xml type " + type + " resource ID #0x" + Integer.toHexString(id2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startPreloading() {
        Object object = sSync;
        synchronized (object) {
            if (sPreloaded) {
                throw new IllegalStateException("Resources already preloaded");
            }
            sPreloaded = true;
            this.mPreloading = true;
            this.mConfiguration.densityDpi = DisplayMetrics.DENSITY_DEVICE;
            this.updateConfiguration(null, null, null);
            if (TRACE_FOR_DETAILED_PRELOAD) {
                this.mPreloadTracingPreloadStartTime = SystemClock.uptimeMillis();
                this.mPreloadTracingStartBitmapSize = Bitmap.sPreloadTracingTotalBitmapsSize;
                this.mPreloadTracingStartBitmapCount = Bitmap.sPreloadTracingNumInstantiatedBitmaps;
                Log.d(TAG_PRELOAD, "Preload starting");
            }
        }
    }

    void finishPreloading() {
        if (this.mPreloading) {
            if (TRACE_FOR_DETAILED_PRELOAD) {
                long time = SystemClock.uptimeMillis() - this.mPreloadTracingPreloadStartTime;
                long size = Bitmap.sPreloadTracingTotalBitmapsSize - this.mPreloadTracingStartBitmapSize;
                long count = (long)Bitmap.sPreloadTracingNumInstantiatedBitmaps - this.mPreloadTracingStartBitmapCount;
                Log.d(TAG_PRELOAD, "Preload finished, " + count + " bitmaps of " + size + " bytes in " + time + " ms");
            }
            this.mPreloading = false;
            this.flushLayoutCache();
        }
    }

    static int getAttributeSetSourceResId(AttributeSet set) {
        if (set == null || !(set instanceof XmlBlock.Parser)) {
            return 0;
        }
        return ((XmlBlock.Parser)set).getSourceResId();
    }

    LongSparseArray<Drawable.ConstantState> getPreloadedDrawables() {
        return sPreloadedDrawables[0];
    }

    ThemeImpl newThemeImpl() {
        return new ThemeImpl();
    }

    ThemeImpl newThemeImpl(Resources.ThemeKey key) {
        ThemeImpl impl = new ThemeImpl();
        impl.mKey.setTo(key);
        impl.rebase();
        return impl;
    }

    static {
        sSync = new Object();
        sPreloadedColorDrawables = new LongSparseArray();
        sPreloadedComplexColors = new LongSparseArray();
        sPreloadedDrawables = new LongSparseArray[2];
        ResourcesImpl.sPreloadedDrawables[0] = new LongSparseArray();
        ResourcesImpl.sPreloadedDrawables[1] = new LongSparseArray();
    }

    private static class LookupStack {
        private int[] mIds = new int[4];
        private int mSize = 0;

        private LookupStack() {
        }

        public void push(int id2) {
            this.mIds = GrowingArrayUtils.append(this.mIds, this.mSize, id2);
            ++this.mSize;
        }

        public boolean contains(int id2) {
            for (int i = 0; i < this.mSize; ++i) {
                if (this.mIds[i] != id2) continue;
                return true;
            }
            return false;
        }

        public void pop() {
            --this.mSize;
        }
    }

    public class ThemeImpl {
        private final Resources.ThemeKey mKey = new Resources.ThemeKey();
        private final AssetManager mAssets;
        private final long mTheme;
        private int mThemeResId = 0;

        ThemeImpl() {
            this.mAssets = ResourcesImpl.this.mAssets;
            this.mTheme = this.mAssets.createTheme();
        }

        protected void finalize() throws Throwable {
            super.finalize();
            this.mAssets.releaseTheme(this.mTheme);
        }

        Resources.ThemeKey getKey() {
            return this.mKey;
        }

        long getNativeTheme() {
            return this.mTheme;
        }

        int getAppliedStyleResId() {
            return this.mThemeResId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void applyStyle(int resId, boolean force) {
            Resources.ThemeKey themeKey = this.mKey;
            synchronized (themeKey) {
                this.mAssets.applyStyleToTheme(this.mTheme, resId, force);
                this.mThemeResId = resId;
                this.mKey.append(resId, force);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setTo(ThemeImpl other) {
            Resources.ThemeKey themeKey = this.mKey;
            synchronized (themeKey) {
                Resources.ThemeKey themeKey2 = other.mKey;
                synchronized (themeKey2) {
                    this.mAssets.setThemeTo(this.mTheme, other.mAssets, other.mTheme);
                    this.mThemeResId = other.mThemeResId;
                    this.mKey.setTo(other.getKey());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        TypedArray obtainStyledAttributes(Resources.Theme wrapper, AttributeSet set, int[] attrs, int defStyleAttr, int defStyleRes) {
            Resources.ThemeKey themeKey = this.mKey;
            synchronized (themeKey) {
                int len = attrs.length;
                TypedArray array2 = TypedArray.obtain(wrapper.getResources(), len);
                XmlBlock.Parser parser = (XmlBlock.Parser)set;
                this.mAssets.applyStyle(this.mTheme, defStyleAttr, defStyleRes, parser, attrs, array2.mDataAddress, array2.mIndicesAddress);
                array2.mTheme = wrapper;
                array2.mXml = parser;
                return array2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        TypedArray resolveAttributes(Resources.Theme wrapper, int[] values, int[] attrs) {
            Resources.ThemeKey themeKey = this.mKey;
            synchronized (themeKey) {
                int len = attrs.length;
                if (values == null || len != values.length) {
                    throw new IllegalArgumentException("Base attribute values must the same length as attrs");
                }
                TypedArray array2 = TypedArray.obtain(wrapper.getResources(), len);
                this.mAssets.resolveAttrs(this.mTheme, 0, 0, values, attrs, array2.mData, array2.mIndices);
                array2.mTheme = wrapper;
                array2.mXml = null;
                return array2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean resolveAttribute(int resid, TypedValue outValue, boolean resolveRefs) {
            Resources.ThemeKey themeKey = this.mKey;
            synchronized (themeKey) {
                return this.mAssets.getThemeValue(this.mTheme, resid, outValue, resolveRefs);
            }
        }

        int[] getAllAttributes() {
            return this.mAssets.getStyleAttributes(this.getAppliedStyleResId());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int getChangingConfigurations() {
            Resources.ThemeKey themeKey = this.mKey;
            synchronized (themeKey) {
                int nativeChangingConfig = AssetManager.nativeThemeGetChangingConfigurations(this.mTheme);
                return ActivityInfo.activityInfoConfigNativeToJava(nativeChangingConfig);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dump(int priority, String tag, String prefix) {
            Resources.ThemeKey themeKey = this.mKey;
            synchronized (themeKey) {
                this.mAssets.dumpTheme(this.mTheme, priority, tag, prefix);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        String[] getTheme() {
            Resources.ThemeKey themeKey = this.mKey;
            synchronized (themeKey) {
                int N = this.mKey.mCount;
                String[] themes = new String[N * 2];
                int i = 0;
                int j = N - 1;
                while (i < themes.length) {
                    int resId = this.mKey.mResId[j];
                    boolean forced = this.mKey.mForce[j];
                    try {
                        themes[i] = ResourcesImpl.this.getResourceName(resId);
                    }
                    catch (Resources.NotFoundException e) {
                        themes[i] = Integer.toHexString(i);
                    }
                    themes[i + 1] = forced ? "forced" : "not forced";
                    i += 2;
                    --j;
                }
                return themes;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void rebase() {
            Resources.ThemeKey themeKey = this.mKey;
            synchronized (themeKey) {
                AssetManager.nativeThemeClear(this.mTheme);
                for (int i = 0; i < this.mKey.mCount; ++i) {
                    int resId = this.mKey.mResId[i];
                    boolean force = this.mKey.mForce[i];
                    this.mAssets.applyStyleToTheme(this.mTheme, resId, force);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int[] getAttributeResolutionStack(int defStyleAttr, int defStyleRes, int explicitStyleRes) {
            Resources.ThemeKey themeKey = this.mKey;
            synchronized (themeKey) {
                return this.mAssets.getAttributeResolutionStack(this.mTheme, defStyleAttr, defStyleRes, explicitStyleRes);
            }
        }
    }
}

