/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.SystemApi;
import android.app.IUiModeManager;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.os.RemoteException;
import android.os.ServiceManager;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.time.LocalTime;

public class UiModeManager {
    private static final String TAG = "UiModeManager";
    public static String ACTION_ENTER_CAR_MODE = "android.app.action.ENTER_CAR_MODE";
    @SystemApi
    public static final String ACTION_ENTER_CAR_MODE_PRIORITIZED = "android.app.action.ENTER_CAR_MODE_PRIORITIZED";
    public static String ACTION_EXIT_CAR_MODE = "android.app.action.EXIT_CAR_MODE";
    @SystemApi
    public static final String ACTION_EXIT_CAR_MODE_PRIORITIZED = "android.app.action.EXIT_CAR_MODE_PRIORITIZED";
    public static String ACTION_ENTER_DESK_MODE = "android.app.action.ENTER_DESK_MODE";
    public static String ACTION_EXIT_DESK_MODE = "android.app.action.EXIT_DESK_MODE";
    @SystemApi
    public static final String EXTRA_CALLING_PACKAGE = "android.app.extra.CALLING_PACKAGE";
    @SystemApi
    public static final String EXTRA_PRIORITY = "android.app.extra.PRIORITY";
    public static final int MODE_NIGHT_AUTO = 0;
    public static final int MODE_NIGHT_CUSTOM = 3;
    public static final int MODE_NIGHT_NO = 1;
    public static final int MODE_NIGHT_YES = 2;
    private IUiModeManager mService = IUiModeManager.Stub.asInterface(ServiceManager.getServiceOrThrow("uimode"));
    private Context mContext;
    public static final int ENABLE_CAR_MODE_GO_CAR_HOME = 1;
    public static final int ENABLE_CAR_MODE_ALLOW_SLEEP = 2;
    public static final int DISABLE_CAR_MODE_GO_HOME = 1;
    public static final int DISABLE_CAR_MODE_ALL_PRIORITIES = 2;
    @SystemApi
    public static final int DEFAULT_PRIORITY = 0;

    @UnsupportedAppUsage
    UiModeManager() throws ServiceManager.ServiceNotFoundException {
        this(null);
    }

    UiModeManager(Context context) throws ServiceManager.ServiceNotFoundException {
        this.mContext = context;
    }

    public void enableCarMode(int flags) {
        this.enableCarMode(0, flags);
    }

    @SystemApi
    public void enableCarMode(int priority, int flags) {
        if (this.mService != null) {
            try {
                this.mService.enableCarMode(flags, priority, this.mContext == null ? null : this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public void disableCarMode(int flags) {
        if (this.mService != null) {
            try {
                this.mService.disableCarModeByCallingPackage(flags, this.mContext == null ? null : this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public int getCurrentModeType() {
        if (this.mService != null) {
            try {
                return this.mService.getCurrentModeType();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return 1;
    }

    public void setNightMode(int mode) {
        if (this.mService != null) {
            try {
                this.mService.setNightMode(mode);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public int getNightMode() {
        if (this.mService != null) {
            try {
                return this.mService.getNightMode();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return -1;
    }

    public boolean isUiModeLocked() {
        if (this.mService != null) {
            try {
                return this.mService.isUiModeLocked();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return true;
    }

    public boolean isNightModeLocked() {
        if (this.mService != null) {
            try {
                return this.mService.isNightModeLocked();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return true;
    }

    public boolean setNightModeActivated(boolean active) {
        if (this.mService != null) {
            try {
                return this.mService.setNightModeActivated(active);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    public LocalTime getCustomNightModeStart() {
        if (this.mService != null) {
            try {
                return LocalTime.ofNanoOfDay(this.mService.getCustomNightModeStart() * 1000L);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return LocalTime.MIDNIGHT;
    }

    public void setCustomNightModeStart(LocalTime time) {
        if (this.mService != null) {
            try {
                this.mService.setCustomNightModeStart(time.toNanoOfDay() / 1000L);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public LocalTime getCustomNightModeEnd() {
        if (this.mService != null) {
            try {
                return LocalTime.ofNanoOfDay(this.mService.getCustomNightModeEnd() * 1000L);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return LocalTime.MIDNIGHT;
    }

    public void setCustomNightModeEnd(LocalTime time) {
        if (this.mService != null) {
            try {
                this.mService.setCustomNightModeEnd(time.toNanoOfDay() / 1000L);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DisableCarMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EnableCarMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface NightMode {
    }
}

