/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.service.fus.collectors;

import com.intellij.concurrency.JobScheduler;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.fus.FeatureUsageLogger;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsageCollectorEP;
import com.intellij.internal.statistic.service.fus.collectors.FeatureUsagesCollector;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class FUCounterUsageLogger {
    private static final int LOG_REGISTERED_DELAY_MIN = 1440;
    private static final int LOG_REGISTERED_INITIAL_DELAY_MIN = 5;
    @NonNls
    private static final String[] GENERAL_GROUPS = new String[]{"event.log", "performance", "ui.dialogs", "ui.settings", "toolwindow", "intentions", "run.configuration.exec", "productivity", "completion.postfix", "notifications", "settings.changes"};
    private static final Logger LOG = Logger.getInstance(FUCounterUsageLogger.class);
    private static final FUCounterUsageLogger INSTANCE = new FUCounterUsageLogger();
    private final Map<String, EventLogGroup> myGroups = new HashMap<String, EventLogGroup>();

    @NotNull
    public static FUCounterUsageLogger getInstance() {
        return INSTANCE;
    }

    public FUCounterUsageLogger() {
        int version = FeatureUsageLogger.INSTANCE.getConfig().getVersion();
        for (String group : GENERAL_GROUPS) {
            this.register(new EventLogGroup(group, version));
        }
        for (CounterUsageCollectorEP ep : CounterUsageCollectorEP.EP_NAME.getExtensionList()) {
            this.registerGroupFromEP(ep);
        }
        Extensions.getRootArea().getExtensionPoint(CounterUsageCollectorEP.EP_NAME).addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<CounterUsageCollectorEP>(){

            public void extensionAdded(@NotNull CounterUsageCollectorEP extension, @NotNull PluginDescriptor pluginDescriptor) {
                FUCounterUsageLogger.this.registerGroupFromEP(extension);
            }
        }, true, null);
        JobScheduler.getScheduler().scheduleWithFixedDelay(() -> this.logRegisteredGroups(), 5L, 1440L, TimeUnit.MINUTES);
    }

    private void registerGroupFromEP(CounterUsageCollectorEP ep) {
        String id;
        if (ep.implementationClass == null && StringUtil.isNotEmpty((String)(id = ep.getGroupId()))) {
            this.register(new EventLogGroup(id, ep.version));
        }
    }

    public static List<FeatureUsagesCollector> instantiateCounterCollectors() {
        ArrayList<FeatureUsagesCollector> result = new ArrayList<FeatureUsagesCollector>();
        for (CounterUsageCollectorEP ep : (CounterUsageCollectorEP[])CounterUsageCollectorEP.EP_NAME.getExtensions()) {
            if (ep.implementationClass == null) continue;
            result.add((FeatureUsagesCollector)ep.instantiateClass(ep.implementationClass, ApplicationManager.getApplication().getPicoContainer()));
        }
        return result;
    }

    private void register(@NotNull EventLogGroup group) {
        this.myGroups.put(group.getId(), group);
    }

    public void logRegisteredGroups() {
        for (EventLogGroup group : this.myGroups.values()) {
            FeatureUsageLogger.INSTANCE.log(group, "registered");
        }
        for (FeatureUsagesCollector collector : FUCounterUsageLogger.instantiateCounterCollectors()) {
            EventLogGroup group = collector.getGroup();
            if (group == null) continue;
            FeatureUsageLogger.INSTANCE.log(group, "registered");
        }
    }

    public void logEvent(@Nullable Project project, @NonNls @NotNull String groupId, @NonNls @NotNull String eventId) {
        EventLogGroup group = this.findRegisteredGroupById(groupId);
        if (group != null) {
            Map<String, Object> data = new FeatureUsageData().addProject(project).build();
            FeatureUsageLogger.INSTANCE.log(group, eventId, data);
        }
    }

    public void logEvent(@Nullable Project project, @NonNls @NotNull String groupId, @NonNls @NotNull String eventId, @NotNull FeatureUsageData data) {
        EventLogGroup group = this.findRegisteredGroupById(groupId);
        if (group != null) {
            FeatureUsageLogger.INSTANCE.log(group, eventId, data.addProject(project).build());
        }
    }

    public void logEvent(@NonNls @NotNull String groupId, @NonNls @NotNull String eventId) {
        EventLogGroup group = this.findRegisteredGroupById(groupId);
        if (group != null) {
            FeatureUsageLogger.INSTANCE.log(group, eventId);
        }
    }

    public void logEvent(@NonNls @NotNull String groupId, @NonNls @NotNull String eventId, @NotNull FeatureUsageData data) {
        EventLogGroup group = this.findRegisteredGroupById(groupId);
        if (group != null) {
            FeatureUsageLogger.INSTANCE.log(group, eventId, data.build());
        }
    }

    @Nullable
    private EventLogGroup findRegisteredGroupById(@NotNull String groupId) {
        if (!this.myGroups.containsKey(groupId)) {
            LOG.error("Cannot record event because group '" + groupId + "' is not registered. To fix it add '<statistics.counterUsagesCollector groupId=\"" + groupId + "\" version=\"1\"/>' in plugin.xml");
            return null;
        }
        return this.myGroups.get(groupId);
    }
}

