/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.rules.utils;

import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.FUSRegexpAwareRule;
import com.intellij.internal.statistic.eventLog.validator.rules.FUSRule;
import com.intellij.internal.statistic.eventLog.validator.rules.PerformanceCareRule;
import com.intellij.internal.statistic.eventLog.validator.rules.beans.EventGroupContextData;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomValidationRule;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomWhiteListRule;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.EnumValidationRule;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.RegexpValidationRule;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.UtilExpressionValidationRule;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ValidationSimpleRuleFactory {
    private static final String RULE_PREFIX = "rule:";
    private static final String ENUM_PREFIX = "enum:";
    private static final String REGEXP_PREFIX = "regexp:";
    private static final String ENUM_REF_PREFIX = "enum#";
    private static final String REGEXP_REF_PREFIX = "regexp#";
    private static final String UTIL_PREFIX = "util#";
    private static final String ENUM_SEPARATOR = "|";
    private static final String START = "{";
    private static final String END = "}";
    private static final FUSRule UNPARSED_EXPRESSION = (s, c) -> ValidationResultType.INCORRECT_RULE;

    @NotNull
    public static FUSRule createRule(@NotNull String rule) {
        return ValidationSimpleRuleFactory.createRule(rule, EventGroupContextData.EMPTY);
    }

    @NotNull
    public static FUSRule createRule(@NotNull String rule, @NotNull EventGroupContextData contextData) {
        FUSRule wlr = ValidationSimpleRuleFactory.createSimpleRule(rule.trim(), contextData);
        return wlr != null ? wlr : ValidationSimpleRuleFactory.createExpressionRule(rule.trim(), contextData);
    }

    @Nullable
    private static FUSRule createSimpleRule(@NotNull String rule, @NotNull EventGroupContextData contextData) {
        return ValidationSimpleRuleFactory.createSimpleRule(rule, Pair.create((Object)RULE_PREFIX, s -> ValidationSimpleRuleFactory.getBooleanRule(s)), Pair.create((Object)UTIL_PREFIX, s -> ValidationSimpleRuleFactory.getCustomUtilRule(s)), Pair.create((Object)ENUM_PREFIX, s -> new EnumValidationRule(StringUtil.split((String)s, (String)ENUM_SEPARATOR, (boolean)true, (boolean)false))), Pair.create((Object)ENUM_REF_PREFIX, s -> new EnumValidationRule(contextData.getEnum((String)s))), Pair.create((Object)REGEXP_PREFIX, s -> new RegexpValidationRule((String)s)), Pair.create((Object)REGEXP_REF_PREFIX, s -> new RegexpValidationRule(contextData.getRegexp((String)s))));
    }

    @Nullable
    private static FUSRule getCustomUtilRule(String s) {
        for (CustomValidationRule customValidationRule : (CustomValidationRule[])CustomValidationRule.EP_NAME.getExtensions()) {
            if (!ValidationSimpleRuleFactory.isDevelopedByJetBrains(customValidationRule) || !customValidationRule.acceptRuleId(s)) continue;
            return customValidationRule;
        }
        for (PerformanceCareRule performanceCareRule : (CustomWhiteListRule[])CustomWhiteListRule.EP_NAME.getExtensions()) {
            if (!ValidationSimpleRuleFactory.isDevelopedByJetBrains(performanceCareRule) || !((CustomWhiteListRule)performanceCareRule).acceptRuleId(s)) continue;
            return performanceCareRule;
        }
        return null;
    }

    private static boolean isDevelopedByJetBrains(FUSRule extension) {
        return ApplicationManager.getApplication().isUnitTestMode() || PluginInfoDetectorKt.getPluginInfo(extension.getClass()).isDevelopedByJetBrains();
    }

    @Nullable
    private static FUSRule getBooleanRule(@Nullable String value) {
        if ("TRUE".equals(value)) {
            return FUSRule.TRUE;
        }
        if ("FALSE".equals(value)) {
            return FUSRule.FALSE;
        }
        return null;
    }

    @Nullable
    private static FUSRule createSimpleRule(@NotNull String rule, Pair<String, Function<String, FUSRule>> ... rules) {
        for (Pair<String, Function<String, FUSRule>> pair : rules) {
            String value;
            if (!rule.startsWith((String)pair.first) || !StringUtil.isNotEmpty((String)(value = rule.substring(((String)pair.first).length())))) continue;
            return (FUSRule)((Function)pair.second).fun((Object)value);
        }
        return null;
    }

    @NotNull
    private static FUSRule createExpressionRule(@NotNull String rule, @NotNull EventGroupContextData contextData) {
        FUSRule simpleRule;
        String n;
        List<String> nodes = ValidationSimpleRuleFactory.parseSimpleExpression(rule);
        if (nodes.size() == 1 && (n = nodes.get(0)).contains(START) && (simpleRule = ValidationSimpleRuleFactory.createSimpleRule(ValidationSimpleRuleFactory.unwrapRuleNode(n), contextData)) != null) {
            return simpleRule;
        }
        if (rule.contains(UTIL_PREFIX)) {
            return ValidationSimpleRuleFactory.createExpressionUtilRule(nodes);
        }
        return ValidationSimpleRuleFactory.createExpressionValidationRule(rule, contextData);
    }

    @NotNull
    private static FUSRule createExpressionValidationRule(@NotNull String rule, @NotNull EventGroupContextData contextData) {
        StringBuilder sb = new StringBuilder();
        for (String node : ValidationSimpleRuleFactory.parseSimpleExpression(rule)) {
            if (ValidationSimpleRuleFactory.isExpressionNode(node)) {
                FUSRule fusRule = ValidationSimpleRuleFactory.createRule(ValidationSimpleRuleFactory.unwrapRuleNode(node), contextData);
                if (fusRule instanceof FUSRegexpAwareRule) {
                    sb.append("(");
                    sb.append(((FUSRegexpAwareRule)fusRule).asRegexp());
                    sb.append(")");
                    continue;
                }
                return UNPARSED_EXPRESSION;
            }
            sb.append(RegexpValidationRule.escapeText(node));
        }
        return new RegexpValidationRule(sb.toString());
    }

    private static FUSRule createExpressionUtilRule(@NotNull List<String> nodes) {
        FUSRule fusRule = null;
        String suffix = "";
        String prefix = "";
        boolean utilNodeFound = false;
        for (String string : nodes) {
            if (ValidationSimpleRuleFactory.isExpressionNode(string)) {
                if (!string.contains(UTIL_PREFIX)) {
                    return UNPARSED_EXPRESSION;
                }
                FUSRule simpleRule = ValidationSimpleRuleFactory.createRule(ValidationSimpleRuleFactory.unwrapRuleNode(string));
                if (!(simpleRule instanceof CustomValidationRule) && !(simpleRule instanceof CustomWhiteListRule)) {
                    return UNPARSED_EXPRESSION;
                }
                fusRule = simpleRule;
                utilNodeFound = true;
                continue;
            }
            if (utilNodeFound) {
                suffix = string;
                continue;
            }
            prefix = string;
        }
        if (fusRule == null) {
            return UNPARSED_EXPRESSION;
        }
        return new UtilExpressionValidationRule(fusRule, prefix, suffix);
    }

    @NotNull
    public static List<String> parseSimpleExpression(@NotNull String s) {
        int currentRuleStart = s.indexOf(START);
        if (StringUtil.isEmptyOrSpaces((String)s)) {
            return Collections.emptyList();
        }
        if (currentRuleStart == -1) {
            return Collections.singletonList(s);
        }
        int lastRuleEnd = -1;
        SmartList nodes = new SmartList();
        if (currentRuleStart > 0) {
            ValidationSimpleRuleFactory.addNonEmpty((List<? super String>)nodes, s.substring(0, currentRuleStart));
        }
        while (currentRuleStart >= 0) {
            int currentRuleEnd = s.indexOf(END, currentRuleStart);
            if (currentRuleEnd == -1) {
                return Collections.emptyList();
            }
            lastRuleEnd = currentRuleEnd + END.length();
            int nextRule = s.indexOf(START, currentRuleStart + START.length());
            if (nextRule > 0 && nextRule < lastRuleEnd) {
                return Collections.emptyList();
            }
            ValidationSimpleRuleFactory.addNonEmpty((List<? super String>)nodes, s.substring(currentRuleStart, lastRuleEnd));
            currentRuleStart = s.indexOf(START, lastRuleEnd);
            if (currentRuleStart <= 0) continue;
            ValidationSimpleRuleFactory.addNonEmpty((List<? super String>)nodes, s.substring(lastRuleEnd, currentRuleStart));
        }
        if (lastRuleEnd > 0) {
            ValidationSimpleRuleFactory.addNonEmpty((List<? super String>)nodes, s.substring(lastRuleEnd));
        }
        return nodes;
    }

    private static void addNonEmpty(@NotNull List<? super String> nodes, @Nullable String s) {
        if (StringUtil.isNotEmpty((String)s)) {
            nodes.add(s);
        }
    }

    private static boolean isExpressionNode(@NotNull String node) {
        return node.startsWith(START) && node.endsWith(END);
    }

    @NotNull
    private static String unwrapRuleNode(@NotNull String rule) {
        return ValidationSimpleRuleFactory.isExpressionNode(rule) ? rule.substring(START.length(), rule.length() - END.length()) : rule;
    }
}

