/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.rules.beans;

import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EventGroupContextData {
    public static final EventGroupContextData EMPTY = EventGroupContextData.create(null, null, null, null);
    @Nullable
    private final Map<String, Set<String>> myEnums;
    @Nullable
    private final Map<String, Set<String>> myGlobalEnums;
    @Nullable
    private final Map<String, String> myRegexps;
    @Nullable
    private final Map<String, String> myGlobalRegexps;

    public EventGroupContextData(@Nullable Map<String, Set<String>> enums, @Nullable Map<String, Set<String>> globalEnums, @Nullable Map<String, String> regexps, @Nullable Map<String, String> globalRegexps) {
        this.myEnums = enums;
        this.myGlobalEnums = globalEnums;
        this.myRegexps = regexps;
        this.myGlobalRegexps = globalRegexps;
    }

    public static EventGroupContextData create(@Nullable Map<String, Set<String>> enums, @Nullable Map<String, Set<String>> globalEnums, @Nullable Map<String, String> regexps, @Nullable Map<String, String> globalRegexps) {
        return new EventGroupContextData(enums, globalEnums, regexps, globalRegexps);
    }

    @Nullable
    public Set<String> getEnum(@NotNull String enumRef) {
        Set<String> values;
        if (this.myEnums != null && (values = this.myEnums.get(enumRef)) != null) {
            return values;
        }
        return this.myGlobalEnums != null ? this.myGlobalEnums.get(enumRef) : null;
    }

    @Nullable
    public String getRegexp(@NotNull String regexpRef) {
        String regexp;
        if (this.myRegexps != null && (regexp = this.myRegexps.get(regexpRef)) != null) {
            return regexp;
        }
        return this.myGlobalRegexps != null ? this.myGlobalRegexps.get(regexpRef) : null;
    }
}

