/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.persistence;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.intellij.internal.statistic.eventLog.validator.persistence.BaseEventLogWhitelistPersistence;
import com.intellij.internal.statistic.eventLog.whitelist.LocalWhitelistGroup;
import com.intellij.internal.statistic.service.fus.EventLogMetadataParseException;
import com.intellij.internal.statistic.service.fus.FUStatisticsWhiteListGroupsService;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EventLogTestWhitelistPersistence
extends BaseEventLogWhitelistPersistence {
    private static final Logger LOG = Logger.getInstance(EventLogTestWhitelistPersistence.class);
    public static final String TEST_RULE = "{util#fus_test_mode}";
    private static final String DEPRECATED_TEST_EVENTS_SCHEME_FILE = "test-white-list.json";
    private static final String TEST_EVENTS_SCHEME_FILE = "test-events-scheme.json";
    @NotNull
    private final String myRecorderId;

    public EventLogTestWhitelistPersistence(@NotNull String recorderId) {
        this.myRecorderId = recorderId;
    }

    @Override
    @Nullable
    public String getCachedMetadata() {
        try {
            File file = this.getWhitelistFile();
            if (file.exists()) {
                return FileUtil.loadFile((File)file);
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        return null;
    }

    public void cleanup() {
        try {
            FileUtil.delete((File)this.getWhitelistFile());
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    @NotNull
    public static FUStatisticsWhiteListGroupsService.WLGroup createGroupWithCustomRules(@NotNull String groupId, @NotNull String rules) {
        String content = "{\"id\":\"" + groupId + "\",\"versions\":[ {\"from\" : \"1\"}],\"rules\":" + rules + "}";
        return (FUStatisticsWhiteListGroupsService.WLGroup)new GsonBuilder().create().fromJson(content, FUStatisticsWhiteListGroupsService.WLGroup.class);
    }

    public static void addTestGroup(@NotNull String recorderId, @NotNull LocalWhitelistGroup group) throws IOException {
        String groupId = group.getGroupId();
        FUStatisticsWhiteListGroupsService.WLGroup whitelistGroup = group.getUseCustomRules() ? EventLogTestWhitelistPersistence.createGroupWithCustomRules(groupId, group.getCustomRules()) : EventLogTestWhitelistPersistence.createTestGroup(groupId, Collections.emptySet());
        EventLogTestWhitelistPersistence.addNewGroup(recorderId, whitelistGroup);
    }

    private static void addNewGroup(@NotNull String recorderId, @NotNull FUStatisticsWhiteListGroupsService.WLGroup group) throws IOException {
        EventLogTestWhitelistPersistence persistence = new EventLogTestWhitelistPersistence(recorderId);
        FUStatisticsWhiteListGroupsService.WLGroups whitelist = EventLogTestWhitelistPersistence.loadTestWhitelist(persistence);
        EventLogTestWhitelistPersistence.saveNewGroup(group, whitelist, persistence.getWhitelistFile());
    }

    public static void saveNewGroup(@NotNull FUStatisticsWhiteListGroupsService.WLGroup group, @NotNull FUStatisticsWhiteListGroupsService.WLGroups whitelist, @NotNull File file) throws IOException {
        whitelist.groups.stream().filter(g -> StringUtil.equals((CharSequence)g.id, (CharSequence)group.id)).findFirst().ifPresent(whitelist.groups::remove);
        whitelist.groups.add(group);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        FileUtil.writeToFile((File)file, (String)gson.toJson((Object)whitelist));
    }

    @NotNull
    public static FUStatisticsWhiteListGroupsService.WLGroups loadTestWhitelist(@NotNull BaseEventLogWhitelistPersistence persistence) {
        String existing = persistence.getCachedMetadata();
        if (StringUtil.isNotEmpty((String)existing)) {
            try {
                return FUStatisticsWhiteListGroupsService.parseWhiteListContent((String)existing);
            }
            catch (EventLogMetadataParseException e) {
                LOG.warn("Failed parsing test whitelist", (Throwable)e);
            }
        }
        return new FUStatisticsWhiteListGroupsService.WLGroups();
    }

    @NotNull
    public static FUStatisticsWhiteListGroupsService.WLGroup createTestGroup(@NotNull String groupId, @NotNull Set<String> eventData) {
        FUStatisticsWhiteListGroupsService.WLGroup group = new FUStatisticsWhiteListGroupsService.WLGroup();
        group.id = groupId;
        if (group.versions != null) {
            group.versions.add(new FUStatisticsWhiteListGroupsService.WLVersion("1", null));
        }
        FUStatisticsWhiteListGroupsService.WLRule rule = new FUStatisticsWhiteListGroupsService.WLRule();
        rule.event_id = ContainerUtil.newHashSet((Object[])new String[]{TEST_RULE});
        HashMap<String, HashSet> dataRules = new HashMap<String, HashSet>();
        for (String datum : eventData) {
            dataRules.put(datum, ContainerUtil.newHashSet((Object[])new String[]{TEST_RULE}));
        }
        rule.event_data = dataRules;
        group.rules = rule;
        return group;
    }

    @NotNull
    public File getWhitelistFile() throws IOException {
        return EventLogTestWhitelistPersistence.getDefaultMetadataFile(this.myRecorderId, TEST_EVENTS_SCHEME_FILE, DEPRECATED_TEST_EVENTS_SCHEME_FILE);
    }

    public void updateTestGroups(@NotNull List<LocalWhitelistGroup> groups) throws IOException {
        FUStatisticsWhiteListGroupsService.WLGroups whitelist = new FUStatisticsWhiteListGroupsService.WLGroups();
        for (LocalWhitelistGroup group : groups) {
            String groupId = group.getGroupId();
            if (group.getUseCustomRules()) {
                whitelist.groups.add(EventLogTestWhitelistPersistence.createGroupWithCustomRules(groupId, group.getCustomRules()));
                continue;
            }
            whitelist.groups.add(EventLogTestWhitelistPersistence.createTestGroup(groupId, Collections.emptySet()));
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        FileUtil.writeToFile((File)this.getWhitelistFile(), (String)gson.toJson((Object)whitelist));
    }
}

