/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.typeEnhancement;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.load.java.lazy.JavaResolverSettings;
import org.jetbrains.kotlin.load.java.lazy.types.RawTypeImpl;
import org.jetbrains.kotlin.load.java.typeEnhancement.EnhancementResult;
import org.jetbrains.kotlin.load.java.typeEnhancement.JavaTypeQualifiers;
import org.jetbrains.kotlin.load.java.typeEnhancement.NotNullTypeParameter;
import org.jetbrains.kotlin.load.java.typeEnhancement.NullabilityQualifier;
import org.jetbrains.kotlin.load.java.typeEnhancement.TypeComponentPosition;
import org.jetbrains.kotlin.load.java.typeEnhancement.TypeComponentPositionKt;
import org.jetbrains.kotlin.load.java.typeEnhancement.TypeEnhancementKt;
import org.jetbrains.kotlin.types.FlexibleType;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeFactory;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.RawType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.SpecialTypesKt;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.TypeWithEnhancementKt;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u001b\u001cB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J \u0010\f\u001a\u0004\u0018\u00010\u0006*\u00020\u00062\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eJ:\u0010\u0011\u001a\u00020\u0012*\u00020\n2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e2\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u0017H\u0002J(\u0010\u0018\u001a\u00020\u0019*\u00020\u001a2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e2\u0006\u0010\u0013\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/load/java/typeEnhancement/JavaTypeEnhancement;", "", "javaResolverSettings", "Lorg/jetbrains/kotlin/load/java/lazy/JavaResolverSettings;", "(Lorg/jetbrains/kotlin/load/java/lazy/JavaResolverSettings;)V", "buildEnhancementByFlexibleTypeBounds", "Lorg/jetbrains/kotlin/types/KotlinType;", "lowerBound", "upperBound", "notNullTypeParameter", "Lorg/jetbrains/kotlin/types/SimpleType;", "enhancedType", "enhance", "qualifiers", "Lkotlin/Function1;", "", "Lorg/jetbrains/kotlin/load/java/typeEnhancement/JavaTypeQualifiers;", "enhanceInflexible", "Lorg/jetbrains/kotlin/load/java/typeEnhancement/JavaTypeEnhancement$SimpleResult;", "index", "position", "Lorg/jetbrains/kotlin/load/java/typeEnhancement/TypeComponentPosition;", "isBoundOfRawType", "", "enhancePossiblyFlexible", "Lorg/jetbrains/kotlin/load/java/typeEnhancement/JavaTypeEnhancement$Result;", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "Result", "SimpleResult", "descriptors.jvm"})
public final class JavaTypeEnhancement {
    @NotNull
    private final JavaResolverSettings javaResolverSettings;

    public JavaTypeEnhancement(@NotNull JavaResolverSettings javaResolverSettings) {
        Intrinsics.checkNotNullParameter((Object)javaResolverSettings, (String)"javaResolverSettings");
        this.javaResolverSettings = javaResolverSettings;
    }

    @Nullable
    public final KotlinType enhance(@NotNull KotlinType $this$enhance, @NotNull Function1<? super Integer, JavaTypeQualifiers> qualifiers) {
        Intrinsics.checkNotNullParameter((Object)$this$enhance, (String)"<this>");
        Intrinsics.checkNotNullParameter(qualifiers, (String)"qualifiers");
        return this.enhancePossiblyFlexible($this$enhance.unwrap(), qualifiers, 0).getTypeIfChanged();
    }

    private final KotlinType buildEnhancementByFlexibleTypeBounds(KotlinType lowerBound, KotlinType upperBound) {
        KotlinType lowerEnhancement;
        KotlinType kotlinType;
        KotlinType upperEnhancement = TypeWithEnhancementKt.getEnhancement(upperBound);
        KotlinType kotlinType2 = TypeWithEnhancementKt.getEnhancement(lowerBound);
        if (kotlinType2 == null) {
            KotlinType kotlinType3 = upperEnhancement;
            if (kotlinType3 == null) {
                return null;
            }
            kotlinType = kotlinType3;
        } else {
            kotlinType = lowerEnhancement = kotlinType2;
        }
        if (upperEnhancement == null) {
            return lowerEnhancement;
        }
        return KotlinTypeFactory.flexibleType(FlexibleTypesKt.lowerIfFlexible(lowerEnhancement), FlexibleTypesKt.upperIfFlexible(upperEnhancement));
    }

    private final Result enhancePossiblyFlexible(UnwrappedType $this$enhancePossiblyFlexible, Function1<? super Integer, JavaTypeQualifiers> qualifiers, int index) {
        Result result;
        if (KotlinTypeKt.isError($this$enhancePossiblyFlexible)) {
            return new Result($this$enhancePossiblyFlexible, 1, false);
        }
        UnwrappedType unwrappedType = $this$enhancePossiblyFlexible;
        if (unwrappedType instanceof FlexibleType) {
            UnwrappedType unwrappedType2;
            boolean isRawType = $this$enhancePossiblyFlexible instanceof RawType;
            SimpleResult lowerResult = this.enhanceInflexible(((FlexibleType)$this$enhancePossiblyFlexible).getLowerBound(), qualifiers, index, TypeComponentPosition.FLEXIBLE_LOWER, isRawType);
            SimpleResult upperResult = this.enhanceInflexible(((FlexibleType)$this$enhancePossiblyFlexible).getUpperBound(), qualifiers, index, TypeComponentPosition.FLEXIBLE_UPPER, isRawType);
            boolean bl = lowerResult.getSubtreeSize() == upperResult.getSubtreeSize();
            boolean bl2 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-JavaTypeEnhancement$enhancePossiblyFlexible$22 = false;
                String $i$a$-assert-JavaTypeEnhancement$enhancePossiblyFlexible$22 = "Different tree sizes of bounds: lower = (" + ((FlexibleType)$this$enhancePossiblyFlexible).getLowerBound() + ", " + lowerResult.getSubtreeSize() + "), upper = (" + ((FlexibleType)$this$enhancePossiblyFlexible).getUpperBound() + ", " + upperResult.getSubtreeSize() + ')';
                throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-JavaTypeEnhancement$enhancePossiblyFlexible$22));
            }
            boolean wereChanges = lowerResult.getWereChanges() || upperResult.getWereChanges();
            KotlinType enhancement = this.buildEnhancementByFlexibleTypeBounds(lowerResult.getType(), upperResult.getType());
            UnwrappedType type2 = wereChanges ? TypeWithEnhancementKt.wrapEnhancement((unwrappedType2 = $this$enhancePossiblyFlexible) instanceof RawTypeImpl ? (UnwrappedType)new RawTypeImpl(lowerResult.getType(), upperResult.getType()) : KotlinTypeFactory.flexibleType(lowerResult.getType(), upperResult.getType()), enhancement) : $this$enhancePossiblyFlexible;
            result = new Result(type2, lowerResult.getSubtreeSize(), wereChanges);
        } else if (unwrappedType instanceof SimpleType) {
            result = JavaTypeEnhancement.enhanceInflexible$default(this, (SimpleType)$this$enhancePossiblyFlexible, qualifiers, index, TypeComponentPosition.INFLEXIBLE, false, 8, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private final SimpleResult enhanceInflexible(SimpleType $this$enhanceInflexible, Function1<? super Integer, JavaTypeQualifiers> qualifiers, int index, TypeComponentPosition position, boolean isBoundOfRawType) {
        void $this$mapIndexedTo$iv$iv;
        ClassifierDescriptor classifierDescriptor;
        boolean shouldEnhance = TypeComponentPositionKt.shouldEnhance(position);
        if (!shouldEnhance && $this$enhanceInflexible.getArguments().isEmpty()) {
            return new SimpleResult($this$enhanceInflexible, 1, false);
        }
        Object object = $this$enhanceInflexible.getConstructor().getDeclarationDescriptor();
        if (object == null) {
            return new SimpleResult($this$enhanceInflexible, 1, false);
        }
        ClassifierDescriptor originalClass = classifierDescriptor = object;
        JavaTypeQualifiers effectiveQualifiers = (JavaTypeQualifiers)qualifiers.invoke((Object)index);
        object = TypeEnhancementKt.access$enhanceMutability(originalClass, effectiveQualifiers, position);
        ClassifierDescriptor enhancedClassifier = (ClassifierDescriptor)((EnhancementResult)object).component1();
        Annotations enhancedMutabilityAnnotations = ((EnhancementResult)object).component2();
        TypeConstructor typeConstructor2 = enhancedClassifier.getTypeConstructor();
        Intrinsics.checkNotNullExpressionValue((Object)typeConstructor2, (String)"enhancedClassifier.typeConstructor");
        TypeConstructor typeConstructor3 = typeConstructor2;
        int globalArgIndex = 0;
        globalArgIndex = index + 1;
        boolean wereChanges = false;
        wereChanges = enhancedMutabilityAnnotations != null;
        Iterable $this$mapIndexed$iv = $this$enhanceInflexible.getArguments();
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv22 = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            Object object2;
            Object object3;
            void localArgIndex;
            void arg;
            int n = index$iv$iv22++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            TypeProjection typeProjection = (TypeProjection)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            if (arg.isStarProjection()) {
                JavaTypeQualifiers qualifiersForStarProjection = (JavaTypeQualifiers)qualifiers.invoke((Object)globalArgIndex);
                int n3 = globalArgIndex;
                globalArgIndex = n3 + 1;
                if (qualifiersForStarProjection.getNullability() == NullabilityQualifier.NOT_NULL && !isBoundOfRawType) {
                    KotlinType enhanced = TypeUtilsKt.makeNotNullable(arg.getType().unwrap());
                    Variance variance = arg.getProjectionKind();
                    Intrinsics.checkNotNullExpressionValue((Object)((Object)variance), (String)"arg.projectionKind");
                    object3 = TypeUtilsKt.createProjection(enhanced, variance, typeConstructor3.getParameters().get((int)localArgIndex));
                } else {
                    object2 = TypeUtils.makeStarProjection(enhancedClassifier.getTypeConstructor().getParameters().get((int)localArgIndex));
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"{\n                    TypeUtils.makeStarProjection(enhancedClassifier.typeConstructor.parameters[localArgIndex])\n                }");
                    object3 = object2;
                }
            } else {
                Result enhanced = this.enhancePossiblyFlexible(arg.getType().unwrap(), qualifiers, globalArgIndex);
                wereChanges = wereChanges || enhanced.getWereChanges();
                globalArgIndex += enhanced.getSubtreeSize();
                KotlinType kotlinType = enhanced.getType();
                object2 = arg.getProjectionKind();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"arg.projectionKind");
                object3 = TypeUtilsKt.createProjection(kotlinType, object2, typeConstructor3.getParameters().get((int)localArgIndex));
            }
            Object object4 = object3;
            collection.add(object4);
        }
        List enhancedArguments = (List)destination$iv$iv;
        EnhancementResult enhancementResult = TypeEnhancementKt.access$getEnhancedNullability($this$enhanceInflexible, effectiveQualifiers, position);
        boolean enhancedNullability = (Boolean)enhancementResult.component1();
        Annotations enhancedNullabilityAnnotations = enhancementResult.component2();
        wereChanges = wereChanges || enhancedNullabilityAnnotations != null;
        int subtreeSize = globalArgIndex - index;
        if (!wereChanges) {
            return new SimpleResult($this$enhanceInflexible, subtreeSize, false);
        }
        Object[] index$iv$iv22 = new Annotations[]{$this$enhanceInflexible.getAnnotations(), enhancedMutabilityAnnotations, enhancedNullabilityAnnotations};
        Annotations newAnnotations = TypeEnhancementKt.access$compositeAnnotationsOrSingle(CollectionsKt.listOfNotNull((Object[])index$iv$iv22));
        SimpleType enhancedType = KotlinTypeFactory.simpleType$default(newAnnotations, typeConstructor3, enhancedArguments, enhancedNullability, null, 16, null);
        SimpleType enhancement = effectiveQualifiers.isNotNullTypeParameter() ? this.notNullTypeParameter(enhancedType) : enhancedType;
        boolean nullabilityForWarning = enhancedNullabilityAnnotations != null && effectiveQualifiers.isNullabilityQualifierForWarning();
        UnwrappedType result = nullabilityForWarning ? TypeWithEnhancementKt.wrapEnhancement($this$enhanceInflexible, enhancement) : (UnwrappedType)enhancement;
        return new SimpleResult((SimpleType)result, subtreeSize, true);
    }

    static /* synthetic */ SimpleResult enhanceInflexible$default(JavaTypeEnhancement javaTypeEnhancement, SimpleType simpleType2, Function1 function1, int n, TypeComponentPosition typeComponentPosition, boolean bl, int n2, Object object) {
        if ((n2 & 8) != 0) {
            bl = false;
        }
        return javaTypeEnhancement.enhanceInflexible(simpleType2, (Function1<? super Integer, JavaTypeQualifiers>)function1, n, typeComponentPosition, bl);
    }

    private final SimpleType notNullTypeParameter(SimpleType enhancedType) {
        return this.javaResolverSettings.getCorrectNullabilityForNotNullTypeParameter() ? SpecialTypesKt.makeSimpleTypeDefinitelyNotNullOrNotNull(enhancedType, true) : (SimpleType)new NotNullTypeParameter(enhancedType);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\b\u0012\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\r\u001a\u0004\u0018\u00010\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/load/java/typeEnhancement/JavaTypeEnhancement$Result;", "", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "subtreeSize", "", "wereChanges", "", "(Lorg/jetbrains/kotlin/types/KotlinType;IZ)V", "getSubtreeSize", "()I", "getType", "()Lorg/jetbrains/kotlin/types/KotlinType;", "typeIfChanged", "getTypeIfChanged", "getWereChanges", "()Z", "descriptors.jvm"})
    private static class Result {
        @NotNull
        private final KotlinType type;
        private final int subtreeSize;
        private final boolean wereChanges;

        public Result(@NotNull KotlinType type2, int subtreeSize, boolean wereChanges) {
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            this.type = type2;
            this.subtreeSize = subtreeSize;
            this.wereChanges = wereChanges;
        }

        @NotNull
        public KotlinType getType() {
            return this.type;
        }

        public final int getSubtreeSize() {
            return this.subtreeSize;
        }

        public final boolean getWereChanges() {
            return this.wereChanges;
        }

        @Nullable
        public final KotlinType getTypeIfChanged() {
            KotlinType kotlinType = this.getType();
            boolean bl = false;
            boolean bl2 = false;
            KotlinType it = kotlinType;
            boolean bl3 = false;
            return this.getWereChanges() ? kotlinType : null;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/load/java/typeEnhancement/JavaTypeEnhancement$SimpleResult;", "Lorg/jetbrains/kotlin/load/java/typeEnhancement/JavaTypeEnhancement$Result;", "type", "Lorg/jetbrains/kotlin/types/SimpleType;", "subtreeSize", "", "wereChanges", "", "(Lorg/jetbrains/kotlin/types/SimpleType;IZ)V", "getType", "()Lorg/jetbrains/kotlin/types/SimpleType;", "descriptors.jvm"})
    private static final class SimpleResult
    extends Result {
        @NotNull
        private final SimpleType type;

        public SimpleResult(@NotNull SimpleType type2, int subtreeSize, boolean wereChanges) {
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            super(type2, subtreeSize, wereChanges);
            this.type = type2;
        }

        @Override
        @NotNull
        public SimpleType getType() {
            return this.type;
        }
    }
}

