/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.build;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.AdditionalRootsProviderService;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.java.JavaModuleBuildTargetType;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.jps.model.module.JpsTypedModuleSourceRoot;
import org.jetbrains.kotlin.config.KotlinSourceRootType;
import org.jetbrains.kotlin.config.SourceKotlinRootType;
import org.jetbrains.kotlin.config.TestSourceKotlinRootType;
import org.jetbrains.kotlin.jps.build.KotlinIncludedModuleSourceRoot;
import org.jetbrains.kotlin.jps.build.KotlinSourceRootProviderKt;
import org.jetbrains.kotlin.jps.model.ModuleSettingsKt;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J&\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\r2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/jps/build/KotlinSourceRootProvider;", "Lorg/jetbrains/jps/builders/AdditionalRootsProviderService;", "Lorg/jetbrains/jps/builders/java/JavaSourceRootDescriptor;", "()V", "addModuleSourceRoots", "", "result", "", "module", "Lorg/jetbrains/jps/model/module/JpsModule;", "target", "Lorg/jetbrains/jps/incremental/ModuleBuildTarget;", "getAdditionalRoots", "", "Lorg/jetbrains/jps/builders/BuildTarget;", "dataPaths", "Lorg/jetbrains/jps/builders/storage/BuildDataPaths;", "kotlin.jps-plugin"})
public final class KotlinSourceRootProvider
extends AdditionalRootsProviderService<JavaSourceRootDescriptor> {
    @NotNull
    public List<JavaSourceRootDescriptor> getAdditionalRoots(@NotNull BuildTarget<JavaSourceRootDescriptor> target, @Nullable BuildDataPaths dataPaths) {
        Intrinsics.checkNotNullParameter(target, (String)"target");
        BuildTarget<JavaSourceRootDescriptor> buildTarget = target;
        if (!(buildTarget instanceof ModuleBuildTarget)) {
            buildTarget = null;
        }
        ModuleBuildTarget moduleBuildTarget = (ModuleBuildTarget)buildTarget;
        if (moduleBuildTarget == null) {
            boolean bl = false;
            return CollectionsKt.emptyList();
        }
        ModuleBuildTarget moduleBuildTarget2 = moduleBuildTarget;
        JpsModule jpsModule = moduleBuildTarget2.getModule();
        Intrinsics.checkNotNullExpressionValue((Object)jpsModule, (String)"moduleBuildTarget.module");
        JpsModule module = jpsModule;
        boolean bl = false;
        List result = new ArrayList();
        KotlinSourceRootType kotlinSourceRootType = ((ModuleBuildTarget)target).isTests() ? (KotlinSourceRootType)TestSourceKotlinRootType.INSTANCE : (KotlinSourceRootType)SourceKotlinRootType.INSTANCE;
        Iterable iterable = module.getSourceRoots((JpsModuleSourceRootType)kotlinSourceRootType);
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"module.getSourceRoots(kotlinSourceRootType)");
        Iterable $this$forEach$iv = iterable;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JpsTypedModuleSourceRoot it = (JpsTypedModuleSourceRoot)element$iv;
            boolean bl2 = false;
            JpsTypedModuleSourceRoot jpsTypedModuleSourceRoot = it;
            Intrinsics.checkNotNullExpressionValue((Object)jpsTypedModuleSourceRoot, (String)"it");
            File file2 = jpsTypedModuleSourceRoot.getFile();
            ModuleBuildTarget moduleBuildTarget3 = (ModuleBuildTarget)target;
            JpsElement jpsElement = it.getProperties();
            Intrinsics.checkNotNullExpressionValue((Object)jpsElement, (String)"it.properties");
            boolean bl3 = false;
            result.add(new JavaSourceRootDescriptor(file2, moduleBuildTarget3, false, false, ((JavaSourceRootProperties)jpsElement).getPackagePrefix(), SetsKt.emptySet()));
        }
        if (((ModuleBuildTarget)target).isTests() == ModuleSettingsKt.isTestModule(module)) {
            $this$forEach$iv = ModuleSettingsKt.getSourceSetModules(module);
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                JpsModule sourceSetModule = (JpsModule)element$iv;
                boolean bl4 = false;
                this.addModuleSourceRoots(result, sourceSetModule, (ModuleBuildTarget)target);
            }
        }
        $this$forEach$iv = ModuleSettingsKt.getExpectedByModules(module);
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JpsModule commonModule = (JpsModule)element$iv;
            boolean bl5 = false;
            this.addModuleSourceRoots(result, commonModule, (ModuleBuildTarget)target);
        }
        return result;
    }

    private final void addModuleSourceRoots(List<JavaSourceRootDescriptor> result, JpsModule module, ModuleBuildTarget target) {
        Iterator iterator2 = module.getSourceRoots().iterator();
        while (iterator2.hasNext()) {
            JpsModuleSourceRoot commonSourceRoot;
            JpsModuleSourceRoot jpsModuleSourceRoot = commonSourceRoot = (JpsModuleSourceRoot)iterator2.next();
            Intrinsics.checkNotNullExpressionValue((Object)jpsModuleSourceRoot, (String)"commonSourceRoot");
            JpsModuleSourceRootType jpsModuleSourceRootType = jpsModuleSourceRoot.getRootType();
            Intrinsics.checkNotNullExpressionValue((Object)jpsModuleSourceRootType, (String)"commonSourceRoot.rootType");
            Boolean isCommonTestsRootType = KotlinSourceRootProviderKt.access$isTestsRootType$p(jpsModuleSourceRootType);
            if (isCommonTestsRootType == null || !Intrinsics.areEqual((Object)target.isTests(), (Object)isCommonTestsRootType)) continue;
            JpsElement jpsElement = commonSourceRoot.getProperties();
            if (!(jpsElement instanceof JavaSourceRootProperties)) {
                jpsElement = null;
            }
            JavaSourceRootProperties javaSourceRootProperties = (JavaSourceRootProperties)jpsElement;
            File file2 = commonSourceRoot.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"commonSourceRoot.file");
            JavaSourceRootProperties javaSourceRootProperties2 = javaSourceRootProperties;
            boolean bl = javaSourceRootProperties2 != null ? javaSourceRootProperties2.isForGeneratedSources() : false;
            Object object = javaSourceRootProperties;
            if (object == null || (object = object.getPackagePrefix()) == null) {
                object = "";
            }
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"javaSourceRootProperties?.packagePrefix ?: \"\"");
            boolean bl2 = false;
            result.add(new KotlinIncludedModuleSourceRoot(file2, target, bl, false, (String)object, SetsKt.emptySet()));
        }
    }

    public KotlinSourceRootProvider() {
        super((Collection)JavaModuleBuildTargetType.ALL_TYPES);
    }
}

