/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.git4idea.util;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import git4idea.config.GitExecutable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.codec.DecoderException;
import org.apache.xmlrpc.XmlRpcClientLite;
import org.jetbrains.annotations.NotNull;

public class ScriptGenerator {
    private final String myPrefix;
    private final Class myMainClass;
    private final ArrayList<File> myPaths = new ArrayList();
    private final ArrayList<String> myInternalParameters = new ArrayList();

    public ScriptGenerator(@NotNull String prefix, @NotNull Class mainClass) {
        this.myPrefix = prefix;
        this.myMainClass = mainClass;
        this.addClasses(this.myMainClass);
        this.addClasses(XmlRpcClientLite.class, DecoderException.class);
    }

    private void addClasses(Class ... classes) {
        for (Class c : classes) {
            File classPath = new File(PathUtil.getJarPathForClass((Class)c));
            if (this.myPaths.contains(classPath)) continue;
            this.myPaths.add(classPath);
        }
    }

    public ScriptGenerator addInternal(String ... parameters) {
        ContainerUtil.addAll(this.myInternalParameters, (Object[])parameters);
        return this;
    }

    @NotNull
    private static File generateBatch(@NotNull String fileName, @NotNull String commandLine) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("@echo off").append("\n");
        sb.append(commandLine).append(" %*").append("\n");
        return ScriptGenerator.createTempExecutable(fileName + ".bat", sb.toString());
    }

    @NotNull
    private static File generateShell(@NotNull String fileName, @NotNull String commandLine) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("#!/bin/sh").append("\n");
        sb.append(commandLine).append(" \"$@\"").append("\n");
        return ScriptGenerator.createTempExecutable(fileName + ".sh", sb.toString());
    }

    @NotNull
    private static File createTempExecutable(@NotNull String fileName, @NotNull String content) throws IOException {
        File file = new File(PathManager.getTempPath(), fileName);
        if (SystemInfo.isWindows && file.getPath().contains(" ")) {
            file = new File(FileUtil.getTempDirectory(), fileName);
        }
        FileUtil.writeToFile((File)file, (String)content);
        FileUtil.setExecutable((File)file);
        return file;
    }

    @NotNull
    public File generate(@NotNull GitExecutable executable, boolean useBatchFile) throws IOException {
        String commandLine = this.commandLine(executable);
        return useBatchFile ? ScriptGenerator.generateBatch(this.myPrefix, commandLine) : ScriptGenerator.generateShell(this.myPrefix, commandLine);
    }

    public String commandLine(@NotNull GitExecutable executable) {
        StringBuilder cmd = new StringBuilder();
        if (executable instanceof GitExecutable.Wsl) {
            ArrayList envs = ContainerUtil.newArrayList((Object[])new String[]{"INTELLIJ_SSH_ASKPASS_HANDLER", "INTELLIJ_SSH_ASKPASS_PORT", "GIT_ASKPASS_HANDLER", "GIT_ASKPASS_PORT", "IDEA_REBASE_HANDER_NO"});
            cmd.append("export WSLENV=");
            cmd.append(StringUtil.join((Collection)envs, it -> it + "/w", (String)":"));
            cmd.append("\n");
            cmd.append('\"');
            File javaExecutable = new File(String.format("%s\\bin\\java.exe", System.getProperty("java.home")));
            cmd.append(executable.convertFilePath(javaExecutable));
            cmd.append('\"');
        } else {
            cmd.append('\"');
            cmd.append(String.format("%s/bin/java", System.getProperty("java.home")));
            cmd.append('\"');
        }
        cmd.append(" -cp ");
        cmd.append('\"');
        String classpathSeparator = String.valueOf(File.pathSeparatorChar);
        cmd.append(StringUtil.join(this.myPaths, file -> file.getPath(), (String)classpathSeparator));
        cmd.append('\"');
        cmd.append(' ');
        cmd.append(this.myMainClass.getName());
        for (String p : this.myInternalParameters) {
            cmd.append(' ');
            cmd.append(p);
        }
        String line = cmd.toString();
        if (SystemInfo.isWindows) {
            line = line.replace('\\', '/');
        }
        return line;
    }
}

