/*
 * Decompiled with CFR 0.152.
 */
package git4idea.update;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.update.SequentialUpdatesContext;
import com.intellij.openapi.vcs.update.UpdateEnvironment;
import com.intellij.openapi.vcs.update.UpdateSession;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.impl.PostponableLogRefresher;
import git4idea.GitUtil;
import git4idea.branch.GitBranchPair;
import git4idea.config.GitVcsSettings;
import git4idea.config.UpdateMethod;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.update.GitUpdateConfigurable;
import git4idea.update.GitUpdateInfoAsLog;
import git4idea.update.GitUpdateProcess;
import git4idea.update.GitUpdateSession;
import git4idea.update.HashRange;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitUpdateEnvironment
implements UpdateEnvironment {
    private final Project myProject;

    public GitUpdateEnvironment(@NotNull Project project) {
        this.myProject = project;
    }

    public void fillGroups(UpdatedFiles updatedFiles) {
    }

    @NotNull
    public UpdateSession updateDirectories(FilePath @NotNull [] filePaths, UpdatedFiles updatedFiles, ProgressIndicator progressIndicator, @NotNull Ref<SequentialUpdatesContext> sequentialUpdatesContextRef) throws ProcessCanceledException {
        return GitUpdateEnvironment.performUpdate(this.myProject, filePaths, updatedFiles, progressIndicator, GitVcsSettings.getInstance(this.myProject).getUpdateMethod(), null);
    }

    public boolean validateOptions(Collection<FilePath> filePaths) {
        for (FilePath p : filePaths) {
            if (GitUtil.isUnderGit(p)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public Configurable createConfigurable(Collection<FilePath> files) {
        return new GitUpdateConfigurable(GitVcsSettings.getInstance(this.myProject));
    }

    public boolean hasCustomNotification() {
        boolean keepLogUpToDate = PostponableLogRefresher.keepUpToDate();
        return Registry.is((String)"git.update.project.info.as.log") && keepLogUpToDate;
    }

    @ApiStatus.Internal
    public static UpdateSession performUpdate(Project project, FilePath[] filePaths, UpdatedFiles updatedFiles, ProgressIndicator progressIndicator, UpdateMethod updateMethod, Map<GitRepository, GitBranchPair> updateConfig) {
        GitRepositoryManager manager = GitRepositoryManager.getInstance(project);
        Set repositories = ContainerUtil.map2SetNotNull(Arrays.asList(filePaths), arg_0 -> ((GitRepositoryManager)manager).getRepositoryForFile(arg_0));
        GitUpdateProcess gitUpdateProcess = new GitUpdateProcess(project, progressIndicator, repositories, updatedFiles, updateConfig, true, true);
        boolean result2 = gitUpdateProcess.update(updateMethod).isSuccess();
        Map<GitRepository, HashRange> updatedRanges = gitUpdateProcess.getUpdatedRanges();
        GitUpdateInfoAsLog.NotificationData notificationData = updatedRanges != null ? new GitUpdateInfoAsLog(project, updatedRanges).calculateDataAndCreateLogTab() : null;
        return new GitUpdateSession(project, notificationData, result2, gitUpdateProcess.getSkippedRoots());
    }
}

