/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch.dashboard;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.MultiRootBranches;
import com.intellij.dvcs.branch.GroupingKey;
import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.dvcs.repo.Repository;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.vcs.log.VcsLogProperties;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import git4idea.GitProtectedBranchesKt;
import git4idea.GitUtil;
import git4idea.actions.GitFetch;
import git4idea.branch.GitBranchType;
import git4idea.branch.GitBrancher;
import git4idea.config.GitVcsSettings;
import git4idea.fetch.GitFetchResult;
import git4idea.fetch.GitFetchSupport;
import git4idea.i18n.GitBundle;
import git4idea.i18n.GitBundleExtensions;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.ui.branch.BranchGroupingAction;
import git4idea.ui.branch.GitBranchActionsUtilKt;
import git4idea.ui.branch.GitBranchManager;
import git4idea.ui.branch.GitBranchPopupActions;
import git4idea.ui.branch.dashboard.BranchInfo;
import git4idea.ui.branch.dashboard.BranchesDashboardActions$sam$i$java_lang_Runnable$0;
import git4idea.ui.branch.dashboard.BranchesDashboardActions$sam$java_util_function_Supplier$0;
import git4idea.ui.branch.dashboard.BranchesDashboardController;
import git4idea.ui.branch.dashboard.BranchesDashboardUi;
import git4idea.ui.branch.dashboard.BranchesDashboardUiKt;
import git4idea.ui.branch.dashboard.BranchesTreeModelKt;
import git4idea.ui.branch.dashboard.FilteringBranchesTree;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0014\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0012\u0003\u0004\u0005\u0006\u0007\b\t\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0015"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions;", "", "()V", "BranchActionsBuilder", "BranchesActionBase", "BranchesTreeActionGroup", "CheckoutSelectedBranchAction", "CurrentBranchActions", "DeleteBranchAction", "FetchAction", "GroupByDirectoryAction", "HideBranchesAction", "LocalBranchActions", "MultipleLocalBranchActions", "NewBranchAction", "RenameLocalBranch", "ShowArbitraryBranchesDiffAction", "ShowBranchDiffAction", "ShowMyBranchesAction", "ToggleFavoriteAction", "UpdateSelectedBranchAction", "intellij.vcs.git"})
public final class BranchesDashboardActions {
    public static final BranchesDashboardActions INSTANCE;

    private BranchesDashboardActions() {
    }

    static {
        BranchesDashboardActions branchesDashboardActions;
        INSTANCE = branchesDashboardActions = new BranchesDashboardActions();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001d\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016\u00a2\u0006\u0002\u0010\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$BranchesTreeActionGroup;", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "Lcom/intellij/openapi/project/DumbAware;", "project", "Lcom/intellij/openapi/project/Project;", "tree", "Lgit4idea/ui/branch/dashboard/FilteringBranchesTree;", "(Lcom/intellij/openapi/project/Project;Lgit4idea/ui/branch/dashboard/FilteringBranchesTree;)V", "getChildren", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)[Lcom/intellij/openapi/actionSystem/AnAction;", "hideIfNoVisibleChildren", "", "update", "", "intellij.vcs.git"})
    public static final class BranchesTreeActionGroup
    extends ActionGroup
    implements DumbAware {
        private final Project project;
        private final FilteringBranchesTree tree;

        public void update(@NotNull AnActionEvent e) {
            Collection collection = this.tree.getSelectedBranches();
            boolean bl = false;
            boolean enabledAndVisible = !collection.isEmpty();
            e.getPresentation().setEnabledAndVisible(enabledAndVisible);
            this.setPopup(enabledAndVisible);
        }

        public boolean hideIfNoVisibleChildren() {
            return true;
        }

        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            AnAction[] anActionArray = new BranchActionsBuilder(this.project, this.tree).build();
            if (anActionArray == null || (anActionArray = anActionArray.getChildren(e)) == null) {
                anActionArray = AnAction.EMPTY_ARRAY;
            }
            return anActionArray;
        }

        public BranchesTreeActionGroup(@NotNull Project project, @NotNull FilteringBranchesTree tree) {
            this.project = project;
            this.tree = tree;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$MultipleLocalBranchActions;", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "getChildren", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)[Lcom/intellij/openapi/actionSystem/AnAction;", "intellij.vcs.git"})
    public static final class MultipleLocalBranchActions
    extends ActionGroup
    implements DumbAware {
        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            return new AnAction[]{(AnAction)new ShowArbitraryBranchesDiffAction(), (AnAction)new UpdateSelectedBranchAction(), (AnAction)new DeleteBranchAction()};
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\nJ\u001d\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$CurrentBranchActions;", "Lgit4idea/ui/branch/GitBranchPopupActions$CurrentBranchActions;", "project", "Lcom/intellij/openapi/project/Project;", "repositories", "", "Lgit4idea/repo/GitRepository;", "branchName", "", "currentRepository", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Ljava/lang/String;Lgit4idea/repo/GitRepository;)V", "getChildren", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)[Lcom/intellij/openapi/actionSystem/AnAction;", "intellij.vcs.git"})
    public static final class CurrentBranchActions
    extends GitBranchPopupActions.CurrentBranchActions {
        @Override
        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            SpreadBuilder spreadBuilder = new SpreadBuilder(2);
            spreadBuilder.add((Object)((AnAction)new NewBranchAction()));
            spreadBuilder.addSpread((Object)super.getChildren(e));
            ArrayList children = CollectionsKt.arrayListOf((Object[])((AnAction[])spreadBuilder.toArray((Object[])new AnAction[spreadBuilder.size()])));
            if (MultiRootBranches.diverged((Collection)this.myRepositories)) {
                children.add(1, new GitBranchPopupActions.LocalBranchActions.CheckoutAction(this.myProject, this.myRepositories, this.myBranchName));
            }
            Collection $this$toTypedArray$iv = children;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            AnAction[] anActionArray = thisCollection$iv.toArray(new AnAction[0]);
            if (anActionArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            return anActionArray;
        }

        public CurrentBranchActions(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull String branchName, @NotNull GitRepository currentRepository) {
            super(project, repositories, branchName, currentRepository);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\nJ\u001d\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$LocalBranchActions;", "Lgit4idea/ui/branch/GitBranchPopupActions$LocalBranchActions;", "project", "Lcom/intellij/openapi/project/Project;", "repositories", "", "Lgit4idea/repo/GitRepository;", "branchName", "", "currentRepository", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Ljava/lang/String;Lgit4idea/repo/GitRepository;)V", "getChildren", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)[Lcom/intellij/openapi/actionSystem/AnAction;", "intellij.vcs.git"})
    public static final class LocalBranchActions
    extends GitBranchPopupActions.LocalBranchActions {
        @Override
        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            AnAction[] anActionArray = super.getChildren(e);
            Collection $this$toTypedArray$iv = CollectionsKt.arrayListOf((Object[])Arrays.copyOf(anActionArray, anActionArray.length));
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            AnAction[] anActionArray2 = thisCollection$iv.toArray(new AnAction[0]);
            if (anActionArray2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            return anActionArray2;
        }

        public LocalBranchActions(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull String branchName, @NotNull GitRepository currentRepository) {
            super(project, repositories, branchName, currentRepository);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u0004\u0018\u00010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$BranchActionsBuilder;", "", "project", "Lcom/intellij/openapi/project/Project;", "tree", "Lgit4idea/ui/branch/dashboard/FilteringBranchesTree;", "(Lcom/intellij/openapi/project/Project;Lgit4idea/ui/branch/dashboard/FilteringBranchesTree;)V", "build", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "intellij.vcs.git"})
    public static final class BranchActionsBuilder {
        private final Project project;
        private final FilteringBranchesTree tree;

        @Nullable
        public final ActionGroup build() {
            Set<BranchInfo> selectedBranches = this.tree.getSelectedBranches();
            boolean multipleBranchSelection = selectedBranches.size() > 1;
            GitRepository gitRepository = (GitRepository)DvcsUtil.guessCurrentRepositoryQuick((Project)this.project, (AbstractRepositoryManager)GitUtil.getRepositoryManager(this.project), (String)GitVcsSettings.getInstance(this.project).getRecentRootPath());
            if (gitRepository == null) {
                return null;
            }
            GitRepository guessRepo = gitRepository;
            if (multipleBranchSelection) {
                return new MultipleLocalBranchActions();
            }
            BranchInfo branchInfo = (BranchInfo)CollectionsKt.singleOrNull((Iterable)selectedBranches);
            if (branchInfo == null) {
                return null;
            }
            BranchInfo branchInfo2 = branchInfo;
            return branchInfo2.isCurrent() ? (ActionGroup)new CurrentBranchActions(this.project, branchInfo2.getRepositories(), branchInfo2.getBranchName(), guessRepo) : (branchInfo2.isLocal() ? (ActionGroup)new LocalBranchActions(this.project, branchInfo2.getRepositories(), branchInfo2.getBranchName(), guessRepo) : (ActionGroup)new GitBranchPopupActions.RemoteBranchActions(this.project, branchInfo2.getRepositories(), branchInfo2.getBranchName(), guessRepo));
        }

        public BranchActionsBuilder(@NotNull Project project, @NotNull FilteringBranchesTree tree) {
            this.project = project;
            this.tree = tree;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J&\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016\u00a8\u0006\r"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$NewBranchAction;", "Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$BranchesActionBase;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "project", "Lcom/intellij/openapi/project/Project;", "branches", "", "Lgit4idea/ui/branch/dashboard/BranchInfo;", "intellij.vcs.git"})
    public static final class NewBranchAction
    extends BranchesActionBase {
        /*
         * WARNING - void declaration
         */
        @Override
        public void update(@NotNull AnActionEvent e, @NotNull Project project, @NotNull Collection<BranchInfo> branches2) {
            void $this$flatMapTo$iv$iv;
            if (branches2.size() > 1) {
                e.getPresentation().setEnabled(false);
                e.getPresentation().setDescription(GitBundle.message("action.Git.New.Branch.description", new Object[0]));
                return;
            }
            Iterable $this$flatMap$iv = branches2;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            Iterator iterator = $this$flatMapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv$iv;
                Object receiver = element$iv$iv = iterator.next();
                boolean bl = false;
                Iterable list$iv$iv = ((BranchInfo)receiver).getRepositories();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List repositories = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
            com.intellij.dvcs.ui.NewBranchAction.checkIfAnyRepositoryIsFresh((AnActionEvent)e, (List)repositories);
        }

        /*
         * WARNING - void declaration
         */
        public void actionPerformed(@NotNull AnActionEvent e) {
            void $this$flatMapTo$iv$iv;
            Object object = e.getData(BranchesTreeModelKt.getGIT_BRANCHES());
            if (object == null) {
                Intrinsics.throwNpe();
            }
            Set branches2 = (Set)object;
            Project project = e.getProject();
            if (project == null) {
                Intrinsics.throwNpe();
            }
            Project project2 = project;
            Iterable $this$flatMap$iv = branches2;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            Iterator iterator = $this$flatMapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv$iv;
                Object receiver = element$iv$iv = iterator.next();
                boolean bl = false;
                Iterable list$iv$iv = ((BranchInfo)receiver).getRepositories();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List repositories = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
            String branchName = ((BranchInfo)CollectionsKt.first((Iterable)branches2)).getBranchName();
            GitBranchActionsUtilKt.createOrCheckoutNewBranch$default(project2, repositories, branchName + "^0", GitBundle.message("action.Git.New.Branch.dialog.title", branchName), null, 16, null);
        }

        public NewBranchAction() {
            super((Function0<String>)((Function0)1.INSTANCE), (Function0<String>)((Function0)2.INSTANCE), com.intellij.dvcs.ui.NewBranchAction.icon);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J&\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016\u00a8\u0006\r"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$UpdateSelectedBranchAction;", "Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$BranchesActionBase;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "project", "Lcom/intellij/openapi/project/Project;", "branches", "", "Lgit4idea/ui/branch/dashboard/BranchInfo;", "intellij.vcs.git"})
    public static final class UpdateSelectedBranchAction
    extends BranchesActionBase {
        @Override
        public void update(@NotNull AnActionEvent e) {
            boolean bl;
            Project project = e.getProject();
            if (project != null) {
                Project project2 = project;
                boolean bl2 = false;
                boolean bl3 = false;
                Project p1 = project2;
                boolean bl4 = false;
                bl = GitBranchActionsUtilKt.hasRemotes(p1);
            } else {
                bl = false;
            }
            boolean enabledAndVisible = bl;
            e.getPresentation().setEnabledAndVisible(enabledAndVisible);
            if (enabledAndVisible) {
                super.update(e);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void update(@NotNull AnActionEvent e, @NotNull Project project, @NotNull Collection<BranchInfo> branches2) {
            void $this$mapTo$iv$iv;
            void $this$flatMapTo$iv$iv;
            Object element$iv;
            boolean bl;
            Presentation presentation;
            block8: {
                presentation = e.getPresentation();
                if (GitFetchSupport.fetchSupport(project).isFetchRunning()) {
                    presentation.setEnabled(false);
                    presentation.setDescription(GitBundle.message("action.Git.Update.Selected.description.already.running", new Object[0]));
                    return;
                }
                Iterable $this$any$iv = branches2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    Iterator iterator = $this$any$iv.iterator();
                    while (iterator.hasNext()) {
                        Object receiver = element$iv = iterator.next();
                        boolean bl2 = false;
                        if (!((BranchInfo)receiver).isCurrent()) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
            }
            if (bl) {
                presentation.setEnabled(false);
                presentation.setDescription(GitBundle.message("action.Git.Update.Selected.description.select.non.current", new Object[0]));
                return;
            }
            Iterable $this$flatMap$iv = branches2;
            boolean $i$f$flatMap = false;
            element$iv = $this$flatMap$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            Iterator iterator = $this$flatMapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv$iv;
                Object receiver = element$iv$iv = iterator.next();
                boolean bl3 = false;
                Iterable list$iv$iv = ((BranchInfo)receiver).getRepositories();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List repositories = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
            Iterable $this$map$iv = branches2;
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void receiver;
                Object item$iv$iv;
                Object bl3 = item$iv$iv = iterator2.next();
                Collection collection = destination$iv$iv2;
                boolean $i$a$-unknown-Object2 = false;
                String string = ((BranchInfo)receiver).getBranchName();
                collection.add(string);
            }
            List branchNames = (List)destination$iv$iv2;
            presentation.setDescription(GitBundle.message("action.Git.Update.Selected.description", branches2.size(), branches2.size()));
            boolean trackingInfosExist = GitBranchActionsUtilKt.isTrackingInfosExist(branchNames, repositories);
            presentation.setEnabled(trackingInfosExist);
            if (!trackingInfosExist) {
                presentation.setDescription(GitBundle.message("action.Git.Update.Selected.description.tracking.not.configured", branches2.size()));
            }
        }

        /*
         * WARNING - void declaration
         */
        public void actionPerformed(@NotNull AnActionEvent e) {
            void $this$mapTo$iv$iv;
            void $this$flatMapTo$iv$iv;
            Object object = e.getData(BranchesTreeModelKt.getGIT_BRANCHES());
            if (object == null) {
                Intrinsics.throwNpe();
            }
            Set branches2 = (Set)object;
            Project project = e.getProject();
            if (project == null) {
                Intrinsics.throwNpe();
            }
            Project project2 = project;
            Iterable $this$flatMap$iv = branches2;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            Iterator iterator = $this$flatMapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv$iv;
                Object receiver = element$iv$iv = iterator.next();
                boolean bl = false;
                Iterable list$iv$iv = ((BranchInfo)receiver).getRepositories();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List repositories = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
            Iterable $this$map$iv = branches2;
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void receiver;
                Object item$iv$iv;
                Object bl = item$iv$iv = iterator2.next();
                Collection collection = destination$iv$iv2;
                boolean $i$a$-unknown-Object2 = false;
                String string = ((BranchInfo)receiver).getBranchName();
                collection.add(string);
            }
            List branchNames = (List)destination$iv$iv2;
            GitBranchActionsUtilKt.updateBranches(project2, repositories, branchNames);
        }

        public UpdateSelectedBranchAction() {
            super(GitBundleExtensions.INSTANCE.messagePointer("action.Git.Update.Selected.text", new Object[0]), null, AllIcons.Actions.CheckOut, 2, null);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J&\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016\u00a8\u0006\u000e"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$DeleteBranchAction;", "Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$BranchesActionBase;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "delete", "project", "Lcom/intellij/openapi/project/Project;", "branches", "", "Lgit4idea/ui/branch/dashboard/BranchInfo;", "update", "intellij.vcs.git"})
    public static final class DeleteBranchAction
    extends BranchesActionBase {
        @Override
        public void update(@NotNull AnActionEvent e, @NotNull Project project, @NotNull Collection<BranchInfo> branches2) {
            boolean bl;
            block3: {
                e.getPresentation().setText(GitBundle.message("action.Git.Delete.Branch.title", branches2.size()));
                Iterable $this$any$iv = branches2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        BranchInfo it = (BranchInfo)element$iv;
                        boolean bl2 = false;
                        if (!(it.isCurrent() || !it.isLocal() && GitProtectedBranchesKt.isRemoteBranchProtected((Collection<? extends GitRepository>)it.getRepositories(), it.getBranchName()))) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            boolean disabled = bl;
            e.getPresentation().setEnabled(!disabled);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Object object = e.getData(BranchesTreeModelKt.getGIT_BRANCHES());
            if (object == null) {
                Intrinsics.throwNpe();
            }
            Set branches2 = (Set)object;
            Project project = e.getProject();
            if (project == null) {
                Intrinsics.throwNpe();
            }
            Project project2 = project;
            this.delete(project2, branches2);
        }

        /*
         * WARNING - void declaration
         */
        private final void delete(Project project, Collection<BranchInfo> branches2) {
            void $this$associateTo$iv$iv;
            void localBranches;
            Object it;
            GitBrancher gitBrancher = GitBrancher.getInstance(project);
            Iterable $this$partition$iv = branches2;
            boolean $i$f$partition = false;
            ArrayList first$iv = new ArrayList();
            ArrayList second$iv = new ArrayList();
            for (Object element$iv : $this$partition$iv) {
                it = (BranchInfo)element$iv;
                boolean bl = false;
                if (((BranchInfo)it).isLocal() && !((BranchInfo)it).isCurrent()) {
                    first$iv.add(element$iv);
                    continue;
                }
                second$iv.add(element$iv);
            }
            Pair pair = new Pair(first$iv, second$iv);
            List list = (List)pair.component1();
            List remoteBranches = (List)pair.component2();
            boolean bl = false;
            boolean bl2 = false;
            GitBrancher $this$with = gitBrancher;
            boolean bl3 = false;
            Iterable $this$associate$iv = (Iterable)localBranches;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            it = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map2 = destination$iv$iv;
                BranchInfo it2 = (BranchInfo)element$iv$iv;
                boolean bl4 = false;
                Pair pair2 = TuplesKt.to((Object)it2.getBranchName(), it2.getRepositories());
                boolean bl5 = false;
                map2.put(pair2.getFirst(), pair2.getSecond());
            }
            Map branchesToContainingRepositories = destination$iv$iv;
            Set localBranchNames = branchesToContainingRepositories.keySet();
            Function0 deleteRemoteBranches = (Function0)new Function0<Unit>($this$with, (List)localBranches, remoteBranches){
                final /* synthetic */ GitBrancher $this_with;
                final /* synthetic */ List $localBranches$inlined;
                final /* synthetic */ List $remoteBranches$inlined;
                {
                    this.$this_with = gitBrancher;
                    this.$localBranches$inlined = list;
                    this.$remoteBranches$inlined = list2;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    void $this$flatMapTo$iv$iv;
                    void $this$flatMap$iv;
                    Object object;
                    T receiver;
                    boolean bl;
                    Collection<String> collection;
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv = this.$remoteBranches$inlined;
                    GitBrancher gitBrancher = this.$this_with;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    Iterator<T> iterator = $this$mapTo$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        T item$iv$iv;
                        T t = item$iv$iv = iterator.next();
                        collection = destination$iv$iv;
                        bl = false;
                        object = ((BranchInfo)receiver).getBranchName();
                        collection.add((String)object);
                    }
                    collection = (List)destination$iv$iv;
                    $this$map$iv = this.$remoteBranches$inlined;
                    boolean $i$f$flatMap = false;
                    $this$mapTo$iv$iv = $this$flatMap$iv;
                    destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$flatMapTo = false;
                    iterator = $this$flatMapTo$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        T element$iv$iv;
                        receiver = element$iv$iv = iterator.next();
                        bl = false;
                        Iterable list$iv$iv = ((BranchInfo)receiver).getRepositories();
                        CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                    }
                    object = (List)destination$iv$iv;
                    gitBrancher.deleteRemoteBranches((List<String>)collection, CollectionsKt.distinct((Iterable)((Iterable)object)));
                }
            };
            Collection collection = localBranchNames;
            boolean bl6 = false;
            if (!collection.isEmpty()) {
                collection = deleteRemoteBranches;
                $this$with.deleteBranches(branchesToContainingRepositories, new BranchesDashboardActions$sam$i$java_lang_Runnable$0((Function0)collection));
            } else {
                deleteRemoteBranches.invoke();
            }
        }

        public DeleteBranchAction() {
            super(null, null, AllIcons.Actions.GC, 3, null);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J&\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016\u00a8\u0006\r"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$ShowBranchDiffAction;", "Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$BranchesActionBase;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "project", "Lcom/intellij/openapi/project/Project;", "branches", "", "Lgit4idea/ui/branch/dashboard/BranchInfo;", "intellij.vcs.git"})
    public static final class ShowBranchDiffAction
    extends BranchesActionBase {
        @Override
        public void update(@NotNull AnActionEvent e, @NotNull Project project, @NotNull Collection<BranchInfo> branches2) {
            boolean bl;
            block4: {
                Iterable $this$none$iv = branches2;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        BranchInfo it = (BranchInfo)element$iv;
                        boolean bl2 = false;
                        if (!(!it.isCurrent())) continue;
                        bl = false;
                        break block4;
                    }
                    bl = true;
                }
            }
            if (bl) {
                e.getPresentation().setEnabled(false);
                e.getPresentation().setDescription(GitBundle.message("action.Git.Update.Selected.description.select.non.current", new Object[0]));
            }
        }

        /*
         * WARNING - void declaration
         */
        public void actionPerformed(@NotNull AnActionEvent e) {
            void $this$filterNotTo$iv$iv;
            Object object = e.getData(BranchesTreeModelKt.getGIT_BRANCHES());
            if (object == null) {
                Intrinsics.throwNpe();
            }
            Set branches2 = (Set)object;
            Project project = e.getProject();
            if (project == null) {
                Intrinsics.throwNpe();
            }
            Project project2 = project;
            GitBrancher gitBrancher = GitBrancher.getInstance(project2);
            Iterable $this$filterNot$iv = branches2;
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            Iterator iterator = $this$filterNotTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv$iv;
                Object receiver = element$iv$iv = iterator.next();
                boolean bl = false;
                if (((BranchInfo)receiver).isCurrent()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (BranchInfo branch : (List)destination$iv$iv) {
                gitBrancher.compare(branch.getBranchName(), branch.getRepositories());
            }
        }

        public ShowBranchDiffAction() {
            super(GitBundleExtensions.INSTANCE.messagePointer("action.Git.Compare.With.Current.title", new Object[0]), null, AllIcons.Actions.Diff, 2, null);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J&\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016\u00a8\u0006\r"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$ShowArbitraryBranchesDiffAction;", "Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$BranchesActionBase;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "project", "Lcom/intellij/openapi/project/Project;", "branches", "", "Lgit4idea/ui/branch/dashboard/BranchInfo;", "intellij.vcs.git"})
    public static final class ShowArbitraryBranchesDiffAction
    extends BranchesActionBase {
        @Override
        public void update(@NotNull AnActionEvent e, @NotNull Project project, @NotNull Collection<BranchInfo> branches2) {
            if (branches2.size() != 2) {
                e.getPresentation().setEnabledAndVisible(false);
                e.getPresentation().setDescription("");
            } else {
                e.getPresentation().setDescription(GitBundle.message("action.Git.Compare.Selected.description", new Object[0]));
                Set commonRepositories = CollectionsKt.intersect((Iterable)((BranchInfo)CollectionsKt.elementAt((Iterable)branches2, (int)0)).getRepositories(), (Iterable)((BranchInfo)CollectionsKt.elementAt((Iterable)branches2, (int)1)).getRepositories());
                if (commonRepositories.isEmpty()) {
                    e.getPresentation().setEnabled(false);
                    e.getPresentation().setDescription(GitBundle.message("action.Git.Compare.Selected.description.disabled", new Object[0]));
                }
            }
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Object object = e.getData(BranchesTreeModelKt.getGIT_BRANCHES());
            if (object == null) {
                Intrinsics.throwNpe();
            }
            Set branches2 = (Set)object;
            BranchInfo branchOne = (BranchInfo)CollectionsKt.elementAt((Iterable)branches2, (int)0);
            BranchInfo branchTwo = (BranchInfo)CollectionsKt.elementAt((Iterable)branches2, (int)1);
            Set commonRepositories = CollectionsKt.intersect((Iterable)branchOne.getRepositories(), (Iterable)branchTwo.getRepositories());
            Project project = e.getProject();
            if (project == null) {
                Intrinsics.throwNpe();
            }
            GitBrancher gitBrancher = GitBrancher.getInstance(project);
            gitBrancher.compareAny(branchOne.getBranchName(), branchTwo.getBranchName(), CollectionsKt.toList((Iterable)commonRepositories));
        }

        public ShowArbitraryBranchesDiffAction() {
            super(GitBundleExtensions.INSTANCE.messagePointer("action.Git.Compare.Selected.title", new Object[0]), null, AllIcons.Actions.Diff, 2, null);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0007H\u0016J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$ShowMyBranchesAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "Lcom/intellij/openapi/project/DumbAware;", "uiController", "Lgit4idea/ui/branch/dashboard/BranchesDashboardController;", "(Lgit4idea/ui/branch/dashboard/BranchesDashboardController;)V", "isSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "update", "intellij.vcs.git"})
    public static final class ShowMyBranchesAction
    extends ToggleAction
    implements DumbAware {
        private final BranchesDashboardController uiController;

        public boolean isSelected(@NotNull AnActionEvent e) {
            return this.uiController.getShowOnlyMy();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            this.uiController.setShowOnlyMy(state);
        }

        public void update(@NotNull AnActionEvent e) {
            boolean bl;
            boolean isGraphReady;
            boolean supportsIndexing;
            block10: {
                Object it;
                boolean bl2;
                VcsProjectLog log;
                Project project;
                block9: {
                    super.update(e);
                    project = (Project)e.getData(CommonDataKeys.PROJECT);
                    if (project == null) {
                        e.getPresentation().setEnabled(false);
                        return;
                    }
                    log = VcsProjectLog.getInstance((Project)project);
                    Object object = log.getDataManager();
                    if (object != null && (object = object.getLogProviders()) != null) {
                        Object $this$all$iv = object;
                        boolean $i$f$all = false;
                        if ($this$all$iv.isEmpty()) {
                            bl2 = true;
                        } else {
                            Object object2 = $this$all$iv;
                            boolean bl3 = false;
                            for (Map.Entry element$iv : object2.entrySet()) {
                                it = element$iv;
                                boolean bl4 = false;
                                if (((Boolean)VcsLogProperties.SUPPORTS_INDEXING.getOrDefault((VcsLogProvider)it.getValue())).booleanValue()) continue;
                                bl2 = false;
                                break block9;
                            }
                            bl2 = true;
                        }
                    } else {
                        bl2 = false;
                    }
                }
                supportsIndexing = bl2;
                VcsLogData vcsLogData = log.getDataManager();
                isGraphReady = vcsLogData != null && (vcsLogData = vcsLogData.getDataPack()) != null ? vcsLogData.isFull() : false;
                Iterable $this$all$iv = GitRepositoryManager.getInstance(project).getRepositories();
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Map.Entry element$iv : $this$all$iv) {
                        it = (GitRepository)((Object)element$iv);
                        boolean bl5 = false;
                        VcsLogData vcsLogData2 = log.getDataManager();
                        if (vcsLogData2 != null && (vcsLogData2 = vcsLogData2.getIndex()) != null ? vcsLogData2.isIndexed(it.getRoot()) : false) continue;
                        bl = false;
                        break block10;
                    }
                    bl = true;
                }
            }
            boolean allRootsIndexed = bl;
            e.getPresentation().setEnabled(supportsIndexing && isGraphReady && allRootsIndexed);
            e.getPresentation().setDescription(!supportsIndexing ? GitBundle.message("action.Git.Show.My.Branches.description.not.support.indexing", new Object[0]) : (!allRootsIndexed ? GitBundle.message("action.Git.Show.My.Branches.description.not.all.roots.indexed", new Object[0]) : (!isGraphReady ? GitBundle.message("action.Git.Show.My.Branches.description.not.graph.ready", new Object[0]) : GitBundle.message("action.Git.Show.My.Branches.description.is.my.branch", new Object[0]))));
        }

        public ShowMyBranchesAction(@NotNull BranchesDashboardController uiController) {
            Object object = GitBundleExtensions.INSTANCE.messagePointer("action.Git.Show.My.Branches.title", new Object[0]);
            if (object != null) {
                Function0<String> function0 = object;
                object = new BranchesDashboardActions$sam$java_util_function_Supplier$0(function0);
            }
            super((Supplier)object, AllIcons.Actions.Find);
            this.uiController = uiController;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$FetchAction;", "Lgit4idea/actions/GitFetch;", "ui", "Lgit4idea/ui/branch/dashboard/BranchesDashboardUi;", "(Lgit4idea/ui/branch/dashboard/BranchesDashboardUi;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "onFetchFinished", "result", "Lgit4idea/fetch/GitFetchResult;", "update", "intellij.vcs.git"})
    public static final class FetchAction
    extends GitFetch {
        private final BranchesDashboardUi ui;

        @Override
        public void update(@NotNull AnActionEvent e) {
            super.update(e);
            Presentation presentation = e.getPresentation();
            boolean bl = false;
            boolean bl2 = false;
            Presentation $this$with = presentation;
            boolean bl3 = false;
            $this$with.setText(GitBundle.message("action.Git.Fetch.title", new Object[0]));
            $this$with.setIcon(AllIcons.Actions.Refresh);
            $this$with.setDescription("");
            Project project = e.getProject();
            if (project == null) {
            } else {
                Project project2 = project;
                if (GitFetchSupport.fetchSupport(project2).isFetchRunning()) {
                    $this$with.setEnabled(false);
                    $this$with.setDescription(GitBundle.message("action.Git.Fetch.description.fetch.in.progress", new Object[0]));
                }
            }
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            this.ui.startLoadingBranches();
            super.actionPerformed(e);
        }

        @Override
        protected void onFetchFinished(@NotNull GitFetchResult result2) {
            this.ui.stopLoadingBranches();
        }

        public FetchAction(@NotNull BranchesDashboardUi ui) {
            this.ui = ui;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$ToggleFavoriteAction;", "Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$BranchesActionBase;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.vcs.git"})
    public static final class ToggleFavoriteAction
    extends BranchesActionBase {
        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project = e.getProject();
            if (project == null) {
                Intrinsics.throwNpe();
            }
            Project project2 = project;
            Object object = e.getData(BranchesTreeModelKt.getGIT_BRANCHES());
            if (object == null) {
                Intrinsics.throwNpe();
            }
            Set branches2 = (Set)object;
            Project $this$service$iv = project2;
            boolean $i$f$service = false;
            GitBranchManager gitBranchManager = (GitBranchManager)((Object)$this$service$iv.getService(GitBranchManager.class));
            for (BranchInfo branch : branches2) {
                GitBranchType type = branch.isLocal() ? GitBranchType.LOCAL : GitBranchType.REMOTE;
                for (GitRepository repository : branch.getRepositories()) {
                    gitBranchManager.setFavorite(type, repository, branch.getBranchName(), !branch.isFavorite());
                }
            }
        }

        public ToggleFavoriteAction() {
            super(GitBundleExtensions.INSTANCE.messagePointer("action.Git.Toggle.Favorite.title", new Object[0]), null, AllIcons.Nodes.Favorite, 2, null);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$GroupByDirectoryAction;", "Lgit4idea/ui/branch/BranchGroupingAction;", "tree", "Lgit4idea/ui/branch/dashboard/FilteringBranchesTree;", "(Lgit4idea/ui/branch/dashboard/FilteringBranchesTree;)V", "setSelected", "", "key", "Lcom/intellij/dvcs/branch/GroupingKey;", "state", "", "intellij.vcs.git"})
    public static final class GroupByDirectoryAction
    extends BranchGroupingAction {
        private final FilteringBranchesTree tree;

        @Override
        public void setSelected(@NotNull GroupingKey key, boolean state) {
            this.tree.toggleDirectoryGrouping(state);
        }

        public GroupByDirectoryAction(@NotNull FilteringBranchesTree tree) {
            super(GroupingKey.GROUPING_BY_DIRECTORY, AllIcons.Actions.GroupByPackage);
            this.tree = tree;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$HideBranchesAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "intellij.vcs.git"})
    public static final class HideBranchesAction
    extends DumbAwareAction {
        public void update(@NotNull AnActionEvent e) {
            VcsLogUiProperties properties = (VcsLogUiProperties)e.getData(VcsLogInternalDataKeys.LOG_UI_PROPERTIES);
            e.getPresentation().setEnabledAndVisible(properties != null && properties.exists((VcsLogUiProperties.VcsLogUiProperty)BranchesDashboardUiKt.getSHOW_GIT_BRANCHES_LOG_PROPERTY()));
            super.update(e);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            VcsLogUiProperties properties = (VcsLogUiProperties)e.getData(VcsLogInternalDataKeys.LOG_UI_PROPERTIES);
            if (properties != null && properties.exists((VcsLogUiProperties.VcsLogUiProperty)BranchesDashboardUiKt.getSHOW_GIT_BRANCHES_LOG_PROPERTY())) {
                properties.set((VcsLogUiProperties.VcsLogUiProperty)BranchesDashboardUiKt.getSHOW_GIT_BRANCHES_LOG_PROPERTY(), (Object)false);
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B1\u0012\u000e\b\u0003\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0003\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J&\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$BranchesActionBase;", "Lcom/intellij/openapi/project/DumbAwareAction;", "text", "Lkotlin/Function0;", "", "description", "icon", "Ljavax/swing/Icon;", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Ljavax/swing/Icon;)V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "project", "Lcom/intellij/openapi/project/Project;", "branches", "", "Lgit4idea/ui/branch/dashboard/BranchInfo;", "intellij.vcs.git"})
    public static abstract class BranchesActionBase
    extends DumbAwareAction {
        private final Function0<String> description;

        public void update(@NotNull AnActionEvent e, @NotNull Project project, @NotNull Collection<BranchInfo> branches2) {
        }

        /*
         * Unable to fully structure code
         */
        public void update(@NotNull AnActionEvent e) {
            branches = (Set)e.getData(BranchesTreeModelKt.getGIT_BRANCHES());
            project = e.getProject();
            if (project == null || branches == null) ** GOTO lbl-1000
            var5_4 = branches;
            var6_5 = false;
            if (var5_4.isEmpty() == false) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
            enabled = v0;
            e.getPresentation().setEnabled(enabled);
            e.getPresentation().setDescription((String)this.description.invoke());
            if (enabled) {
                v1 = project;
                if (v1 == null) {
                    Intrinsics.throwNpe();
                }
                v2 = branches;
                if (v2 == null) {
                    Intrinsics.throwNpe();
                }
                this.update(e, v1, v2);
            }
        }

        public BranchesActionBase(@Nls(capitalization=Nls.Capitalization.Title) @NotNull Function0<String> text, @Nls(capitalization=Nls.Capitalization.Sentence) @NotNull Function0<String> description, @Nullable Icon icon) {
            Function0<String> function0;
            Object object = text;
            if (object != null) {
                function0 = object;
                object = new BranchesDashboardActions$sam$java_util_function_Supplier$0(function0);
            }
            Supplier supplier = (Supplier)object;
            Object object2 = description;
            if (object2 != null) {
                function0 = object2;
                object2 = new BranchesDashboardActions$sam$java_util_function_Supplier$0(function0);
            }
            super(supplier, (Supplier)object2, icon);
            this.description = description;
        }

        public /* synthetic */ BranchesActionBase(Function0 function0, Function0 function02, Icon icon, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                function0 = 1.INSTANCE;
            }
            if ((n & 2) != 0) {
                function02 = 2.INSTANCE;
            }
            if ((n & 4) != 0) {
                icon = null;
            }
            this((Function0<String>)function0, (Function0<String>)function02, icon);
        }

        public BranchesActionBase() {
            this(null, null, null, 7, null);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J&\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016\u00a8\u0006\r"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$CheckoutSelectedBranchAction;", "Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$BranchesActionBase;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "project", "Lcom/intellij/openapi/project/Project;", "branches", "", "Lgit4idea/ui/branch/dashboard/BranchInfo;", "intellij.vcs.git"})
    public static final class CheckoutSelectedBranchAction
    extends BranchesActionBase {
        @Override
        public void update(@NotNull AnActionEvent e, @NotNull Project project, @NotNull Collection<BranchInfo> branches2) {
            if (branches2.size() > 1) {
                e.getPresentation().setEnabled(false);
                return;
            }
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project = e.getProject();
            if (project == null) {
                Intrinsics.throwNpe();
            }
            Project project2 = project;
            Object object = e.getData(BranchesTreeModelKt.getGIT_BRANCHES());
            if (object == null) {
                Intrinsics.throwNpe();
            }
            BranchInfo branchInfo = (BranchInfo)CollectionsKt.firstOrNull((Iterable)((Iterable)object));
            if (branchInfo == null) {
                return;
            }
            BranchInfo branch = branchInfo;
            if (branch.isLocal()) {
                GitBranchPopupActions.LocalBranchActions.CheckoutAction.checkoutBranch(project2, branch.getRepositories(), branch.getBranchName());
            } else {
                GitBranchPopupActions.RemoteBranchActions.CheckoutRemoteBranchAction.checkoutRemoteBranch(project2, branch.getRepositories(), branch.getBranchName());
            }
        }

        public CheckoutSelectedBranchAction() {
            super(null, null, null, 7, null);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J&\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016\u00a8\u0006\r"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$RenameLocalBranch;", "Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$BranchesActionBase;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "project", "Lcom/intellij/openapi/project/Project;", "branches", "", "Lgit4idea/ui/branch/dashboard/BranchInfo;", "intellij.vcs.git"})
    public static final class RenameLocalBranch
    extends BranchesActionBase {
        @Override
        public void update(@NotNull AnActionEvent e, @NotNull Project project, @NotNull Collection<BranchInfo> branches2) {
            block10: {
                block9: {
                    boolean bl;
                    block8: {
                        if (branches2.size() > 1) {
                            e.getPresentation().setEnabled(false);
                            return;
                        }
                        BranchInfo branch = (BranchInfo)CollectionsKt.firstOrNull((Iterable)branches2);
                        if (branch == null || !branch.isLocal()) break block9;
                        Iterable $this$any$iv = branch.getRepositories();
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                Repository p1 = (Repository)element$iv;
                                boolean bl2 = false;
                                if (!p1.isFresh()) continue;
                                bl = true;
                                break block8;
                            }
                            bl = false;
                        }
                    }
                    if (!bl) break block10;
                }
                e.getPresentation().setEnabled(false);
            }
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project = e.getProject();
            if (project == null) {
                Intrinsics.throwNpe();
            }
            Project project2 = project;
            Object object = e.getData(BranchesTreeModelKt.getGIT_BRANCHES());
            if (object == null) {
                Intrinsics.throwNpe();
            }
            BranchInfo branchInfo = (BranchInfo)CollectionsKt.firstOrNull((Iterable)((Iterable)object));
            if (branchInfo == null) {
                return;
            }
            BranchInfo branch = branchInfo;
            GitBranchPopupActions.LocalBranchActions.RenameBranchAction.rename(project2, branch.getRepositories(), branch.getBranchName());
        }

        public RenameLocalBranch() {
            super(null, null, null, 7, null);
        }
    }
}

