/*
 * Decompiled with CFR 0.152.
 */
package git4idea.status;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vcs.impl.projectlevelman.RecursiveFilePathSet;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.Topic;
import git4idea.index.GitFileStatus;
import git4idea.index.GitIndexStatusUtilKt;
import git4idea.repo.GitConflict;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitStagingAreaHolder {
    private static final Logger LOG = Logger.getInstance(GitStagingAreaHolder.class);
    public static final Topic<StagingAreaListener> TOPIC = Topic.create((String)"GitStagingAreaHolder change", StagingAreaListener.class);
    private final Project myProject;
    private final GitRepository myRepository;
    private final Object LOCK = new Object();
    private final List<GitFileStatus> myRecords = new ArrayList<GitFileStatus>();

    public GitStagingAreaHolder(@NotNull GitRepository repository) {
        this.myProject = repository.getProject();
        this.myRepository = repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<GitFileStatus> getAllRecords() {
        Object object = this.LOCK;
        synchronized (object) {
            return new ArrayList<GitFileStatus>(this.myRecords);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public GitFileStatus findRecord(@NotNull FilePath path) {
        Object object = this.LOCK;
        synchronized (object) {
            return (GitFileStatus)ContainerUtil.find(this.myRecords, it -> it.getPath().equals(path));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<GitConflict> getAllConflicts() {
        Object object = this.LOCK;
        synchronized (object) {
            return ContainerUtil.mapNotNull(this.myRecords, this::createConflict);
        }
    }

    @Nullable
    public GitConflict findConflict(@NotNull FilePath path) {
        return this.createConflict(this.findRecord(path));
    }

    @Nullable
    private GitConflict createConflict(@Nullable GitFileStatus record) {
        if (record == null) {
            return null;
        }
        if (!GitIndexStatusUtilKt.isConflicted(record.getIndex(), record.getWorkTree())) {
            return null;
        }
        return new GitConflict(this.myRepository.getRoot(), record.getPath(), GitStagingAreaHolder.getConflictStatus(record.getIndex()), GitStagingAreaHolder.getConflictStatus(record.getWorkTree()));
    }

    @NotNull
    private static GitConflict.Status getConflictStatus(char status) {
        if (status == 'A') {
            return GitConflict.Status.ADDED;
        }
        if (status == 'D') {
            return GitConflict.Status.DELETED;
        }
        return GitConflict.Status.MODIFIED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    @ApiStatus.Internal
    public List<GitFileStatus> refresh(@NotNull List<FilePath> dirtyPaths) throws VcsException {
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        VirtualFile root = this.myRepository.getRoot();
        RecursiveFilePathSet dirtyScope = new RecursiveFilePathSet(true);
        for (FilePath path : dirtyPaths) {
            dirtyScope.add(path);
        }
        List<GitFileStatus> rootRecords = GitIndexStatusUtilKt.getStatus(this.myProject, root, dirtyPaths, true, false, false);
        rootRecords.removeIf(record -> {
            boolean isUnderOurRoot;
            boolean isUnderDirtyScope = GitStagingAreaHolder.isUnder(record, dirtyScope);
            if (!isUnderDirtyScope) {
                return true;
            }
            VirtualFile recordRoot = vcsManager.getVcsRootFor(record.getPath());
            boolean bl = isUnderOurRoot = root.equals(recordRoot) || GitStagingAreaHolder.isSubmoduleStatus(record, recordRoot);
            if (!isUnderOurRoot) {
                LOG.warn(String.format("Ignoring change under another root: %s; root: %s; mapped root: %s", record, root, recordRoot));
                return true;
            }
            return false;
        });
        Object object = this.LOCK;
        synchronized (object) {
            this.myRecords.removeIf(record -> GitStagingAreaHolder.isUnder(record, dirtyScope));
            this.myRecords.addAll(rootRecords);
        }
        ((StagingAreaListener)BackgroundTaskUtil.syncPublisher((Project)this.myProject, TOPIC)).stagingAreaChanged(this.myRepository);
        return rootRecords;
    }

    private static boolean isUnder(@NotNull GitFileStatus record, @NotNull RecursiveFilePathSet dirtyScope) {
        return dirtyScope.hasAncestor(record.getPath()) || record.getOrigPath() != null && dirtyScope.hasAncestor(record.getOrigPath());
    }

    private static boolean isSubmoduleStatus(@NotNull GitFileStatus record, @Nullable VirtualFile candidateRoot) {
        if (candidateRoot == null) {
            return false;
        }
        String recordPath = record.getPath().getPath();
        String rootPath = candidateRoot.getPath();
        return recordPath.equals(rootPath);
    }

    @NotNull
    @ApiStatus.Internal
    public static Map<VirtualFile, List<FilePath>> collectDirtyPaths(@NotNull VcsDirtyScope dirtyScope) {
        Project project = dirtyScope.getProject();
        AbstractVcs vcs = dirtyScope.getVcs();
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        HashMap<VirtualFile, List<FilePath>> result2 = new HashMap<VirtualFile, List<FilePath>>();
        for (FilePath p : dirtyScope.getRecursivelyDirtyDirectories()) {
            GitStagingAreaHolder.addToPaths(p, result2, vcs, vcsManager);
        }
        for (FilePath p : dirtyScope.getDirtyFilesNoExpand()) {
            GitStagingAreaHolder.addToPaths(p, result2, vcs, vcsManager);
        }
        for (Change c : ChangeListManager.getInstance((Project)project).getAllChanges()) {
            switch (c.getType()) {
                case NEW: 
                case DELETED: 
                case MOVED: {
                    FilePath beforePath;
                    FilePath afterPath = ChangesUtil.getAfterPath((Change)c);
                    if (afterPath != null) {
                        GitStagingAreaHolder.addToPaths(afterPath, result2, vcs, vcsManager);
                    }
                    if ((beforePath = ChangesUtil.getBeforePath((Change)c)) == null) break;
                    GitStagingAreaHolder.addToPaths(beforePath, result2, vcs, vcsManager);
                }
            }
        }
        for (VirtualFile root : result2.keySet()) {
            List paths = (List)result2.get(root);
            GitStagingAreaHolder.removeCommonParents(paths);
        }
        return result2;
    }

    private static void addToPaths(@NotNull FilePath filePath, @NotNull Map<VirtualFile, List<FilePath>> result2, @NotNull AbstractVcs vcs, @NotNull ProjectLevelVcsManager vcsManager) {
        VcsRoot vcsRoot = vcsManager.getVcsRootObjectFor(filePath);
        if (vcsRoot != null && vcs.equals((Object)vcsRoot.getVcs())) {
            VirtualFile root = vcsRoot.getPath();
            List paths = result2.computeIfAbsent(root, key -> new ArrayList());
            paths.add(filePath);
        }
    }

    private static void removeCommonParents(List<FilePath> paths) {
        paths.sort(Comparator.comparing(FilePath::getPath));
        FilePath prevPath = null;
        Iterator<FilePath> it = paths.iterator();
        while (it.hasNext()) {
            FilePath path = it.next();
            if (prevPath != null && FileUtil.startsWith((String)path.getPath(), (String)prevPath.getPath(), (boolean)true)) {
                it.remove();
                continue;
            }
            prevPath = path;
        }
    }

    public static interface StagingAreaListener {
        public void stagingAreaChanged(@NotNull GitRepository var1);
    }
}

