/*
 * Decompiled with CFR 0.152.
 */
package git4idea.stash;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.CollectConsumer;
import com.intellij.util.Consumer;
import com.intellij.vcs.log.Hash;
import git4idea.GitCommit;
import git4idea.GitUtil;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLocalChangesWouldBeOverwrittenDetector;
import git4idea.commands.GitSimpleEventDetector;
import git4idea.commands.GitUntrackedFilesOverwrittenByOperationDetector;
import git4idea.config.GitConfigUtil;
import git4idea.history.GitCommitRequirements;
import git4idea.history.GitLogUtil;
import git4idea.merge.GitConflictResolver;
import git4idea.ui.StashInfo;
import git4idea.util.GitUntrackedFilesHelper;
import git4idea.util.LocalChangesWouldBeOverwrittenHelper;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000P\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a(\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a&\u0010\u000b\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\u0010H\u0007\u001a@\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0014\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\n0\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0018\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "loadChangesInStash", "", "Lcom/intellij/openapi/vcs/changes/Change;", "project", "Lcom/intellij/openapi/project/Project;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "hash", "Lcom/intellij/vcs/log/Hash;", "loadStashStack", "", "Lgit4idea/ui/StashInfo;", "", "consumer", "Lcom/intellij/util/Consumer;", "unstash", "rootAndRevisions", "", "handlerProvider", "Lkotlin/Function1;", "Lgit4idea/commands/GitLineHandler;", "conflictResolver", "Lgit4idea/merge/GitConflictResolver;", "intellij.vcs.git"})
@JvmName(name="GitStashUtils")
public final class GitStashUtils {
    private static final Logger LOG = LoggerKt.logger((String)"#git4idea.stash.GitStashUtils");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final void unstash(@NotNull Project project, @NotNull Map<VirtualFile, ? extends Hash> rootAndRevisions, @NotNull Function1<? super VirtualFile, ? extends GitLineHandler> handlerProvider, @NotNull GitConflictResolver conflictResolver) {
        AutoCloseable autoCloseable = (AutoCloseable)DvcsUtil.workingTreeChangeStarted((Project)project, (String)"Unstash");
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            AccessToken it = (AccessToken)autoCloseable;
            boolean bl3 = false;
            VirtualFile virtualFile = rootAndRevisions;
            boolean bl4 = false;
            Iterator<Map.Entry<VirtualFile, ? extends Hash>> iterator = virtualFile.entrySet().iterator();
            while (iterator.hasNext()) {
                Collection<Change> collection;
                void root;
                Map.Entry<VirtualFile, ? extends Hash> entry;
                Map.Entry<VirtualFile, ? extends Hash> entry2 = entry = iterator.next();
                boolean bl5 = false;
                virtualFile = entry2.getKey();
                entry2 = entry;
                bl5 = false;
                Hash hash = entry2.getValue();
                GitLineHandler handler = (GitLineHandler)handlerProvider.invoke((Object)root);
                GitSimpleEventDetector conflictDetector = new GitSimpleEventDetector(GitSimpleEventDetector.Event.MERGE_CONFLICT_ON_UNSTASH);
                GitUntrackedFilesOverwrittenByOperationDetector untrackedFilesDetector = new GitUntrackedFilesOverwrittenByOperationDetector((VirtualFile)root);
                GitLocalChangesWouldBeOverwrittenDetector localChangesDetector = new GitLocalChangesWouldBeOverwrittenDetector((VirtualFile)root, GitLocalChangesWouldBeOverwrittenDetector.Operation.MERGE);
                handler.addLineListener(conflictDetector);
                handler.addLineListener(untrackedFilesDetector);
                handler.addLineListener(localChangesDetector);
                GitCommandResult result2 = Git.getInstance().runCommand((Computable<? extends GitLineHandler>)((Computable)new Computable<GitLineHandler>(handler){
                    final /* synthetic */ GitLineHandler $handler;

                    public final GitLineHandler compute() {
                        return this.$handler;
                    }
                    {
                        this.$handler = gitLineHandler;
                    }
                }));
                if (hash != null) {
                    Hash hash2;
                    boolean bl6 = false;
                    boolean bl7 = false;
                    Hash $this$run = hash2;
                    boolean bl8 = false;
                    collection = GitStashUtils.loadChangesInStash(project, (VirtualFile)root, hash);
                } else {
                    collection = null;
                }
                Collection<Change> changesInStash = collection;
                GitUtil.refreshVfs((VirtualFile)root, changesInStash);
                if (conflictDetector.hasHappened()) {
                    boolean conflictsResolved = conflictResolver.merge();
                    if (conflictsResolved) continue;
                    return;
                }
                if (untrackedFilesDetector.wasMessageDetected()) {
                    GitUntrackedFilesHelper.notifyUntrackedFilesOverwrittenBy(project, (VirtualFile)root, (Collection<String>)untrackedFilesDetector.getRelativeFilePaths(), "unstash", null);
                    return;
                }
                if (localChangesDetector.wasMessageDetected()) {
                    LocalChangesWouldBeOverwrittenHelper.showErrorNotification(project, (VirtualFile)root, "unstash", (Collection<String>)localChangesDetector.getRelativeFilePaths());
                    return;
                }
                if (result2.success()) continue;
                VcsNotifier.getInstance((Project)project).notifyError("Unstash Failed", result2.getErrorOutputAsHtmlString(), true);
                return;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    private static final Collection<Change> loadChangesInStash(Project project, VirtualFile root, Hash hash) {
        try {
            CollectConsumer consumer2 = new CollectConsumer();
            GitLogUtil.readFullDetailsForHashes(project, root, CollectionsKt.listOf((Object)hash.asString()), new GitCommitRequirements(false, GitCommitRequirements.DiffRenameLimit.NO_RENAMES, GitCommitRequirements.DiffInMergeCommits.DIFF_TO_PARENTS), (Consumer<? super GitCommit>)((Consumer)consumer2));
            return ((GitCommit)((Object)CollectionsKt.first((Iterable)consumer2.getResult()))).getChanges();
        }
        catch (Exception e) {
            LOG.warn("Couldn't load changes in root [" + root + "] in stash resolved to [" + hash + ']', (Throwable)e);
            Collection<Change> collection = null;
            return collection;
        }
    }

    @Deprecated(message="use the simpler overloading method which returns a list")
    public static final void loadStashStack(@NotNull Project project, @NotNull VirtualFile root, @NotNull Consumer<StashInfo> consumer2) {
        for (StashInfo stash : GitStashUtils.loadStashStack(project, root)) {
            consumer2.consume((Object)stash);
        }
    }

    @NotNull
    public static final List<StashInfo> loadStashStack(@NotNull Project project, @NotNull VirtualFile root) throws VcsException {
        Charset charset = Charset.forName(GitConfigUtil.getLogEncoding(project, root));
        GitLineHandler h2 = new GitLineHandler(project, root, GitCommand.STASH.readLockingCommand());
        h2.setSilent(true);
        h2.addParameters("list");
        h2.setCharset(charset);
        GitCommandResult output = Git.getInstance().runCommand(h2);
        output.throwOnError(new int[0]);
        boolean bl = false;
        List result2 = new ArrayList();
        for (String line : output.getOutput()) {
            boolean bl2;
            List parts = StringsKt.split$default((CharSequence)line, (char[])new char[]{':'}, (boolean)false, (int)3, (int)2, null);
            if (parts.size() < 2) {
                boolean $i$f$logger = false;
                Logger.getInstance(GitUtil.class).error("Can't parse stash record: " + line);
                continue;
            }
            if (parts.size() == 2) {
                String string = (String)parts.get(1);
                bl2 = false;
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                result2.add(new StashInfo((String)parts.get(0), null, ((Object)StringsKt.trim((CharSequence)string2)).toString()));
                continue;
            }
            String string = (String)parts.get(1);
            bl2 = false;
            String string3 = string;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            string = (String)parts.get(2);
            bl2 = false;
            String string4 = string;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            result2.add(new StashInfo((String)parts.get(0), ((Object)StringsKt.trim((CharSequence)string3)).toString(), ((Object)StringsKt.trim((CharSequence)string4)).toString()));
        }
        return result2;
    }
}

