/*
 * Decompiled with CFR 0.152.
 */
package git4idea.reset;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.ui.ChangeListChooser;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.DataPackBase;
import com.intellij.vcs.log.data.LoadingDetails;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.VisiblePack;
import git4idea.GitUtil;
import git4idea.i18n.GitBundle;
import git4idea.rebase.GitSingleCommitEditingAction;
import git4idea.repo.GitRepository;
import git4idea.reset.GitResetMode;
import git4idea.reset.GitResetOperation;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitUncommitAction
extends GitSingleCommitEditingAction {
    private static final Logger LOG = Logger.getInstance(GitUncommitAction.class);

    @Override
    protected void update(@NotNull AnActionEvent e, @NotNull GitSingleCommitEditingAction.SingleCommitEditingData commitEditingData) {
        if (e.getPresentation().isEnabledAndVisible()) {
            VcsLogUi logUi2 = commitEditingData.getLogUi();
            DataPackBase dataPackBase = ((VisiblePack)logUi2.getDataPack()).getDataPack();
            if (!(dataPackBase instanceof DataPack)) {
                e.getPresentation().setVisible(true);
                e.getPresentation().setEnabled(false);
                return;
            }
            if (commitEditingData.isHeadCommit()) {
                e.getPresentation().setEnabled(true);
            } else {
                e.getPresentation().setEnabled(false);
                e.getPresentation().setDescription(GitBundle.message("git.undo.action.description", new Object[0]));
            }
        }
    }

    @Override
    public void actionPerformedAfterChecks(@NotNull GitSingleCommitEditingAction.SingleCommitEditingData commitEditingData) {
        Project project = commitEditingData.getProject();
        VcsShortCommitDetails commit2 = commitEditingData.getSelectedCommit();
        ChangeListChooser chooser = new ChangeListChooser(project, (Collection)ChangeListManager.getInstance((Project)project).getChangeListsCopy(), null, GitBundle.message("git.undo.action.select.target.changelist.title", new Object[0]), commit2.getSubject());
        chooser.show();
        LocalChangeList selectedList = chooser.getSelectedList();
        if (selectedList != null) {
            GitUncommitAction.resetInBackground(commitEditingData.getLogData(), commitEditingData.getRepository(), commit2, selectedList);
        }
    }

    @Override
    @NotNull
    protected String getFailureTitle() {
        return GitBundle.message("git.undo.action.cant.undo.commit.failure", new Object[0]);
    }

    private static void resetInBackground(final @NotNull VcsLogData data, final @NotNull GitRepository repository, final @NotNull VcsShortCommitDetails commit2, final @NotNull LocalChangeList changeList) {
        final Project project = repository.getProject();
        new Task.Backgroundable(project, GitBundle.message("git.undo.action.undoing.last.commit.process", new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                Collection changesInCommit;
                try {
                    changesInCommit = GitUncommitAction.getChangesInCommit(data, commit2);
                }
                catch (VcsException e) {
                    String message = GitBundle.message("git.undo.action.could.not.load.changes.of.commit", ((Hash)commit2.getId()).asString());
                    LOG.warn(message, (Throwable)e);
                    Notification notification = VcsNotifier.STANDARD_NOTIFICATION.createNotification("", message, NotificationType.ERROR, null);
                    VcsNotifier.getInstance((Project)project).notify(notification);
                    return;
                }
                new GitResetOperation(project, Collections.singletonMap(repository, commit2.getParents().get(0)), GitResetMode.SOFT, indicator).execute();
                ChangeListManagerImpl changeListManager = ChangeListManagerImpl.getInstanceImpl((Project)project);
                changeListManager.invokeAfterUpdate(() -> {
                    Collection<Change> changes = GitUtil.findCorrespondentLocalChanges((ChangeListManager)changeListManager, changesInCommit);
                    changeListManager.moveChangesTo(changeList, changes.toArray(new Change[0]));
                }, InvokeAfterUpdateMode.SYNCHRONOUS_CANCELLABLE, GitBundle.message("git.undo.action.refreshing.changes.process", new Object[0]), ModalityState.defaultModalityState());
            }
        }.queue();
    }

    @NotNull
    private static Collection<Change> getChangesInCommit(@NotNull VcsLogData data, @NotNull VcsShortCommitDetails commit2) throws VcsException {
        VirtualFile root;
        Hash hash = (Hash)commit2.getId();
        VcsFullCommitDetails details = GitUncommitAction.getChangesFromCache(data, hash, root = commit2.getRoot());
        if (details == null) {
            details = VcsLogUtil.getDetails((VcsLogData)data, (VirtualFile)root, (Hash)hash);
        }
        return details.getChanges();
    }

    @Nullable
    private static VcsFullCommitDetails getChangesFromCache(@NotNull VcsLogData data, @NotNull Hash hash, @NotNull VirtualFile root) {
        Ref details = Ref.create();
        ApplicationManager.getApplication().invokeAndWait(() -> details.set((Object)data.getCommitDetailsGetter().getCommitDataIfAvailable(data.getCommitIndex(hash, root))));
        if (details.isNull() || details.get() instanceof LoadingDetails) {
            return null;
        }
        return (VcsFullCommitDetails)details.get();
    }
}

