/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.dvcs.ignore.VcsRepositoryIgnoredFilesHolderBase;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsFileUtilKt;
import com.intellij.vcsUtil.VcsUtil;
import com.intellij.vfs.AsyncVfsEventsListener;
import com.intellij.vfs.AsyncVfsEventsPostProcessor;
import git4idea.GitLocalBranch;
import git4idea.commands.Git;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryFiles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitUntrackedFilesHolder
implements Disposable,
AsyncVfsEventsListener {
    private static final Logger LOG = Logger.getInstance(GitUntrackedFilesHolder.class);
    private final Project myProject;
    private final VirtualFile myRoot;
    private final FilePath myRootPath;
    private final GitRepository myRepository;
    private final ChangeListManager myChangeListManager;
    private final VcsDirtyScopeManager myDirtyScopeManager;
    private final ProjectLevelVcsManager myVcsManager;
    private final GitRepositoryFiles myRepositoryFiles;
    private final Git myGit;
    private final Set<FilePath> myDefinitelyUntrackedFiles = new HashSet<FilePath>();
    private final Set<FilePath> myPossiblyUntrackedFiles = new HashSet<FilePath>();
    private boolean myReady;
    private final Object LOCK = new Object();
    private final Object RESCAN_LOCK = new Object();

    GitUntrackedFilesHolder(@NotNull GitRepository repository, @NotNull GitRepositoryFiles gitFiles) {
        this.myProject = repository.getProject();
        this.myRepository = repository;
        this.myRoot = repository.getRoot();
        this.myRootPath = VcsUtil.getFilePath((VirtualFile)this.myRoot);
        this.myChangeListManager = ChangeListManager.getInstance((Project)this.myProject);
        this.myDirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)this.myProject);
        this.myGit = Git.getInstance();
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        this.myRepositoryFiles = gitFiles;
    }

    void setupVfsListener(@NotNull Project project) {
        ApplicationManager.getApplication().runReadAction(() -> {
            if (!project.isDisposed()) {
                AsyncVfsEventsPostProcessor.getInstance().addListener((AsyncVfsEventsListener)this, (Disposable)this);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.LOCK;
        synchronized (object) {
            this.myDefinitelyUntrackedFiles.clear();
            this.myPossiblyUntrackedFiles.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(@NotNull FilePath file) {
        Object object = this.LOCK;
        synchronized (object) {
            this.myDefinitelyUntrackedFiles.add(file);
            this.myPossiblyUntrackedFiles.add(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(@NotNull Collection<? extends FilePath> files) {
        Object object = this.LOCK;
        synchronized (object) {
            this.myDefinitelyUntrackedFiles.addAll(files);
            this.myPossiblyUntrackedFiles.addAll(files);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(@NotNull Collection<? extends FilePath> files) {
        Object object = this.LOCK;
        synchronized (object) {
            this.myDefinitelyUntrackedFiles.removeAll(files);
            this.myPossiblyUntrackedFiles.addAll(files);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markPossiblyUntracked(@NotNull Collection<? extends FilePath> files) {
        Object object = this.LOCK;
        synchronized (object) {
            this.myPossiblyUntrackedFiles.addAll(files);
        }
    }

    @Deprecated
    @NotNull
    public Collection<VirtualFile> retrieveUntrackedFiles() throws VcsException {
        return ContainerUtil.mapNotNull(this.retrieveUntrackedFilePaths(), FilePath::getVirtualFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate() {
        Object object = this.LOCK;
        synchronized (object) {
            this.myReady = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Collection<FilePath> getUntrackedFilePaths() {
        Object object = this.LOCK;
        synchronized (object) {
            return new ArrayList<FilePath>(this.myDefinitelyUntrackedFiles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsFile(@NotNull FilePath filePath) {
        Object object = this.LOCK;
        synchronized (object) {
            return this.myDefinitelyUntrackedFiles.contains(filePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Collection<FilePath> retrieveUntrackedFilePaths() throws VcsException {
        Object object = this.RESCAN_LOCK;
        synchronized (object) {
            this.rescan();
        }
        return this.getUntrackedFilePaths();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rescan() throws VcsException {
        HashSet<FilePath> suspiciousFiles;
        Object object = this.LOCK;
        synchronized (object) {
            suspiciousFiles = this.myReady ? new HashSet<FilePath>(this.myPossiblyUntrackedFiles) : null;
            this.myPossiblyUntrackedFiles.clear();
        }
        Set<FilePath> untrackedFiles = this.myGit.untrackedFilePaths(this.myProject, this.myRoot, suspiciousFiles);
        untrackedFiles.removeIf(it -> {
            VirtualFile root = this.myVcsManager.getVcsRootFor(it);
            if (!this.myRoot.equals(root)) {
                LOG.warn(String.format("Ignoring untracked file under another root: %s; root: %s; mapped root: %s", it, this.myRoot, root));
                return true;
            }
            return false;
        });
        Object object2 = this.LOCK;
        synchronized (object2) {
            if (suspiciousFiles != null) {
                this.myDefinitelyUntrackedFiles.removeIf(definitelyUntrackedFile -> VcsFileUtilKt.isUnder((FilePath)this.myRootPath, (Set)suspiciousFiles, (FilePath)definitelyUntrackedFile));
                this.myDefinitelyUntrackedFiles.addAll(untrackedFiles);
            } else {
                this.myDefinitelyUntrackedFiles.clear();
                this.myDefinitelyUntrackedFiles.addAll(untrackedFiles);
                this.myReady = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filesChanged(@NotNull List<? extends VFileEvent> events) {
        Object object;
        boolean allChanged = false;
        HashSet<FilePath> filesToRefresh = new HashSet<FilePath>();
        for (VFileEvent vFileEvent : events) {
            if (allChanged) break;
            String path = vFileEvent.getPath();
            if (GitUntrackedFilesHolder.totalRefreshNeeded(this.myRepository, path)) {
                allChanged = true;
                continue;
            }
            Set affectedPaths = VcsRepositoryIgnoredFilesHolderBase.getAffectedFilePaths((VFileEvent)vFileEvent);
            for (FilePath affectedFilePath : affectedPaths) {
                if (!this.notIgnored(affectedFilePath)) continue;
                filesToRefresh.add(affectedFilePath);
            }
        }
        if (allChanged) {
            this.rescanIgnoredFiles(() -> {
                LOG.debug(String.format("GitUntrackedFilesHolder: total refresh is needed, marking %s recursively dirty", this.myRoot));
                this.myDirtyScopeManager.dirDirtyRecursively(this.myRoot);
            });
            object = this.LOCK;
            synchronized (object) {
                this.myReady = false;
            }
        }
        object = this.LOCK;
        synchronized (object) {
            this.myPossiblyUntrackedFiles.addAll(filesToRefresh);
        }
    }

    public static boolean totalRefreshNeeded(@NotNull GitRepository repository, @NotNull String path) {
        return GitUntrackedFilesHolder.indexChanged(repository, path) || GitUntrackedFilesHolder.externallyCommitted(repository, path) || GitUntrackedFilesHolder.headMoved(repository, path) || GitUntrackedFilesHolder.headChanged(repository, path) || GitUntrackedFilesHolder.currentBranchChanged(repository, path) || GitUntrackedFilesHolder.gitignoreChanged(repository, path);
    }

    private static boolean headChanged(@NotNull GitRepository repository, @NotNull String path) {
        return repository.getRepositoryFiles().isHeadFile(path);
    }

    private static boolean currentBranchChanged(@NotNull GitRepository repository, @NotNull String path) {
        GitLocalBranch currentBranch = repository.getCurrentBranch();
        return currentBranch != null && repository.getRepositoryFiles().isBranchFile(path, currentBranch.getFullName());
    }

    private static boolean headMoved(@NotNull GitRepository repository, @NotNull String path) {
        return repository.getRepositoryFiles().isOrigHeadFile(path);
    }

    public static boolean indexChanged(@NotNull GitRepository repository, @NotNull String path) {
        return repository.getRepositoryFiles().isIndexFile(path);
    }

    private static boolean externallyCommitted(@NotNull GitRepository repository, @NotNull String path) {
        return repository.getRepositoryFiles().isCommitMessageFile(path);
    }

    private static boolean gitignoreChanged(@NotNull GitRepository repository, @NotNull String path) {
        return path.endsWith(".gitignore") || repository.getRepositoryFiles().isExclude(path);
    }

    private void rescanIgnoredFiles(@NotNull Runnable doAfterRescan) {
        this.myRepository.getIgnoredFilesHolder().startRescan(doAfterRescan);
    }

    private boolean notIgnored(@Nullable FilePath file) {
        return file != null && this.belongsToThisRepository(file) && !this.myChangeListManager.isIgnoredFile(file);
    }

    private boolean belongsToThisRepository(FilePath file) {
        return this.myRoot.equals(this.myVcsManager.getVcsRootFor(file));
    }
}

