/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import git4idea.checkin.GitCheckinEnvironment;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.config.GitConfigUtil;
import git4idea.config.GitVersionSpecialty;
import git4idea.rebase.GitAutomaticRebaseEditor;
import git4idea.rebase.GitRebaseEntry;
import git4idea.rebase.log.GitCommitEditingOperation;
import git4idea.rebase.log.GitCommitEditingOperationResult;
import git4idea.repo.GitRepository;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u0006\u0010\u0010\u001a\u00020\u0011J\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J\b\u0010\u0016\u001a\u00020\u000fH\u0002J\b\u0010\u0017\u001a\u00020\u0011H\u0002J\b\u0010\u0018\u001a\u00020\u0011H\u0002J\u0010\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u0007H\u0002R\u0013\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\f\u001a\u00070\u0007\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lgit4idea/rebase/GitRewordOperation;", "Lgit4idea/rebase/log/GitCommitEditingOperation;", "repository", "Lgit4idea/repo/GitRepository;", "commit", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "newMessage", "", "(Lgit4idea/repo/GitRepository;Lcom/intellij/vcs/log/VcsCommitMetadata;Ljava/lang/String;)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "initialHeadPosition", "Lorg/jetbrains/annotations/Nullable;", "canRewordViaAmend", "", "execute", "Lgit4idea/rebase/log/GitCommitEditingOperationResult;", "injectRewordAction", "", "Lgit4idea/rebase/GitRebaseEntry;", "list", "isLatestCommit", "rewordViaAmend", "rewordViaRebase", "supplyNewMessage", "editorText", "intellij.vcs.git"})
public final class GitRewordOperation
extends GitCommitEditingOperation {
    private final Logger LOG;
    private final String initialHeadPosition;
    private final VcsCommitMetadata commit;
    private final String newMessage;

    @NotNull
    public final GitCommitEditingOperationResult execute() {
        GitCommitEditingOperationResult operationResult;
        if (this.canRewordViaAmend() && (operationResult = this.rewordViaAmend()) instanceof GitCommitEditingOperationResult.Complete) {
            return operationResult;
        }
        return this.rewordViaRebase();
    }

    private final boolean canRewordViaAmend() {
        return this.isLatestCommit() && GitVersionSpecialty.CAN_AMEND_WITHOUT_FILES.existsIn(this.getProject());
    }

    private final boolean isLatestCommit() {
        return Intrinsics.areEqual((Object)((Hash)this.commit.getId()).asString(), (Object)this.initialHeadPosition);
    }

    private final GitCommitEditingOperationResult rewordViaRebase() {
        GitAutomaticRebaseEditor rebaseEditor2 = new GitAutomaticRebaseEditor(this.getProject(), this.commit.getRoot(), (Function1<? super List<? extends GitRebaseEntry>, ? extends List<? extends GitRebaseEntry>>)((Function1)new Function1<List<? extends GitRebaseEntry>, List<? extends GitRebaseEntry>>(this){
            final /* synthetic */ GitRewordOperation this$0;

            @NotNull
            public final List<GitRebaseEntry> invoke(@NotNull List<? extends GitRebaseEntry> list) {
                return GitRewordOperation.access$injectRewordAction(this.this$0, list);
            }
            {
                this.this$0 = gitRewordOperation;
                super(1);
            }
        }), (Function1<? super String, String>)((Function1)new Function1<String, String>(this){
            final /* synthetic */ GitRewordOperation this$0;

            @NotNull
            public final String invoke(@NotNull String editorText) {
                return GitRewordOperation.access$supplyNewMessage(this.this$0, editorText);
            }
            {
                this.this$0 = gitRewordOperation;
                super(1);
            }
        }));
        return GitCommitEditingOperation.rebase$default(this, CollectionsKt.listOf((Object)this.commit), rebaseEditor2, false, 4, null);
    }

    private final GitCommitEditingOperationResult rewordViaAmend() {
        GitLineHandler handler = new GitLineHandler(this.getProject(), this.getRepository().getRoot(), GitCommand.COMMIT);
        File messageFile = null;
        try {
            messageFile = GitCheckinEnvironment.createCommitMessageFile(this.getProject(), this.getRepository().getRoot(), this.newMessage);
        }
        catch (IOException e) {
            this.LOG.warn("Couldn't create message file", (Throwable)e);
            return GitCommitEditingOperationResult.Incomplete.INSTANCE;
        }
        handler.addParameters("--amend");
        handler.addParameters("-F");
        handler.addAbsoluteFile(messageFile);
        handler.addParameters("--only");
        handler.addParameters("--no-verify");
        GitCommandResult result2 = Git.getInstance().runCommand(handler);
        this.getRepository().update();
        if (result2.success()) {
            GitRepository gitRepository = this.getRepository();
            String string = ((Hash)CollectionsKt.first((List)this.commit.getParents())).asString();
            String string2 = this.getRepository().getCurrentRevision();
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            return new GitCommitEditingOperationResult.Complete(gitRepository, string, this.initialHeadPosition, string2);
        }
        this.LOG.warn("Couldn't reword via amend: " + result2.getErrorOutputAsJoinedString());
        return GitCommitEditingOperationResult.Incomplete.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private final List<GitRebaseEntry> injectRewordAction(List<? extends GitRebaseEntry> list) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void entry;
            GitRebaseEntry gitRebaseEntry = (GitRebaseEntry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void var12_12 = Intrinsics.areEqual((Object)entry.getAction(), (Object)GitRebaseEntry.Action.PICK.INSTANCE) && StringsKt.startsWith$default((String)((Hash)this.commit.getId()).asString(), (String)entry.getCommit(), (boolean)false, (int)2, null) ? new GitRebaseEntry(GitRebaseEntry.Action.REWORD.INSTANCE, entry.getCommit(), entry.getSubject()) : entry;
            collection.add(var12_12);
        }
        return (List)destination$iv$iv;
    }

    private final String supplyNewMessage(String editorText) {
        if (StringsKt.startsWith$default((String)editorText, (String)this.commit.getFullMessage(), (boolean)false, (int)2, null)) {
            return this.newMessage;
        }
        this.LOG.error("Unexpected editor content. Charset: " + GitConfigUtil.getCommitEncoding(this.getProject(), this.commit.getRoot()), new Attachment[]{new Attachment("actual.txt", editorText), new Attachment("expected.txt", this.commit.getFullMessage())});
        throw (Throwable)new IllegalStateException("Unexpected editor content");
    }

    public GitRewordOperation(@NotNull GitRepository repository, @NotNull VcsCommitMetadata commit2, @NotNull String newMessage) {
        super(repository);
        this.commit = commit2;
        this.newMessage = newMessage;
        repository.update();
        boolean $i$f$logger = false;
        this.LOG = Logger.getInstance(GitRewordOperation.class);
        String string = repository.getCurrentRevision();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        this.initialHeadPosition = string;
    }

    public static final /* synthetic */ List access$injectRewordAction(GitRewordOperation $this, List list) {
        return $this.injectRewordAction(list);
    }

    public static final /* synthetic */ String access$supplyNewMessage(GitRewordOperation $this, String editorText) {
        return $this.supplyNewMessage(editorText);
    }
}

