/*
 * Decompiled with CFR 0.152.
 */
package git4idea.push;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import git4idea.branch.GitBranchUtil;
import git4idea.repo.GitRepository;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GitPushSpecParser {
    private static final Logger LOG = Logger.getInstance(GitPushSpecParser.class);

    GitPushSpecParser() {
    }

    @Nullable
    static String getTargetRef(@NotNull GitRepository repository, @NotNull String sourceBranchName, @NotNull List<String> specs) {
        for (String spec : specs) {
            String target = GitPushSpecParser.getTarget(spec, sourceBranchName);
            if (target == null) {
                LOG.info("Push spec [" + spec + "] in " + repository.getRoot() + " is invalid or doesn't match source branch " + sourceBranchName);
                continue;
            }
            return target;
        }
        return null;
    }

    @Nullable
    private static String getTarget(@NotNull String spec, @NotNull String sourceBranch) {
        String sourceWoStar;
        String[] parts = spec.split(":");
        if (parts.length != 2) {
            return null;
        }
        String source = parts[0].trim();
        String target = parts[1].trim();
        if (!GitPushSpecParser.isStarPositionValid(source = StringUtil.trimStart((String)source, (String)"+"), target)) {
            return null;
        }
        source = GitBranchUtil.stripRefsPrefix(source);
        sourceBranch = GitBranchUtil.stripRefsPrefix(sourceBranch);
        if (source.equals("HEAD") || source.equals(sourceBranch)) {
            return target;
        }
        if (source.endsWith("*") && sourceBranch.startsWith(sourceWoStar = source.substring(0, source.length() - 1))) {
            String starMeaning = sourceBranch.substring(sourceWoStar.length());
            return target.replace("*", starMeaning);
        }
        return null;
    }

    private static boolean isStarPositionValid(@NotNull String source, @NotNull String target) {
        int sourceStar = source.indexOf(42);
        int targetStar = target.indexOf(42);
        return sourceStar < 0 && targetStar < 0 || sourceStar == source.length() - 1 && targetStar == target.length() - 1;
    }
}

