/*
 * Decompiled with CFR 0.152.
 */
package git4idea.merge;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.commands.Git;
import git4idea.merge.GitConflictResolver;
import git4idea.merge.GitMerger;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class GitMergeCommittingConflictResolver
extends GitConflictResolver {
    private final Collection<? extends VirtualFile> myMergingRoots;
    private final boolean myRefreshAfterCommit;
    private final GitMerger myMerger;

    public GitMergeCommittingConflictResolver(@NotNull Project project, @NotNull Git git, @NotNull GitMerger merger, @NotNull Collection<? extends VirtualFile> mergingRoots, @NotNull GitConflictResolver.Params params, boolean refreshAfterCommit) {
        super(project, mergingRoots, params);
        this.myMerger = merger;
        this.myMergingRoots = mergingRoots;
        this.myRefreshAfterCommit = refreshAfterCommit;
    }

    @Override
    protected boolean proceedAfterAllMerged() throws VcsException {
        this.myMerger.mergeCommit(this.myMergingRoots);
        if (this.myRefreshAfterCommit) {
            for (VirtualFile virtualFile : this.myMergingRoots) {
                virtualFile.refresh(true, true);
            }
        }
        return true;
    }
}

