/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import git4idea.GitVcs;
import git4idea.commands.Git;
import git4idea.commands.GitLineHandler;
import git4idea.history.GitLogParser;
import git4idea.history.GitLogRecord;
import git4idea.history.GitLogUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class GitLogRecordCollector<R extends GitLogRecord>
implements Consumer<R> {
    private static final Logger LOG = Logger.getInstance(GitLogRecordCollector.class);
    @NotNull
    protected final Project myProject;
    @NotNull
    protected final VirtualFile myRoot;
    @NotNull
    protected final Consumer<? super List<R>> myConsumer;
    @NotNull
    private final MultiMap<String, R> myHashToRecord = MultiMap.createLinked();
    @Nullable
    private String myLastHash = null;

    protected GitLogRecordCollector(@NotNull Project project, @NotNull VirtualFile root, @NotNull Consumer<? super List<R>> consumer2) {
        this.myProject = project;
        this.myRoot = root;
        this.myConsumer = consumer2;
    }

    public void consume(@NotNull R record) {
        if (!((GitLogRecord)record).getHash().equals(this.myLastHash)) {
            this.processCollectedRecords();
        }
        this.myLastHash = ((GitLogRecord)record).getHash();
        this.myHashToRecord.putValue((Object)((GitLogRecord)record).getHash(), record);
        String[] parents = ((GitLogRecord)record).getParentsHashes();
        if (parents.length == 0 || parents.length == this.myHashToRecord.get((Object)((GitLogRecord)record).getHash()).size()) {
            this.processCollectedRecords();
        }
    }

    public void finish() {
        this.processCollectedRecords();
    }

    protected void processCollectedRecords() {
        for (String hash : this.myHashToRecord.keySet()) {
            ArrayList records = new ArrayList(Objects.requireNonNull(this.myHashToRecord.get((Object)hash)));
            GitLogRecord firstRecord = (GitLogRecord)records.get(0);
            if (firstRecord.getParentsHashes().length != 0 && records.size() != firstRecord.getParentsHashes().length) {
                this.processIncompleteRecord(hash, records);
                continue;
            }
            this.myConsumer.consume(records);
        }
        this.myHashToRecord.clear();
    }

    protected void processIncompleteRecord(@NotNull String hash, @NotNull List<R> records) {
        MultiMap incompleteRecords = MultiMap.create();
        incompleteRecords.put((Object)hash, records);
        try {
            this.processIncompleteRecords(incompleteRecords, this.myProject, this.myRoot, this.myConsumer);
        }
        catch (VcsException e) {
            LOG.error((Throwable)e);
        }
    }

    public void processIncompleteRecords(@NotNull MultiMap<String, R> incompleteRecords, @NotNull Project project, @NotNull VirtualFile root, @NotNull Consumer<? super List<R>> consumer2) throws VcsException {
        List firstRecords = ContainerUtil.map((Collection)incompleteRecords.entrySet(), e -> (GitLogRecord)ContainerUtil.getFirstItem((Collection)((Collection)e.getValue())));
        Map<String, String> hashToTreeMap = GitLogRecordCollector.getHashToTreeMap(project, root, firstRecords);
        for (String hash : incompleteRecords.keySet()) {
            ArrayList records = new ArrayList(Objects.requireNonNull(incompleteRecords.get((Object)hash)));
            this.fillWithEmptyRecords(records, hashToTreeMap);
            consumer2.consume(records);
        }
    }

    @NotNull
    private static <R extends GitLogRecord> Map<String, String> getHashToTreeMap(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<? extends R> records) throws VcsException {
        HashSet<String> hashes2 = new HashSet<String>();
        for (GitLogRecord r : records) {
            hashes2.add(r.getHash());
            ContainerUtil.addAll(hashes2, (Object[])r.getParentsHashes());
        }
        GitLineHandler handler = GitLogUtil.createGitHandler(project, root);
        GitLogParser<GitLogRecord> parser = GitLogParser.createDefaultParser(project, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.TREE);
        GitVcs vcs = GitVcs.getInstance(project);
        handler.setStdoutSuppressed(true);
        handler.addParameters(parser.getPretty());
        handler.addParameters(GitLogUtil.getNoWalkParameter(vcs));
        handler.addParameters("--stdin");
        handler.endOptions();
        GitLogUtil.sendHashesToStdin(vcs, hashes2, handler);
        String output = Git.getInstance().runCommand(handler).getOutputOrThrow(new int[0]);
        List<GitLogRecord> hashAndTreeRecords = parser.parse(output);
        return ContainerUtil.map2Map(hashAndTreeRecords, record -> Pair.create((Object)record.getHash(), (Object)record.getTreeHash()));
    }

    private void fillWithEmptyRecords(@NotNull List<R> records, @NotNull Map<String, String> hashToTreeMap) {
        GitLogRecord firstRecord = (GitLogRecord)records.get(0);
        String commit2 = firstRecord.getHash();
        String[] parents = firstRecord.getParentsHashes();
        String commitTreeHash = hashToTreeMap.get(commit2);
        LOG.assertTrue(commitTreeHash != null, (Object)("Could not get tree hash for commit " + commit2));
        for (int parentIndex = 0; parentIndex < parents.length; ++parentIndex) {
            String parent = parents[parentIndex];
            String parentTreeHash = hashToTreeMap.get(parent);
            LOG.assertTrue(parentTreeHash != null, (Object)("Could not get tree hash for commit " + parent));
            if (!parentTreeHash.equals(commitTreeHash) || records.size() >= parents.length) continue;
            records.add(parentIndex, this.createEmptyCopy(firstRecord));
        }
    }

    protected abstract R createEmptyCopy(@NotNull R var1);
}

