/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.vcs.log.impl.VcsFileStatusInfo;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitFileRevision;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.config.GitVersionSpecialty;
import git4idea.history.GitLogFullRecord;
import git4idea.history.GitLogOutputSplitter;
import git4idea.history.GitLogParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitFileHistory {
    private static final Logger LOG = Logger.getInstance(GitFileHistory.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final VirtualFile myRoot;
    @NotNull
    private final FilePath myPath;
    @NotNull
    private final VcsRevisionNumber myStartingRevision;

    private GitFileHistory(@NotNull Project project, @NotNull VirtualFile root, @NotNull FilePath path, @NotNull VcsRevisionNumber revision) {
        this.myProject = project;
        this.myRoot = root;
        this.myPath = VcsUtil.getLastCommitPath((Project)this.myProject, (FilePath)path);
        this.myStartingRevision = revision;
    }

    private void load(@NotNull Consumer<? super GitFileRevision> consumer2, @NotNull Consumer<? super VcsException> exceptionConsumer, String ... parameters) {
        GitLogParser<GitLogFullRecord> logParser = GitLogParser.createDefaultParser(this.myProject, GitLogParser.NameStatus.STATUS, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.COMMIT_TIME, GitLogParser.GitLogOption.AUTHOR_NAME, GitLogParser.GitLogOption.AUTHOR_EMAIL, GitLogParser.GitLogOption.COMMITTER_NAME, GitLogParser.GitLogOption.COMMITTER_EMAIL, GitLogParser.GitLogOption.PARENTS, GitLogParser.GitLogOption.SUBJECT, GitLogParser.GitLogOption.BODY, GitLogParser.GitLogOption.RAW_BODY, GitLogParser.GitLogOption.AUTHOR_TIME);
        GitLogRecordConsumer recordConsumer = new GitLogRecordConsumer(consumer2);
        String firstCommitParent = this.myStartingRevision.asString();
        FilePath currentPath = this.myPath;
        while (currentPath != null && firstCommitParent != null) {
            recordConsumer.reset(currentPath);
            GitLineHandler handler = this.createLogHandler(logParser, currentPath, firstCommitParent, parameters);
            GitLogOutputSplitter<GitLogFullRecord> splitter = new GitLogOutputSplitter<GitLogFullRecord>(handler, logParser, recordConsumer);
            Git.getInstance().runCommandWithoutCollectingOutput(handler);
            if (splitter.hasErrors()) {
                return;
            }
            try {
                String firstCommit = recordConsumer.getFirstCommit();
                if (firstCommit == null) {
                    return;
                }
                Pair<String, FilePath> firstCommitParentAndPath = this.getFirstCommitParentAndPathIfRename(firstCommit, currentPath);
                if (firstCommitParentAndPath == null) {
                    return;
                }
                currentPath = (FilePath)firstCommitParentAndPath.second;
                firstCommitParent = (String)firstCommitParentAndPath.first;
            }
            catch (VcsException e) {
                LOG.warn("Tried to get first commit rename path", (Throwable)e);
                exceptionConsumer.consume((Object)e);
                return;
            }
        }
    }

    @Nullable
    private Pair<String, FilePath> getFirstCommitParentAndPathIfRename(@NotNull String commit2, @NotNull FilePath filePath) throws VcsException {
        GitLineHandler h2 = new GitLineHandler(this.myProject, this.myRoot, GitCommand.SHOW);
        GitLogParser<GitLogFullRecord> parser = GitLogParser.createDefaultParser(this.myProject, GitLogParser.NameStatus.STATUS, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.COMMIT_TIME, GitLogParser.GitLogOption.PARENTS);
        h2.setStdoutSuppressed(true);
        h2.addParameters("-M", "-m", "--follow", "--name-status", parser.getPretty(), "--encoding=UTF-8", commit2);
        h2.endOptions();
        h2.addRelativePaths(filePath);
        String output = Git.getInstance().runCommand(h2).getOutputOrThrow(new int[0]);
        List<GitLogFullRecord> records = parser.parse(output);
        if (records.isEmpty()) {
            return null;
        }
        for (int i2 = 0; i2 < records.size(); ++i2) {
            GitLogFullRecord record = records.get(i2);
            List<Change> changes = record.parseChanges(this.myProject, this.myRoot);
            for (Change change : changes) {
                if (!change.isMoved() && !change.isRenamed() || !filePath.equals(Objects.requireNonNull(change.getAfterRevision()).getFile())) continue;
                String[] parents = record.getParentsHashes();
                String parent = parents.length > 0 ? parents[i2] : null;
                return Pair.create((Object)parent, (Object)Objects.requireNonNull(change.getBeforeRevision()).getFile());
            }
        }
        return null;
    }

    @NotNull
    private GitLineHandler createLogHandler(@NotNull GitLogParser parser, @NotNull FilePath path, @NotNull String lastCommit, String ... parameters) {
        GitLineHandler h2 = new GitLineHandler(this.myProject, this.myRoot, GitCommand.LOG);
        h2.setStdoutSuppressed(true);
        h2.addParameters("--name-status", parser.getPretty(), "--encoding=UTF-8", lastCommit);
        if (GitVersionSpecialty.FULL_HISTORY_SIMPLIFY_MERGES_WORKS_CORRECTLY.existsIn(this.myProject) && Registry.is((String)"git.file.history.full")) {
            h2.addParameters("--full-history", "--simplify-merges");
        }
        if (parameters != null && parameters.length > 0) {
            h2.addParameters(parameters);
        }
        h2.endOptions();
        h2.addRelativePaths(path);
        return h2;
    }

    public static void loadHistory(@NotNull Project project, @NotNull FilePath path, @Nullable VcsRevisionNumber startingFrom, @NotNull Consumer<? super GitFileRevision> consumer2, @NotNull Consumer<? super VcsException> exceptionConsumer, String ... parameters) {
        try {
            VirtualFile repositoryRoot = GitUtil.getRootForFile(project, path);
            GitRevisionNumber revision = startingFrom == null ? GitRevisionNumber.HEAD : startingFrom;
            new GitFileHistory(project, repositoryRoot, path, (VcsRevisionNumber)revision).load(consumer2, exceptionConsumer, parameters);
        }
        catch (VcsException e) {
            exceptionConsumer.consume((Object)e);
        }
    }

    @NotNull
    public static List<VcsFileRevision> collectHistoryForRevision(@NotNull Project project, @NotNull FilePath path, @NotNull VcsRevisionNumber startingFrom, String ... parameters) throws VcsException {
        ArrayList<VcsFileRevision> revisions = new ArrayList<VcsFileRevision>();
        ArrayList exceptions = new ArrayList();
        GitFileHistory.loadHistory(project, path, startingFrom, (Consumer<? super GitFileRevision>)((Consumer)revisions::add), (Consumer<? super VcsException>)((Consumer)exceptions::add), parameters);
        if (!exceptions.isEmpty()) {
            throw (VcsException)((Object)exceptions.get(0));
        }
        return revisions;
    }

    @NotNull
    public static List<VcsFileRevision> collectHistory(@NotNull Project project, @NotNull FilePath path, String ... parameters) throws VcsException {
        return GitFileHistory.collectHistoryForRevision(project, path, (VcsRevisionNumber)GitRevisionNumber.HEAD, parameters);
    }

    private class GitLogRecordConsumer
    implements Consumer<GitLogFullRecord> {
        @NotNull
        private final AtomicBoolean mySkipFurtherOutput = new AtomicBoolean();
        @NotNull
        private final AtomicReference<String> myFirstCommit = new AtomicReference();
        @NotNull
        private final AtomicReference<FilePath> myCurrentPath = new AtomicReference();
        @NotNull
        private final Consumer<? super GitFileRevision> myRevisionConsumer;

        GitLogRecordConsumer(Consumer<? super GitFileRevision> revisionConsumer) {
            this.myRevisionConsumer = revisionConsumer;
        }

        public void reset(@NotNull FilePath path) {
            this.myCurrentPath.set(path);
            this.mySkipFurtherOutput.set(false);
        }

        public void consume(@NotNull GitLogFullRecord record) {
            if (this.mySkipFurtherOutput.get()) {
                return;
            }
            this.myFirstCommit.set(record.getHash());
            this.myRevisionConsumer.consume((Object)this.createGitFileRevision(record));
            List<? extends VcsFileStatusInfo> statusInfos = record.getStatusInfos();
            if (statusInfos.isEmpty()) {
                return;
            }
            if (statusInfos.get(0).getType() == Change.Type.NEW && !GitFileHistory.this.myPath.isDirectory()) {
                this.mySkipFurtherOutput.set(true);
            }
        }

        @NotNull
        private GitFileRevision createGitFileRevision(@NotNull GitLogFullRecord record) {
            GitRevisionNumber revision = new GitRevisionNumber(record.getHash(), record.getDate());
            FilePath revisionPath = this.getRevisionPath(record);
            Couple authorPair = Couple.of((Object)record.getAuthorName(), (Object)record.getAuthorEmail());
            Couple committerPair = Couple.of((Object)record.getCommitterName(), (Object)record.getCommitterEmail());
            List<String> parents = Arrays.asList(record.getParentsHashes());
            List<? extends VcsFileStatusInfo> statusInfos = record.getStatusInfos();
            boolean deleted = !statusInfos.isEmpty() && statusInfos.get(0).getType() == Change.Type.DELETED;
            return new GitFileRevision(GitFileHistory.this.myProject, GitFileHistory.this.myRoot, revisionPath, revision, (Couple<Couple<String>>)Couple.of((Object)authorPair, (Object)committerPair), record.getFullMessage(), null, new Date(record.getAuthorTimeStamp()), parents, deleted);
        }

        @NotNull
        private FilePath getRevisionPath(@NotNull GitLogFullRecord record) {
            List<FilePath> paths = record.getFilePaths(GitFileHistory.this.myRoot);
            if (paths.size() > 0) {
                return paths.get(0);
            }
            return this.myCurrentPath.get();
        }

        @Nullable
        public String getFirstCommit() {
            return this.myFirstCommit.get();
        }
    }
}

