/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.impl.VcsFileStatusInfo;
import git4idea.GitContentRevision;
import git4idea.GitRevisionNumber;
import git4idea.history.GitChangeType;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitChangesParser {
    private static final Logger LOG = Logger.getInstance(GitChangesParser.class);

    @NotNull
    public static List<Change> parse(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<? extends VcsFileStatusInfo> statusInfos, @NotNull String hash, @NotNull Date date, @Nullable String parentsHash) {
        GitRevisionNumber thisRevision = new GitRevisionNumber(hash, date);
        GitRevisionNumber parentRevision = parentsHash == null ? null : new GitRevisionNumber(parentsHash);
        ArrayList<Change> result2 = new ArrayList<Change>();
        for (VcsFileStatusInfo vcsFileStatusInfo : statusInfos) {
            result2.add(GitChangesParser.parseChange(project, root, (VcsRevisionNumber)thisRevision, (VcsRevisionNumber)parentRevision, vcsFileStatusInfo));
        }
        return result2;
    }

    @NotNull
    private static Change parseChange(@NotNull Project project, @NotNull VirtualFile vcsRoot, @NotNull VcsRevisionNumber thisRevision, @Nullable VcsRevisionNumber parentRevision, @NotNull VcsFileStatusInfo statusInfo) {
        ContentRevision after2;
        FileStatus status;
        ContentRevision before;
        String path = statusInfo.getFirstPath();
        FilePath filePath = GitContentRevision.createPath(vcsRoot, path);
        switch (statusInfo.getType()) {
            case NEW: {
                before = null;
                status = FileStatus.ADDED;
                after2 = GitContentRevision.createRevision(filePath, thisRevision, project);
                break;
            }
            case MODIFICATION: {
                status = FileStatus.MODIFIED;
                before = GitContentRevision.createRevision(filePath, parentRevision, project);
                after2 = GitContentRevision.createRevision(filePath, thisRevision, project);
                break;
            }
            case DELETED: {
                status = FileStatus.DELETED;
                before = GitContentRevision.createRevision(filePath, parentRevision, project);
                after2 = null;
                break;
            }
            case MOVED: {
                status = FileStatus.MODIFIED;
                String secondPath = statusInfo.getSecondPath();
                FilePath filePathAfterRename = secondPath == null ? filePath : GitContentRevision.createPath(vcsRoot, secondPath);
                before = GitContentRevision.createRevision(filePath, parentRevision, project);
                after2 = GitContentRevision.createRevision(filePathAfterRename, thisRevision, project);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown file status: " + statusInfo));
            }
        }
        return new Change(before, after2, status);
    }

    @NotNull
    static Change.Type getChangeType(@NotNull GitChangeType type) {
        switch (type) {
            case ADDED: {
                return Change.Type.NEW;
            }
            case TYPE_CHANGED: 
            case MODIFIED: {
                return Change.Type.MODIFICATION;
            }
            case DELETED: {
                return Change.Type.DELETED;
            }
            case COPIED: 
            case RENAMED: {
                return Change.Type.MOVED;
            }
        }
        LOG.error("Unknown git change type: " + (Object)((Object)type));
        return Change.Type.MODIFICATION;
    }
}

