/*
 * Decompiled with CFR 0.152.
 */
package git4idea.checkout;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.intellij.openapi.vcs.CheckoutProviderEx;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.ui.VcsCloneComponent;
import com.intellij.openapi.vcs.ui.cloneDialog.VcsCloneDialogComponentStateListener;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.checkout.GitCloneDialog;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitStandardProgressAnalyzer;
import git4idea.ui.GitCloneDialogComponent;
import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GitCheckoutProvider
extends CheckoutProviderEx {
    public String getVcsName() {
        return "_Git";
    }

    public void doCheckout(@NotNull Project project, @Nullable CheckoutProvider.Listener listener, @Nullable String predefinedRepositoryUrl) {
        FileDocumentManager.getInstance().saveAllDocuments();
        GitCloneDialog dialog2 = new GitCloneDialog(project, predefinedRepositoryUrl);
        if (!dialog2.showAndGet()) {
            return;
        }
        dialog2.rememberSettings();
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        File parent = new File(dialog2.getParentDirectory());
        VirtualFile destinationParent = lfs.findFileByIoFile(parent);
        if (destinationParent == null) {
            destinationParent = lfs.refreshAndFindFileByIoFile(parent);
        }
        if (destinationParent == null) {
            return;
        }
        String sourceRepositoryURL = dialog2.getSourceRepositoryURL();
        String directoryName = dialog2.getDirectoryName();
        String parentDirectory = dialog2.getParentDirectory();
        GitCheckoutProvider.clone(project, Git.getInstance(), listener, destinationParent, sourceRepositoryURL, directoryName, parentDirectory);
    }

    public static void clone(final Project project, final @NotNull Git git, final CheckoutProvider.Listener listener, final VirtualFile destinationParent, final String sourceRepositoryURL, final String directoryName, final String parentDirectory) {
        final AtomicBoolean cloneResult = new AtomicBoolean();
        new Task.Backgroundable(project, DvcsBundle.message((String)"cloning.repository", (Object[])new Object[]{sourceRepositoryURL})){

            public void run(@NotNull ProgressIndicator indicator) {
                cloneResult.set(GitCheckoutProvider.doClone(project, git, directoryName, parentDirectory, sourceRepositoryURL));
            }

            public void onSuccess() {
                if (!cloneResult.get()) {
                    return;
                }
                DvcsUtil.addMappingIfSubRoot((Project)project, (String)FileUtil.join((String[])new String[]{parentDirectory, directoryName}), (String)"Git");
                destinationParent.refresh(true, true, () -> {
                    if (project.isOpen() && !project.isDisposed() && !project.isDefault()) {
                        VcsDirtyScopeManager.getInstance((Project)project).fileDirty(destinationParent);
                    }
                });
                listener.directoryCheckedOut(new File(parentDirectory, directoryName), GitVcs.getKey());
                listener.checkoutCompleted();
            }
        }.queue();
    }

    public static boolean doClone(@NotNull Project project, @NotNull Git git, @NotNull String directoryName, @NotNull String parentDirectory, @NotNull String sourceRepositoryURL) {
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        indicator.setIndeterminate(false);
        GitLineHandlerListener progressListener = GitStandardProgressAnalyzer.createListener(indicator);
        GitCommandResult result2 = git.clone(project, new File(parentDirectory), sourceRepositoryURL, directoryName, progressListener);
        if (result2.success()) {
            return true;
        }
        String description = result2.getErrorOutput().stream().filter(msg -> !StringUtil.startsWithIgnoreCase((String)msg, (String)"Cloning into") && !StringUtil.startsWithIgnoreCase((String)msg, (String)"remote:") && !StringUtil.startsWithIgnoreCase((String)msg, (String)"submodule")).map(msg -> GitUtil.cleanupErrorPrefixes(msg)).collect(Collectors.joining("<br/>"));
        VcsNotifier.getInstance((Project)project).notifyError("Clone failed", StringUtil.capitalize((String)description), true);
        return false;
    }

    @NotNull
    public String getVcsId() {
        return "git";
    }

    public void doCheckout(@NotNull Project project, @Nullable CheckoutProvider.Listener listener) {
        this.doCheckout(project, listener, null);
    }

    @NotNull
    public VcsCloneComponent buildVcsCloneComponent(@NotNull Project project, @NotNull ModalityState modalityState, @NotNull VcsCloneDialogComponentStateListener dialogStateListener) {
        return new GitCloneDialogComponent(project, modalityState, dialogStateListener);
    }
}

