/*
 * Decompiled with CFR 0.152.
 */
package git4idea.checkin;

import com.intellij.CommonBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.checkin.VcsCheckinHandlerFactory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PairConsumer;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.checkin.GitCommitAndPushExecutor;
import git4idea.checkin.GitUserNameNotDefinedDialog;
import git4idea.commands.Git;
import git4idea.config.GitConfigUtil;
import git4idea.config.GitExecutableManager;
import git4idea.config.GitVcsSettings;
import git4idea.config.GitVersion;
import git4idea.config.GitVersionSpecialty;
import git4idea.crlf.GitCrlfDialog;
import git4idea.crlf.GitCrlfProblemsDetector;
import git4idea.crlf.GitCrlfUtil;
import git4idea.i18n.GitBundle;
import git4idea.rebase.GitRebaseUtils;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitCheckinHandlerFactory
extends VcsCheckinHandlerFactory {
    private static final Logger LOG = Logger.getInstance(GitCheckinHandlerFactory.class);

    public GitCheckinHandlerFactory() {
        super(GitVcs.getKey());
    }

    @NotNull
    protected CheckinHandler createVcsHandler(@NotNull CheckinProjectPanel panel2, @NotNull CommitContext commitContext) {
        return new MyCheckinHandler(panel2);
    }

    private static class MyCheckinHandler
    extends CheckinHandler {
        @NotNull
        private final CheckinProjectPanel myPanel;
        @NotNull
        private final Project myProject;

        MyCheckinHandler(@NotNull CheckinProjectPanel panel2) {
            this.myPanel = panel2;
            this.myProject = this.myPanel.getProject();
        }

        public CheckinHandler.ReturnResult beforeCheckin(@Nullable CommitExecutor executor, PairConsumer<Object, Object> additionalDataConsumer) {
            if (this.emptyCommitMessage()) {
                return CheckinHandler.ReturnResult.CANCEL;
            }
            if (MyCheckinHandler.commitOrCommitAndPush(executor)) {
                CheckinHandler.ReturnResult result2 = this.checkGitVersionAndEnv();
                if (result2 != CheckinHandler.ReturnResult.COMMIT) {
                    return result2;
                }
                result2 = this.checkUserName();
                if (result2 != CheckinHandler.ReturnResult.COMMIT) {
                    return result2;
                }
                result2 = this.warnAboutCrlfIfNeeded();
                if (result2 != CheckinHandler.ReturnResult.COMMIT) {
                    return result2;
                }
                return this.warnAboutDetachedHeadIfNeeded();
            }
            return CheckinHandler.ReturnResult.COMMIT;
        }

        @NotNull
        private CheckinHandler.ReturnResult warnAboutCrlfIfNeeded() {
            GitVcsSettings settings = GitVcsSettings.getInstance(this.myProject);
            if (!settings.warnAboutCrlf()) {
                return CheckinHandler.ReturnResult.COMMIT;
            }
            final Git git = Git.getInstance();
            final Collection files = this.myPanel.getVirtualFiles();
            final AtomicReference crlfHelper = new AtomicReference();
            ProgressManager.getInstance().run((Task)new Task.Modal(this.myProject, "Checking for Line Separator Issues...", true){

                public void run(@NotNull ProgressIndicator indicator) {
                    crlfHelper.set(GitCrlfProblemsDetector.detect(myProject, git, files));
                }
            });
            if (crlfHelper.get() == null) {
                return CheckinHandler.ReturnResult.CANCEL;
            }
            if (((GitCrlfProblemsDetector)crlfHelper.get()).shouldWarn()) {
                Pair codeAndDontWarn = (Pair)UIUtil.invokeAndWaitIfNeeded(() -> {
                    GitCrlfDialog dialog2 = new GitCrlfDialog(this.myProject);
                    dialog2.show();
                    return Pair.create((Object)dialog2.getExitCode(), (Object)dialog2.dontWarnAgain());
                });
                int decision = (Integer)codeAndDontWarn.first;
                boolean dontWarnAgain = (Boolean)codeAndDontWarn.second;
                if (decision == 1) {
                    return CheckinHandler.ReturnResult.CANCEL;
                }
                if (decision == 0) {
                    VirtualFile anyRoot = (VirtualFile)this.myPanel.getRoots().iterator().next();
                    this.setCoreAutoCrlfAttribute(anyRoot);
                } else if (dontWarnAgain) {
                    settings.setWarnAboutCrlf(false);
                }
                return CheckinHandler.ReturnResult.COMMIT;
            }
            return CheckinHandler.ReturnResult.COMMIT;
        }

        private void setCoreAutoCrlfAttribute(final @NotNull VirtualFile aRoot) {
            ProgressManager.getInstance().run((Task)new Task.Modal(this.myProject, "Updating Git Config...", true){

                public void run(@NotNull ProgressIndicator pi) {
                    try {
                        GitConfigUtil.setValue(this.myProject, aRoot, "core.autocrlf", GitCrlfUtil.RECOMMENDED_VALUE, "--global");
                    }
                    catch (VcsException e) {
                        LOG.warn("Couldn't globally set core.autocrlf in " + aRoot, (Throwable)e);
                    }
                }
            });
        }

        private CheckinHandler.ReturnResult checkGitVersionAndEnv() {
            GitVersion version = GitExecutableManager.getInstance().getVersionUnderModalProgressOrCancel(this.myProject);
            if (System.getenv("HOME") == null && GitVersionSpecialty.DOESNT_DEFINE_HOME_ENV_VAR.existsIn(version)) {
                Messages.showErrorDialog((Project)this.myProject, (String)("You are using Git " + version.getPresentation() + " which doesn't define %HOME% environment variable properly.\nConsider updating Git to a newer version or define %HOME% to point to the place where the global .gitconfig is stored \n(it is usually %USERPROFILE% or %HOMEDRIVE%%HOMEPATH%)."), (String)"HOME Variable Is Not Defined");
                return CheckinHandler.ReturnResult.CANCEL;
            }
            return CheckinHandler.ReturnResult.COMMIT;
        }

        private CheckinHandler.ReturnResult checkUserName() {
            GitUserNameNotDefinedDialog dialog2;
            Project project = this.myPanel.getProject();
            GitVcs vcs = GitVcs.getInstance(project);
            Collection<VirtualFile> affectedRoots = this.getSelectedRoots();
            Map<VirtualFile, Couple<String>> defined = MyCheckinHandler.getDefinedUserNames(project, affectedRoots, false);
            ArrayList<VirtualFile> allRoots = new ArrayList<VirtualFile>(Arrays.asList(ProjectLevelVcsManager.getInstance((Project)project).getRootsUnderVcs((AbstractVcs)vcs)));
            ArrayList<VirtualFile> notDefined = new ArrayList<VirtualFile>(affectedRoots);
            notDefined.removeAll(defined.keySet());
            if (notDefined.isEmpty()) {
                return CheckinHandler.ReturnResult.COMMIT;
            }
            if (defined.isEmpty() && allRoots.size() > affectedRoots.size()) {
                allRoots.removeAll(affectedRoots);
                defined.putAll(MyCheckinHandler.getDefinedUserNames(project, allRoots, true));
            }
            if ((dialog2 = new GitUserNameNotDefinedDialog(project, notDefined, affectedRoots, defined)).showAndGet()) {
                GitVcsSettings.getInstance(project).setUserNameGlobally(dialog2.isGlobal());
                return this.setUserNameUnderProgress(project, notDefined, dialog2) ? CheckinHandler.ReturnResult.COMMIT : CheckinHandler.ReturnResult.CANCEL;
            }
            return CheckinHandler.ReturnResult.CLOSE_WINDOW;
        }

        @NotNull
        private static Map<VirtualFile, Couple<String>> getDefinedUserNames(final @NotNull Project project, final @NotNull Collection<? extends VirtualFile> roots, final boolean stopWhenFoundFirst) {
            final HashMap<VirtualFile, Couple<String>> defined = new HashMap<VirtualFile, Couple<String>>();
            ProgressManager.getInstance().run((Task)new Task.Modal(project, "Checking Git User Name...", true){

                public void run(@NotNull ProgressIndicator pi) {
                    for (VirtualFile root : roots) {
                        try {
                            Couple nameAndEmail = MyCheckinHandler.getUserNameAndEmailFromGitConfig(project, root);
                            String name = (String)nameAndEmail.getFirst();
                            String email = (String)nameAndEmail.getSecond();
                            if (name == null || email == null) continue;
                            defined.put(root, nameAndEmail);
                            if (!stopWhenFoundFirst) continue;
                            return;
                        }
                        catch (VcsException e) {
                            LOG.error("Couldn't get user.name and user.email for root " + root, (Throwable)e);
                        }
                    }
                }
            });
            return defined;
        }

        private boolean setUserNameUnderProgress(final @NotNull Project project, final @NotNull Collection<? extends VirtualFile> notDefined, final @NotNull GitUserNameNotDefinedDialog dialog2) {
            final Ref error = Ref.create();
            ProgressManager.getInstance().run((Task)new Task.Modal(project, "Setting Git User Name...", true){

                public void run(@NotNull ProgressIndicator pi) {
                    try {
                        if (dialog2.isGlobal()) {
                            GitConfigUtil.setValue(project, (VirtualFile)notDefined.iterator().next(), "user.name", dialog2.getUserName(), "--global");
                            GitConfigUtil.setValue(project, (VirtualFile)notDefined.iterator().next(), "user.email", dialog2.getUserEmail(), "--global");
                        } else {
                            for (VirtualFile root : notDefined) {
                                GitConfigUtil.setValue(project, root, "user.name", dialog2.getUserName(), new String[0]);
                                GitConfigUtil.setValue(project, root, "user.email", dialog2.getUserEmail(), new String[0]);
                            }
                        }
                    }
                    catch (VcsException e) {
                        String message = "Couldn't set user.name and user.email";
                        LOG.error(message, (Throwable)e);
                        error.set((Object)message);
                    }
                }
            });
            if (error.isNull()) {
                return true;
            }
            Messages.showErrorDialog((Component)this.myPanel.getComponent(), (String)((String)error.get()));
            return false;
        }

        @NotNull
        private static Couple<String> getUserNameAndEmailFromGitConfig(@NotNull Project project, @NotNull VirtualFile root) throws VcsException {
            String name = GitConfigUtil.getValue(project, root, "user.name");
            String email = GitConfigUtil.getValue(project, root, "user.email");
            return Couple.of((Object)name, (Object)email);
        }

        private boolean emptyCommitMessage() {
            if (this.myPanel.getCommitMessage().trim().isEmpty()) {
                Messages.showMessageDialog((Component)this.myPanel.getComponent(), (String)GitBundle.message("git.commit.message.empty", new Object[0]), (String)GitBundle.message("git.commit.message.empty.title", new Object[0]), (Icon)Messages.getErrorIcon());
                return true;
            }
            return false;
        }

        private CheckinHandler.ReturnResult warnAboutDetachedHeadIfNeeded() {
            String message;
            String title;
            DetachedRoot detachedRoot = this.getDetachedRoot();
            if (detachedRoot == null || !GitVcsSettings.getInstance(this.myProject).warnAboutDetachedHead()) {
                return CheckinHandler.ReturnResult.COMMIT;
            }
            String rootPath = detachedRoot.myRoot.getPresentableUrl();
            String messageCommonStart = "The Git repository at the following path";
            if (detachedRoot.myRebase) {
                title = "Unfinished Rebase Process";
                message = "The Git repository at the following path has an <b>unfinished rebase</b> process: <br/><b>" + rootPath + "</b><br>You probably want to <b>continue rebase</b> instead of committing. <br/>Committing during rebase may lead to the commit loss. <br/>" + MyCheckinHandler.readMore("https://www.kernel.org/pub/software/scm/git/docs/git-rebase.html", "Read more about Git rebase");
            } else {
                title = "Commit in Detached HEAD";
                message = "The Git repository at the following path is in the <b>detached HEAD</b> state: <br/><b>" + rootPath + "</b><br>You can look around, make experimental changes and commit them, but be sure to checkout a branch not to lose your work. <br/>Otherwise you risk losing your changes. <br/>" + MyCheckinHandler.readMore("http://gitolite.com/detached-head.html", "Read more about detached HEAD");
            }
            DialogWrapper.DoNotAskOption.Adapter dontAskAgain = new DialogWrapper.DoNotAskOption.Adapter(){

                public void rememberChoice(boolean isSelected, int exitCode) {
                    GitVcsSettings.getInstance(myProject).setWarnAboutDetachedHead(!isSelected);
                }

                @NotNull
                public String getDoNotShowMessage() {
                    return "Don't warn again";
                }
            };
            int choice = Messages.showOkCancelDialog((Project)this.myProject, (String)XmlStringUtil.wrapInHtml((CharSequence)message), (String)title, (String)"Commit", (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getWarningIcon(), (DialogWrapper.DoNotAskOption)dontAskAgain);
            if (choice == 0) {
                return CheckinHandler.ReturnResult.COMMIT;
            }
            return CheckinHandler.ReturnResult.CLOSE_WINDOW;
        }

        private static boolean commitOrCommitAndPush(@Nullable CommitExecutor executor) {
            return executor == null || executor instanceof GitCommitAndPushExecutor;
        }

        @NotNull
        private static String readMore(@NotNull String link, @NotNull String message) {
            return String.format("<a href='%s'>%s</a>.", link, message);
        }

        @Nullable
        private DetachedRoot getDetachedRoot() {
            GitRepositoryManager repositoryManager = GitUtil.getRepositoryManager(this.myPanel.getProject());
            for (VirtualFile root : this.getSelectedRoots()) {
                GitRepository repository = (GitRepository)repositoryManager.getRepositoryForRootQuick(root);
                if (repository == null || repository.isOnBranch() || GitRebaseUtils.isInteractiveRebaseInProgress(repository)) continue;
                return new DetachedRoot(root, repository.isRebaseInProgress());
            }
            return null;
        }

        @NotNull
        private Collection<VirtualFile> getSelectedRoots() {
            ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
            GitVcs git = GitVcs.getInstance(this.myProject);
            HashSet<VirtualFile> result2 = new HashSet<VirtualFile>();
            for (FilePath path : ChangesUtil.getPaths((Collection)this.myPanel.getSelectedChanges())) {
                VcsRoot vcsRoot = vcsManager.getVcsRootObjectFor(path);
                if (vcsRoot == null) continue;
                VirtualFile root = vcsRoot.getPath();
                if (!git.equals(vcsRoot.getVcs())) continue;
                result2.add(root);
            }
            return result2;
        }

        private static class DetachedRoot {
            final VirtualFile myRoot;
            final boolean myRebase;

            DetachedRoot(@NotNull VirtualFile root, boolean rebase) {
                this.myRoot = root;
                this.myRebase = rebase;
            }
        }
    }
}

