/*
 * Decompiled with CFR 0.152.
 */
package git4idea.checkin;

import com.google.common.collect.HashMultiset;
import com.intellij.CommonBundle;
import com.intellij.diff.util.Side;
import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListChange;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.ui.SelectFilePathsDialog;
import com.intellij.openapi.vcs.checkin.CheckinChangeListSpecificComponent;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vcs.ex.PartialCommitHelper;
import com.intellij.openapi.vcs.ex.PartialLocalLineStatusTracker;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import com.intellij.openapi.vcs.impl.PartialChangesUtil;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.GuiUtils;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PairConsumer;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.concurrency.FutureResult;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.commit.AbstractCommitWorkflowKt;
import com.intellij.vcs.commit.AmendCommitAware;
import com.intellij.vcs.commit.EditedCommitDetails;
import com.intellij.vcs.commit.LocalChangesCommitterKt;
import com.intellij.vcs.commit.ToggleAmendCommitOption;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.branch.GitBranchUtil;
import git4idea.changes.GitChangeUtils;
import git4idea.checkin.GitAmendCommitService;
import git4idea.checkin.GitCheckinExplicitMovementProvider;
import git4idea.checkin.GitCommitAndPushExecutorKt;
import git4idea.checkin.GitCommitOptionsKt;
import git4idea.checkin.GitCommitOptionsUi;
import git4idea.checkin.GitPushAfterCommitDialog;
import git4idea.checkin.GitSkipHooksCommitHandlerFactoryKt;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.config.GitConfigUtil;
import git4idea.i18n.GitBundle;
import git4idea.index.GitIndexUtil;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.repo.GitSubmoduleKt;
import git4idea.util.GitFileUtils;
import gnu.trove.THashSet;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutionException;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.CancellablePromise;

public class GitCheckinEnvironment
implements CheckinEnvironment,
AmendCommitAware {
    private static final Logger LOG = Logger.getInstance(GitCheckinEnvironment.class);
    @NonNls
    private static final String GIT_COMMIT_MSG_FILE_PREFIX = "git-commit-msg-";
    @NonNls
    private static final String GIT_COMMIT_MSG_FILE_EXT = ".txt";
    private final Project myProject;
    public static final SimpleDateFormat COMMIT_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private VcsUser myNextCommitAuthor = null;
    private boolean myNextCommitAmend;
    private Date myNextCommitAuthorDate;
    private boolean myNextCommitSignOff;
    private boolean myNextCommitSkipHook;

    public GitCheckinEnvironment(@NotNull Project project) {
        this.myProject = project;
    }

    public boolean isRefreshAfterCommitNeeded() {
        return true;
    }

    @NotNull
    public RefreshableOnComponent createCommitOptions(@NotNull CheckinProjectPanel commitPanel, @NotNull CommitContext commitContext) {
        return new GitCheckinOptions(commitPanel, commitContext, ToggleAmendCommitOption.isAmendCommitOptionSupported((CheckinProjectPanel)commitPanel, (AmendCommitAware)this));
    }

    @Nullable
    public String getDefaultMessageFor(FilePath @NotNull [] filesToCheckin) {
        LinkedHashSet<String> messages = new LinkedHashSet<String>();
        GitRepositoryManager manager = GitUtil.getRepositoryManager(this.myProject);
        Set repositories = ContainerUtil.map2SetNotNull(Arrays.asList(filesToCheckin), arg_0 -> ((GitRepositoryManager)manager).getRepositoryForFileQuick(arg_0));
        for (GitRepository repository : repositories) {
            File mergeMsg = repository.getRepositoryFiles().getMergeMessageFile();
            File squashMsg = repository.getRepositoryFiles().getSquashMessageFile();
            try {
                if (!mergeMsg.exists() && !squashMsg.exists()) continue;
                String encoding = GitConfigUtil.getCommitEncoding(this.myProject, repository.getRoot());
                if (mergeMsg.exists()) {
                    messages.add(GitCheckinEnvironment.loadMessage(mergeMsg, encoding));
                    continue;
                }
                messages.add(GitCheckinEnvironment.loadMessage(squashMsg, encoding));
            }
            catch (IOException e) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Unable to load merge message", (Throwable)e);
            }
        }
        return DvcsUtil.joinMessagesOrNull(messages);
    }

    private static String loadMessage(@NotNull File messageFile, @NotNull String encoding) throws IOException {
        return FileUtil.loadFile((File)messageFile, (String)encoding);
    }

    public String getHelpId() {
        return null;
    }

    public String getCheckinOperationName() {
        return GitBundle.getString("commit.action.name");
    }

    public boolean isAmendCommitSupported() {
        return this.getAmendService().isAmendCommitSupported();
    }

    @Nullable
    public String getLastCommitMessage(@NotNull VirtualFile root) throws VcsException {
        return this.getAmendService().getLastCommitMessage(root);
    }

    @NotNull
    public CancellablePromise<EditedCommitDetails> getAmendCommitDetails(@NotNull VirtualFile root) {
        return this.getAmendService().getAmendCommitDetails(root);
    }

    @NotNull
    private GitAmendCommitService getAmendService() {
        return (GitAmendCommitService)((Object)this.myProject.getService(GitAmendCommitService.class));
    }

    private void updateState(@NotNull CommitContext commitContext) {
        this.myNextCommitAmend = AbstractCommitWorkflowKt.isAmendCommitMode((CommitContext)commitContext);
        this.myNextCommitSkipHook = GitSkipHooksCommitHandlerFactoryKt.isSkipHooks(commitContext);
        this.myNextCommitAuthor = GitCommitOptionsKt.getCommitAuthor(commitContext);
        this.myNextCommitAuthorDate = GitCommitOptionsKt.getCommitAuthorDate(commitContext);
        this.myNextCommitSignOff = GitCommitOptionsKt.isSignOffCommit(commitContext);
    }

    @NotNull
    public List<VcsException> commit(@NotNull List<Change> changes, @NotNull String commitMessage, @NotNull CommitContext commitContext, @NotNull Set<String> feedback) {
        this.updateState(commitContext);
        ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
        Map<GitRepository, Collection<Change>> sortedChanges = GitCheckinEnvironment.sortChangesByGitRoot(this.myProject, changes, exceptions);
        Collection commitWithoutChangesRoots = LocalChangesCommitterKt.getCommitWithoutChangesRoots((CommitContext)commitContext);
        LOG.assertTrue(!sortedChanges.isEmpty() || !commitWithoutChangesRoots.isEmpty(), (Object)("Trying to commit an empty list of changes: " + changes));
        List<GitRepository> repositories = this.collectRepositories(sortedChanges.keySet(), commitWithoutChangesRoots);
        for (GitRepository repository : repositories) {
            Collection<Change> rootChanges = sortedChanges.getOrDefault(repository, ContainerUtil.emptyList());
            Collection toCommit = ContainerUtil.map(rootChanges, CommitChange::new);
            if (GitCommitOptionsKt.isCommitRenamesSeparately(commitContext)) {
                Pair<Collection<CommitChange>, List<VcsException>> pair = this.commitExplicitRenames(repository, toCommit, commitMessage);
                toCommit = (Collection)pair.first;
                List moveExceptions = (List)pair.second;
                if (!moveExceptions.isEmpty()) {
                    exceptions.addAll(moveExceptions);
                    continue;
                }
            }
            exceptions.addAll(this.commitRepository(repository, toCommit, commitMessage));
        }
        if (GitCommitAndPushExecutorKt.isPushAfterCommit(commitContext) && exceptions.isEmpty()) {
            ModalityState modality = ModalityState.defaultModalityState();
            TransactionGuard.getInstance().assertWriteSafeContext(modality);
            ArrayList<GitRepository> preselectedRepositories = new ArrayList<GitRepository>(repositories);
            GuiUtils.invokeLaterIfNeeded(() -> new GitPushAfterCommitDialog(this.myProject, preselectedRepositories, GitBranchUtil.getCurrentRepository(this.myProject)).showOrPush(), (ModalityState)modality, (Condition)this.myProject.getDisposed());
        }
        return exceptions;
    }

    @NotNull
    private List<GitRepository> collectRepositories(@NotNull Collection<GitRepository> changesRepositories, @NotNull Collection<VcsRoot> noChangesRoots) {
        GitRepositoryManager repositoryManager = GitUtil.getRepositoryManager(this.myProject);
        GitVcs vcs = GitVcs.getInstance(this.myProject);
        Collection<GitRepository> noChangesRepositories = GitUtil.getRepositoriesFromRoots(repositoryManager, ContainerUtil.mapNotNull(noChangesRoots, it -> it.getVcs() == vcs ? it.getPath() : null));
        return repositoryManager.sortByDependency(ContainerUtil.union(changesRepositories, noChangesRepositories));
    }

    @NotNull
    private List<VcsException> commitRepository(@NotNull GitRepository repository, @NotNull Collection<? extends CommitChange> changes, @NotNull String message) {
        ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
        VirtualFile root = repository.getRoot();
        try {
            Pair<Runnable, List<CommitChange>> partialAddResult = this.addPartialChangesToIndex(repository, changes);
            Runnable callback = (Runnable)partialAddResult.first;
            HashSet<CommitChange> changedWithIndex = new HashSet<CommitChange>((Collection)partialAddResult.second);
            List<CommitChange> caseOnlyRenameChanges = this.addCaseOnlyRenamesToIndex(repository, changes, changedWithIndex, exceptions);
            if (!exceptions.isEmpty()) {
                return exceptions;
            }
            changedWithIndex.addAll(caseOnlyRenameChanges);
            if (!changedWithIndex.isEmpty() || Registry.is((String)"git.force.commit.using.staging.area")) {
                GitCheckinEnvironment.runWithMessageFile(this.myProject, root, message, (ThrowableConsumer<? super File, ? extends VcsException>)((ThrowableConsumer)messageFile -> exceptions.addAll(this.commitUsingIndex(repository, changes, (Set<? extends CommitChange>)changedWithIndex, (File)messageFile))));
                if (!exceptions.isEmpty()) {
                    return exceptions;
                }
                callback.run();
            } else {
                try {
                    GitCheckinEnvironment.runWithMessageFile(this.myProject, root, message, (ThrowableConsumer<? super File, ? extends VcsException>)((ThrowableConsumer)messageFile -> {
                        List<FilePath> files = GitCheckinEnvironment.getPaths(changes);
                        this.commit(this.myProject, root, (Collection<? extends FilePath>)files, (File)messageFile);
                    }));
                }
                catch (VcsException ex) {
                    PartialOperation partialOperation = GitCheckinEnvironment.isMergeCommit(ex);
                    if (partialOperation == PartialOperation.NONE) {
                        throw ex;
                    }
                    GitCheckinEnvironment.runWithMessageFile(this.myProject, root, message, (ThrowableConsumer<? super File, ? extends VcsException>)((ThrowableConsumer)messageFile -> {
                        if (!this.mergeCommit(this.myProject, root, changes, (File)messageFile, (List<? super VcsException>)exceptions, partialOperation)) {
                            throw ex;
                        }
                    }));
                }
            }
            GitUtil.getRepositoryManager(this.myProject).updateRepository(root);
            if (GitSubmoduleKt.isSubmodule(repository)) {
                VcsDirtyScopeManager.getInstance((Project)this.myProject).dirDirtyRecursively(repository.getRoot().getParent());
            }
        }
        catch (VcsException e) {
            exceptions.add(e);
        }
        return exceptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private List<VcsException> commitUsingIndex(@NotNull GitRepository repository, @NotNull Collection<? extends CommitChange> rootChanges, @NotNull Set<? extends CommitChange> changedWithIndex, @NotNull File messageFile) {
        ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
        try {
            Set added = ContainerUtil.map2SetNotNull(rootChanges, it -> it.afterPath);
            Set removed = ContainerUtil.map2SetNotNull(rootChanges, it -> it.beforePath);
            VirtualFile root = repository.getRoot();
            String rootPath = root.getPath();
            List<FilePath> unmergedFiles = GitChangeUtils.getUnmergedFiles(repository);
            if (!unmergedFiles.isEmpty()) {
                throw new VcsException("Committing is not possible because you have unmerged files.");
            }
            Collection<GitChangeUtils.GitDiffChange> stagedChanges = GitChangeUtils.getStagedChanges(this.myProject, root);
            LOG.debug("Found staged changes: " + GitUtil.getLogStringGitDiffChanges(rootPath, stagedChanges));
            ArrayList excludedStagedChanges = new ArrayList();
            GitCheckinEnvironment.processExcludedPaths(stagedChanges, added, removed, (PairConsumer<? super FilePath, ? super FilePath>)((PairConsumer)(before, after2) -> {
                if (before != null || after2 != null) {
                    excludedStagedChanges.add(new ChangedPath((FilePath)before, (FilePath)after2));
                }
            }));
            Collection<GitChangeUtils.GitDiffChange> unstagedChanges = GitChangeUtils.getUnstagedChanges(this.myProject, root, false);
            LOG.debug("Found unstaged changes: " + GitUtil.getLogStringGitDiffChanges(rootPath, unstagedChanges));
            HashSet<FilePath> excludedUnstagedDeletions = new HashSet<FilePath>();
            GitCheckinEnvironment.processExcludedPaths(unstagedChanges, added, removed, (PairConsumer<? super FilePath, ? super FilePath>)((PairConsumer)(before, after2) -> {
                if (before != null && after2 == null) {
                    excludedUnstagedDeletions.add((FilePath)before);
                }
            }));
            if (!excludedStagedChanges.isEmpty()) {
                LOG.info("Staged changes excluded for commit: " + GitCheckinEnvironment.getLogString(rootPath, excludedStagedChanges));
                GitCheckinEnvironment.resetExcluded(this.myProject, root, excludedStagedChanges);
            }
            try {
                List<FilePath> alreadyHandledPaths = GitCheckinEnvironment.getPaths(changedWithIndex);
                HashSet toAdd = new HashSet(added);
                toAdd.removeAll(alreadyHandledPaths);
                HashSet toRemove = new HashSet(removed);
                toRemove.removeAll(toAdd);
                toRemove.removeAll(alreadyHandledPaths);
                LOG.debug(String.format("Updating index: added: %s, removed: %s", toAdd, toRemove));
                GitCheckinEnvironment.updateIndex(this.myProject, root, toAdd, toRemove, exceptions);
                if (!exceptions.isEmpty()) {
                    ArrayList<VcsException> arrayList = exceptions;
                    return arrayList;
                }
                LOG.debug("Performing commit...");
                this.commitWithoutPaths(this.myProject, root, messageFile);
                return exceptions;
            }
            finally {
                if (!excludedStagedChanges.isEmpty()) {
                    GitCheckinEnvironment.restoreExcluded(this.myProject, root, excludedStagedChanges, excludedUnstagedDeletions);
                }
            }
        }
        catch (VcsException e) {
            exceptions.add(e);
        }
        return exceptions;
    }

    @NotNull
    private Pair<Runnable, List<CommitChange>> addPartialChangesToIndex(@NotNull GitRepository repository, @NotNull Collection<? extends CommitChange> changes) throws VcsException {
        Set changelistIds = ContainerUtil.map2SetNotNull(changes, change -> change.changelistId);
        if (changelistIds.isEmpty()) {
            return Pair.create((Object)EmptyRunnable.INSTANCE, (Object)ContainerUtil.emptyList());
        }
        if (changelistIds.size() != 1) {
            throw new VcsException("Can't commit changes from multiple changelists at once");
        }
        String changelistId = (String)changelistIds.iterator().next();
        Pair result2 = (Pair)GitCheckinEnvironment.computeAfterLSTManagerUpdate(repository.getProject(), () -> {
            ArrayList<PartialCommitHelper> helpers = new ArrayList<PartialCommitHelper>();
            ArrayList<CommitChange> partialChanges = new ArrayList<CommitChange>();
            for (CommitChange change : changes) {
                PartialLocalLineStatusTracker tracker;
                if (change.changelistId == null || change.virtualFile == null || change.beforePath == null || change.afterPath == null || (tracker = PartialChangesUtil.getPartialTracker((Project)this.myProject, (VirtualFile)change.virtualFile)) == null) continue;
                if (!tracker.isOperational()) {
                    LOG.warn("Tracker is not operational for " + tracker.getVirtualFile().getPresentableUrl());
                    return null;
                }
                if (!tracker.hasPartialChangesToCommit()) continue;
                helpers.add(tracker.handlePartialCommit(Side.LEFT, Collections.singletonList(changelistId), true));
                partialChanges.add(change);
            }
            return Pair.create(helpers, partialChanges);
        });
        if (result2 == null) {
            throw new VcsException("Can't collect partial changes to commit");
        }
        List helpers = (List)result2.first;
        List partialChanges = (List)result2.second;
        ArrayList<FilePath> pathsToDelete = new ArrayList<FilePath>();
        for (CommitChange change2 : partialChanges) {
            if (!change2.isMove()) continue;
            pathsToDelete.add(Objects.requireNonNull(change2.beforePath));
        }
        LOG.debug(String.format("Updating index for partial changes: removing: %s", pathsToDelete));
        GitFileUtils.deletePaths(this.myProject, repository.getRoot(), pathsToDelete, "--ignore-unmatch");
        LOG.debug(String.format("Updating index for partial changes: changes: %s", partialChanges));
        for (int i2 = 0; i2 < partialChanges.size(); ++i2) {
            CommitChange change2;
            change2 = (CommitChange)partialChanges.get(i2);
            FilePath path = Objects.requireNonNull(change2.afterPath);
            PartialCommitHelper helper = (PartialCommitHelper)helpers.get(i2);
            VirtualFile file = change2.virtualFile;
            if (file == null) {
                throw new VcsException("Can't find file: " + path.getPath());
            }
            GitIndexUtil.StagedFile stagedFile = GitCheckinEnvironment.getStagedFile(repository, change2);
            boolean isExecutable = stagedFile != null && stagedFile.isExecutable();
            byte[] fileContent = GitCheckinEnvironment.convertDocumentContentToBytes(repository, helper.getContent(), file);
            byte[] bom = file.getBOM();
            if (bom != null && !ArrayUtil.startsWith((byte[])fileContent, (byte[])bom)) {
                fileContent = ArrayUtil.mergeArrays((byte[])bom, (byte[])fileContent);
            }
            GitIndexUtil.write(repository, path, fileContent, isExecutable);
        }
        Runnable callback = () -> ApplicationManager.getApplication().invokeLater(() -> {
            for (PartialCommitHelper helper : helpers) {
                try {
                    helper.applyChanges();
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
        });
        return Pair.create((Object)callback, (Object)partialChanges);
    }

    private static byte @NotNull [] convertDocumentContentToBytes(@NotNull GitRepository repository, @NotNull String documentContent, @NotNull VirtualFile file) {
        String lineSeparator = FileDocumentManager.getInstance().getLineSeparator(file, repository.getProject());
        String text = lineSeparator.equals("\n") ? documentContent : StringUtil.convertLineSeparators((String)documentContent, (String)lineSeparator);
        return (byte[])LoadTextUtil.charsetForWriting((Project)repository.getProject(), (VirtualFile)file, (String)text, (Charset)file.getCharset()).second;
    }

    @Nullable
    private static GitIndexUtil.StagedFile getStagedFile(@NotNull GitRepository repository, @NotNull CommitChange change) throws VcsException {
        GitIndexUtil.StagedFile file;
        GitIndexUtil.StagedFile file2;
        FilePath bPath = change.beforePath;
        if (bPath != null && (file2 = GitIndexUtil.listStaged(repository, bPath)) != null) {
            return file2;
        }
        FilePath aPath = change.afterPath;
        if (aPath != null && (file = GitIndexUtil.listStaged(repository, aPath)) != null) {
            return file;
        }
        return null;
    }

    @Nullable
    private static <T> T computeAfterLSTManagerUpdate(@NotNull Project project, @NotNull Computable<T> computation) {
        assert (!ApplicationManager.getApplication().isDispatchThread());
        FutureResult ref = new FutureResult();
        LineStatusTrackerManager.getInstance((Project)project).invokeAfterUpdate(() -> {
            try {
                ref.set(computation.compute());
            }
            catch (Throwable e) {
                ref.setException(e);
            }
        });
        try {
            return (T)ref.get();
        }
        catch (InterruptedException | ExecutionException e) {
            return null;
        }
    }

    @NotNull
    private List<CommitChange> addCaseOnlyRenamesToIndex(@NotNull GitRepository repository, @NotNull Collection<? extends CommitChange> changes, @NotNull Set<CommitChange> alreadyProcessed, @NotNull List<? super VcsException> exceptions) {
        if (SystemInfo.isFileSystemCaseSensitive) {
            return Collections.emptyList();
        }
        List caseOnlyRenames = ContainerUtil.filter(changes, it -> !alreadyProcessed.contains(it) && GitCheckinEnvironment.isCaseOnlyRename(it));
        if (caseOnlyRenames.isEmpty()) {
            return caseOnlyRenames;
        }
        LOG.info("Committing case only rename: " + GitCheckinEnvironment.getLogString(repository.getRoot().getPath(), caseOnlyRenames) + " in " + DvcsUtil.getShortRepositoryName((Repository)repository));
        List pathsToAdd = ContainerUtil.map((Collection)caseOnlyRenames, it -> it.afterPath);
        List pathsToDelete = ContainerUtil.map((Collection)caseOnlyRenames, it -> it.beforePath);
        LOG.debug(String.format("Updating index for case only changes: added: %s,\n removed: %s", pathsToAdd, pathsToDelete));
        GitCheckinEnvironment.updateIndex(this.myProject, repository.getRoot(), pathsToAdd, pathsToDelete, exceptions);
        return caseOnlyRenames;
    }

    private static boolean isCaseOnlyRename(@NotNull ChangedPath change) {
        if (SystemInfo.isFileSystemCaseSensitive) {
            return false;
        }
        if (!change.isMove()) {
            return false;
        }
        FilePath afterPath = Objects.requireNonNull(change.afterPath);
        FilePath beforePath = Objects.requireNonNull(change.beforePath);
        return GitUtil.isCaseOnlyChange(beforePath.getPath(), afterPath.getPath());
    }

    @NotNull
    private static List<FilePath> getPaths(@NotNull Collection<? extends CommitChange> changes) {
        ArrayList<FilePath> files = new ArrayList<FilePath>();
        for (CommitChange commitChange : changes) {
            if (ChangesUtil.CASE_SENSITIVE_FILE_PATH_HASHING_STRATEGY.equals((Object)commitChange.beforePath, (Object)commitChange.afterPath)) {
                ContainerUtil.addIfNotNull(files, (Object)commitChange.beforePath);
                continue;
            }
            ContainerUtil.addIfNotNull(files, (Object)commitChange.beforePath);
            ContainerUtil.addIfNotNull(files, (Object)commitChange.afterPath);
        }
        return files;
    }

    private static void processExcludedPaths(@NotNull Collection<? extends GitChangeUtils.GitDiffChange> changes, @NotNull Set<FilePath> added, @NotNull Set<FilePath> removed, @NotNull PairConsumer<? super FilePath, ? super FilePath> function) {
        for (GitChangeUtils.GitDiffChange gitDiffChange : changes) {
            FilePath before = gitDiffChange.getBeforePath();
            FilePath after2 = gitDiffChange.getAfterPath();
            if (removed.contains(before)) {
                before = null;
            }
            if (added.contains(after2)) {
                after2 = null;
            }
            function.consume((Object)before, (Object)after2);
        }
    }

    @NotNull
    private static String getLogString(@NotNull String root, @NotNull Collection<? extends ChangedPath> changes) {
        return GitUtil.getLogString(root, changes, it -> it.beforePath, it -> it.afterPath);
    }

    @NotNull
    private Pair<Collection<CommitChange>, List<VcsException>> commitExplicitRenames(@NotNull GitRepository repository, @NotNull Collection<CommitChange> changes, @NotNull String message) {
        List providers = ContainerUtil.filter((Object[])GitCheckinExplicitMovementProvider.EP_NAME.getExtensions(), it -> it.isEnabled(this.myProject));
        ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
        VirtualFile root = repository.getRoot();
        List beforePaths = ContainerUtil.mapNotNull(changes, it -> it.beforePath);
        List afterPaths = ContainerUtil.mapNotNull(changes, it -> it.afterPath);
        HashSet<GitCheckinExplicitMovementProvider.Movement> movedPaths = new HashSet<GitCheckinExplicitMovementProvider.Movement>();
        for (GitCheckinExplicitMovementProvider provider : providers) {
            Collection<GitCheckinExplicitMovementProvider.Movement> providerMovements = provider.collectExplicitMovements(this.myProject, beforePaths, afterPaths);
            if (providerMovements.isEmpty()) continue;
            message = provider.getCommitMessage(message);
            movedPaths.addAll(providerMovements);
        }
        try {
            Pair<List<CommitChange>, List<CommitChange>> committedAndNewChanges = this.addExplicitMovementsToIndex(repository, changes, movedPaths);
            if (committedAndNewChanges == null) {
                return Pair.create(changes, exceptions);
            }
            List movedChanges = (List)committedAndNewChanges.first;
            Collection newRootChanges = (Collection)committedAndNewChanges.second;
            GitCheckinEnvironment.runWithMessageFile(this.myProject, root, message, (ThrowableConsumer<? super File, ? extends VcsException>)((ThrowableConsumer)moveMessageFile -> exceptions.addAll(this.commitUsingIndex(repository, movedChanges, new HashSet(movedChanges), (File)moveMessageFile))));
            List committedMovements = ContainerUtil.mapNotNull((Collection)movedChanges, it -> Couple.of((Object)it.beforePath, (Object)it.afterPath));
            for (GitCheckinExplicitMovementProvider provider : providers) {
                provider.afterMovementsCommitted(this.myProject, committedMovements);
            }
            return Pair.create((Object)newRootChanges, exceptions);
        }
        catch (VcsException e) {
            exceptions.add(e);
            return Pair.create(changes, exceptions);
        }
    }

    @Nullable
    private Pair<List<CommitChange>, List<CommitChange>> addExplicitMovementsToIndex(@NotNull GitRepository repository, @NotNull Collection<? extends CommitChange> changes, @NotNull Collection<? extends GitCheckinExplicitMovementProvider.Movement> explicitMoves) throws VcsException {
        if ((explicitMoves = GitCheckinEnvironment.filterExcludedChanges(explicitMoves, changes)).isEmpty()) {
            return null;
        }
        LOG.info("Committing explicit rename: " + explicitMoves + " in " + DvcsUtil.getShortRepositoryName((Repository)repository));
        HashMap<FilePath, GitCheckinExplicitMovementProvider.Movement> movesMap = new HashMap<FilePath, GitCheckinExplicitMovementProvider.Movement>();
        for (GitCheckinExplicitMovementProvider.Movement movement : explicitMoves) {
            movesMap.put(movement.getBefore(), movement);
            movesMap.put(movement.getAfter(), movement);
        }
        ArrayList<CommitChange> nextCommitChanges = new ArrayList<CommitChange>();
        ArrayList<CommitChange> arrayList = new ArrayList<CommitChange>();
        HashMap<FilePath, CommitChange> affectedBeforePaths = new HashMap<FilePath, CommitChange>();
        HashMap<FilePath, CommitChange> affectedAfterPaths = new HashMap<FilePath, CommitChange>();
        for (CommitChange commitChange : changes) {
            if (!movesMap.containsKey(commitChange.beforePath) && !movesMap.containsKey(commitChange.afterPath)) {
                nextCommitChanges.add(commitChange);
                continue;
            }
            if (commitChange.beforePath != null) {
                affectedBeforePaths.put(commitChange.beforePath, commitChange);
            }
            if (commitChange.afterPath == null) continue;
            affectedAfterPaths.put(commitChange.afterPath, commitChange);
        }
        List pathsToDelete = ContainerUtil.map(explicitMoves, move -> move.getBefore());
        LOG.debug(String.format("Updating index for explicit movements: removing: %s", pathsToDelete));
        GitFileUtils.deletePaths(this.myProject, repository.getRoot(), pathsToDelete, "--ignore-unmatch");
        for (GitCheckinExplicitMovementProvider.Movement movement : explicitMoves) {
            FilePath beforeFilePath = movement.getBefore();
            FilePath afterFilePath = movement.getAfter();
            CommitChange bChange = (CommitChange)Objects.requireNonNull(affectedBeforePaths.get(beforeFilePath));
            CommitChange aChange = (CommitChange)Objects.requireNonNull(affectedAfterPaths.get(afterFilePath));
            if (bChange.beforeRevision == null) {
                LOG.warn(String.format("Unknown before revision: %s, %s", bChange, aChange));
                continue;
            }
            GitIndexUtil.StagedFile stagedFile = GitIndexUtil.listTree(repository, beforeFilePath, bChange.beforeRevision);
            if (stagedFile == null) {
                LOG.warn(String.format("Can't get revision for explicit move: %s -> %s", beforeFilePath, afterFilePath));
                continue;
            }
            LOG.debug(String.format("Updating index for explicit movements: adding movement: %s -> %s", beforeFilePath, afterFilePath));
            Hash hash = HashImpl.build((String)stagedFile.getBlobHash());
            boolean isExecutable = stagedFile.isExecutable();
            GitIndexUtil.updateIndex(repository, afterFilePath, hash, isExecutable);
            nextCommitChanges.add(new CommitChange(afterFilePath, afterFilePath, null, null, aChange.changelistId, aChange.virtualFile));
            arrayList.add(new CommitChange(beforeFilePath, afterFilePath, null, null, null, null));
            affectedBeforePaths.remove(beforeFilePath);
            affectedAfterPaths.remove(afterFilePath);
        }
        affectedBeforePaths.forEach((bPath, change) -> nextCommitChanges.add(new CommitChange(change.beforePath, null, change.beforeRevision, null, change.changelistId, change.virtualFile)));
        affectedAfterPaths.forEach((aPath, change) -> nextCommitChanges.add(new CommitChange(null, change.afterPath, null, change.afterRevision, change.changelistId, change.virtualFile)));
        if (arrayList.isEmpty()) {
            return null;
        }
        return Pair.create(arrayList, nextCommitChanges);
    }

    @NotNull
    private static List<GitCheckinExplicitMovementProvider.Movement> filterExcludedChanges(@NotNull Collection<? extends GitCheckinExplicitMovementProvider.Movement> explicitMoves, @NotNull Collection<? extends CommitChange> changes) {
        HashMultiset movedPathsMultiSet = HashMultiset.create();
        for (GitCheckinExplicitMovementProvider.Movement movement : explicitMoves) {
            movedPathsMultiSet.add((Object)movement.getBefore());
            movedPathsMultiSet.add((Object)movement.getAfter());
        }
        HashMultiset beforePathsMultiSet = HashMultiset.create();
        HashMultiset hashMultiset = HashMultiset.create();
        for (CommitChange commitChange : changes) {
            ContainerUtil.addIfNotNull((Collection)beforePathsMultiSet, (Object)commitChange.beforePath);
            ContainerUtil.addIfNotNull((Collection)hashMultiset, (Object)commitChange.afterPath);
        }
        return ContainerUtil.filter(explicitMoves, move -> movedPathsMultiSet.count((Object)move.getBefore()) == 1 && movedPathsMultiSet.count((Object)move.getAfter()) == 1 && beforePathsMultiSet.count((Object)move.getBefore()) == 1 && afterPathsMultiSet.count((Object)move.getAfter()) == 1 && beforePathsMultiSet.count((Object)move.getAfter()) == 0 && afterPathsMultiSet.count((Object)move.getBefore()) == 0);
    }

    private static void resetExcluded(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<? extends ChangedPath> changes) throws VcsException {
        THashSet allPaths = new THashSet(ChangesUtil.CASE_SENSITIVE_FILE_PATH_HASHING_STRATEGY);
        for (ChangedPath changedPath : changes) {
            ContainerUtil.addIfNotNull((Collection)allPaths, (Object)changedPath.afterPath);
            ContainerUtil.addIfNotNull((Collection)allPaths, (Object)changedPath.beforePath);
        }
        for (List list : VcsFileUtil.chunkPaths((VirtualFile)root, (Collection)allPaths)) {
            GitLineHandler handler = new GitLineHandler(project, root, GitCommand.RESET);
            handler.endOptions();
            handler.addParameters(list);
            Git.getInstance().runCommand(handler).throwOnError(new int[0]);
        }
    }

    private static void restoreExcluded(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<? extends ChangedPath> changes, @NotNull Set<FilePath> unstagedDeletions) {
        ArrayList restoreExceptions = new ArrayList();
        HashSet toAdd = new HashSet();
        HashSet toRemove = new HashSet();
        for (ChangedPath changedPath : changes) {
            if (GitCheckinEnvironment.addAsCaseOnlyRename(project, root, changedPath, restoreExceptions)) continue;
            if (changedPath.beforePath == null && unstagedDeletions.contains(changedPath.afterPath)) {
                LOG.info("Ignored added-deleted staged change in " + changedPath.afterPath);
                continue;
            }
            ContainerUtil.addIfNotNull(toAdd, (Object)changedPath.afterPath);
            ContainerUtil.addIfNotNull(toRemove, (Object)changedPath.beforePath);
        }
        toRemove.removeAll(toAdd);
        LOG.debug(String.format("Restoring staged changes after commit: added: %s, removed: %s", toAdd, toRemove));
        GitCheckinEnvironment.updateIndex(project, root, toAdd, toRemove, restoreExceptions);
        for (VcsException vcsException : restoreExceptions) {
            LOG.warn((Throwable)vcsException);
        }
    }

    private static boolean addAsCaseOnlyRename(@NotNull Project project, @NotNull VirtualFile root, @NotNull ChangedPath change, @NotNull List<? super VcsException> exceptions) {
        try {
            if (!GitCheckinEnvironment.isCaseOnlyRename(change)) {
                return false;
            }
            FilePath beforePath = Objects.requireNonNull(change.beforePath);
            FilePath afterPath = Objects.requireNonNull(change.afterPath);
            LOG.debug(String.format("Restoring staged case-only rename after commit: %s", change));
            GitLineHandler h2 = new GitLineHandler(project, root, GitCommand.MV);
            h2.addParameters("-f", beforePath.getPath(), afterPath.getPath());
            Git.getInstance().runCommandWithoutCollectingOutput(h2).throwOnError(new int[0]);
            return true;
        }
        catch (VcsException e) {
            exceptions.add(e);
            return false;
        }
    }

    private boolean mergeCommit(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<? extends CommitChange> rootChanges, @NotNull File messageFile, @NotNull List<? super VcsException> exceptions, @NotNull PartialOperation partialOperation) {
        String output;
        Set added = ContainerUtil.map2SetNotNull(rootChanges, it -> it.afterPath);
        Set removed = ContainerUtil.map2SetNotNull(rootChanges, it -> it.beforePath);
        removed.removeAll(added);
        HashSet<FilePath> realAdded = new HashSet<FilePath>();
        HashSet<FilePath> realRemoved = new HashSet<FilePath>();
        GitLineHandler diff = new GitLineHandler(project, root, GitCommand.DIFF);
        diff.setSilent(true);
        diff.setStdoutSuppressed(true);
        diff.addParameters("--diff-filter=ADMRUX", "--name-status", "--no-renames", "HEAD");
        diff.endOptions();
        try {
            output = Git.getInstance().runCommand(diff).getOutputOrThrow(new int[0]);
        }
        catch (VcsException ex) {
            exceptions.add(ex);
            return false;
        }
        String rootPath = root.getPath();
        StringTokenizer lines = new StringTokenizer(output, "\n", false);
        block11: while (lines.hasMoreTokens()) {
            String line = lines.nextToken().trim();
            if (line.length() == 0) continue;
            String[] tk = line.split("\t");
            switch (tk[0].charAt(0)) {
                case 'A': 
                case 'M': {
                    realAdded.add(VcsUtil.getFilePath((String)(rootPath + "/" + tk[1])));
                    continue block11;
                }
                case 'D': {
                    realRemoved.add(VcsUtil.getFilePath((String)(rootPath + "/" + tk[1]), (boolean)false));
                    continue block11;
                }
            }
            throw new IllegalStateException("Unexpected status: " + line);
        }
        realAdded.removeAll(added);
        realRemoved.removeAll(removed);
        if (realAdded.size() != 0 || realRemoved.size() != 0) {
            ArrayList<FilePath> files = new ArrayList<FilePath>();
            files.addAll(realAdded);
            files.addAll(realRemoved);
            Ref mergeAll = new Ref();
            try {
                ApplicationManager.getApplication().invokeAndWait(() -> {
                    String message = GitBundle.message("commit.partial.merge.message", partialOperation.getName());
                    SelectFilePathsDialog dialog2 = new SelectFilePathsDialog(project, files, message, null, "Commit All Files", CommonBundle.getCancelButtonText(), false);
                    dialog2.setTitle(GitBundle.getString("commit.partial.merge.title"));
                    dialog2.show();
                    mergeAll.set((Object)dialog2.isOK());
                });
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new RuntimeException("Unable to invoke a message box on AWT thread", ex);
            }
            if (!((Boolean)mergeAll.get()).booleanValue()) {
                return false;
            }
            if (!GitCheckinEnvironment.updateIndex(project, root, realAdded, realRemoved, exceptions)) {
                return false;
            }
            for (FilePath f : realAdded) {
                VcsDirtyScopeManager.getInstance((Project)project).fileDirty(f);
            }
            for (FilePath f : realRemoved) {
                VcsDirtyScopeManager.getInstance((Project)project).fileDirty(f);
            }
        }
        try {
            this.commitWithoutPaths(project, root, messageFile);
        }
        catch (VcsException ex) {
            exceptions.add(ex);
            return false;
        }
        return true;
    }

    private void commitWithoutPaths(@NotNull Project project, @NotNull VirtualFile root, @NotNull File messageFile) throws VcsException {
        GitLineHandler handler = new GitLineHandler(project, root, GitCommand.COMMIT);
        handler.setStdoutSuppressed(false);
        handler.addParameters("-F");
        handler.addAbsoluteFile(messageFile);
        if (this.myNextCommitAmend) {
            handler.addParameters("--amend");
        }
        if (this.myNextCommitAuthor != null) {
            handler.addParameters("--author=" + this.myNextCommitAuthor);
        }
        if (this.myNextCommitAuthorDate != null) {
            handler.addParameters("--date", COMMIT_DATE_FORMAT.format(this.myNextCommitAuthorDate));
        }
        if (this.myNextCommitSignOff) {
            handler.addParameters("--signoff");
        }
        if (this.myNextCommitSkipHook) {
            handler.addParameters("--no-verify");
        }
        handler.endOptions();
        Git.getInstance().runCommand(handler).throwOnError(new int[0]);
    }

    private static PartialOperation isMergeCommit(VcsException ex) {
        String message = ex.getMessage();
        if (message.contains("cannot do a partial commit during a merge")) {
            return PartialOperation.MERGE;
        }
        if (message.contains("cannot do a partial commit during a cherry-pick")) {
            return PartialOperation.CHERRY_PICK;
        }
        return PartialOperation.NONE;
    }

    private static boolean updateIndex(Project project, VirtualFile root, Collection<? extends FilePath> added, Collection<? extends FilePath> removed, List<? super VcsException> exceptions) {
        boolean rc = true;
        if (!removed.isEmpty()) {
            try {
                GitFileUtils.deletePaths(project, root, removed, "--ignore-unmatch", "--cached", "-r");
            }
            catch (VcsException ex) {
                exceptions.add(ex);
                rc = false;
            }
        }
        if (!added.isEmpty()) {
            try {
                GitFileUtils.addPathsForce(project, root, added);
            }
            catch (VcsException ex) {
                exceptions.add(ex);
                rc = false;
            }
        }
        return rc;
    }

    @NotNull
    public static File createCommitMessageFile(@NotNull Project project, @NotNull VirtualFile root, @NotNull String message) throws IOException {
        File file = FileUtil.createTempFile((String)GIT_COMMIT_MSG_FILE_PREFIX, (String)GIT_COMMIT_MSG_FILE_EXT);
        file.deleteOnExit();
        String encoding = GitConfigUtil.getCommitEncoding(project, root);
        try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding);){
            out.write(message);
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runWithMessageFile(@NotNull Project project, @NotNull VirtualFile root, @NotNull String message, @NotNull ThrowableConsumer<? super File, ? extends VcsException> task2) throws VcsException {
        File messageFile;
        try {
            messageFile = GitCheckinEnvironment.createCommitMessageFile(project, root, message);
        }
        catch (IOException ex) {
            throw new VcsException("Creation of commit message file failed", (Throwable)ex);
        }
        try {
            task2.consume((Object)messageFile);
        }
        finally {
            if (!messageFile.delete()) {
                LOG.warn("Failed to remove temporary file: " + messageFile);
            }
        }
    }

    public List<VcsException> scheduleMissingFileForDeletion(@NotNull List<FilePath> files) {
        Map<VirtualFile, List<FilePath>> sortedFiles;
        ArrayList<VcsException> rc = new ArrayList<VcsException>();
        try {
            sortedFiles = GitUtil.sortFilePathsByGitRoot(this.myProject, files);
        }
        catch (VcsException e) {
            rc.add(e);
            return rc;
        }
        for (Map.Entry<VirtualFile, List<FilePath>> e : sortedFiles.entrySet()) {
            try {
                VirtualFile root = e.getKey();
                GitFileUtils.deletePaths(this.myProject, root, (Collection<? extends FilePath>)e.getValue(), new String[0]);
                this.markRootDirty(root);
            }
            catch (VcsException ex) {
                rc.add(ex);
            }
        }
        return rc;
    }

    private void commit(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<? extends FilePath> files, @NotNull File messageFile) throws VcsException {
        boolean amend = this.myNextCommitAmend;
        for (List paths : VcsFileUtil.chunkPaths((VirtualFile)root, files)) {
            GitLineHandler handler = new GitLineHandler(project, root, GitCommand.COMMIT);
            handler.setStdoutSuppressed(false);
            if (this.myNextCommitSignOff) {
                handler.addParameters("--signoff");
            }
            if (amend) {
                handler.addParameters("--amend");
            } else {
                amend = true;
            }
            if (this.myNextCommitSkipHook) {
                handler.addParameters("--no-verify");
            }
            handler.addParameters("--only");
            handler.addParameters("-F");
            handler.addAbsoluteFile(messageFile);
            if (this.myNextCommitAuthor != null) {
                handler.addParameters("--author=" + this.myNextCommitAuthor);
            }
            if (this.myNextCommitAuthorDate != null) {
                handler.addParameters("--date", COMMIT_DATE_FORMAT.format(this.myNextCommitAuthorDate));
            }
            handler.endOptions();
            handler.addParameters(paths);
            Git.getInstance().runCommand(handler).throwOnError(new int[0]);
        }
    }

    public List<VcsException> scheduleUnversionedFilesForAddition(@NotNull List<VirtualFile> files) {
        Map<VirtualFile, List<VirtualFile>> sortedFiles;
        ArrayList<VcsException> rc = new ArrayList<VcsException>();
        try {
            sortedFiles = GitUtil.sortFilesByGitRoot(this.myProject, files);
        }
        catch (VcsException e) {
            rc.add(e);
            return rc;
        }
        for (Map.Entry<VirtualFile, List<VirtualFile>> e : sortedFiles.entrySet()) {
            try {
                VirtualFile root = e.getKey();
                GitFileUtils.addFiles(this.myProject, root, (Collection<? extends VirtualFile>)e.getValue());
                this.markRootDirty(root);
            }
            catch (VcsException ex) {
                rc.add(ex);
            }
        }
        return rc;
    }

    @NotNull
    private static Map<GitRepository, Collection<Change>> sortChangesByGitRoot(@NotNull Project project, @NotNull List<? extends Change> changes, @NotNull List<? super VcsException> exceptions) {
        HashMap<GitRepository, Collection<Change>> result2 = new HashMap<GitRepository, Collection<Change>>();
        for (Change change : changes) {
            try {
                FilePath filePath = ChangesUtil.getFilePath((Change)change);
                GitRepository repository = GitUtil.getRepositoryForFile(project, Objects.requireNonNull(filePath.getParentPath()));
                Collection changeList = result2.computeIfAbsent(repository, key -> new ArrayList());
                changeList.add(change);
            }
            catch (VcsException e) {
                exceptions.add(e);
            }
        }
        return result2;
    }

    private void markRootDirty(VirtualFile root) {
        VcsDirtyScopeManager.getInstance((Project)this.myProject).dirDirtyRecursively(root);
    }

    @NotNull
    static List<GitCheckinExplicitMovementProvider> collectActiveMovementProviders(@NotNull Project project) {
        Object[] allProviders = (GitCheckinExplicitMovementProvider[])GitCheckinExplicitMovementProvider.EP_NAME.getExtensions();
        List enabledProviders = ContainerUtil.filter((Object[])allProviders, it -> it.isEnabled(project));
        if (enabledProviders.isEmpty()) {
            return Collections.emptyList();
        }
        List changes = ContainerUtil.map((Collection)ChangeListManager.getInstance((Project)project).getAllChanges(), CommitChange::new);
        List beforePaths = ContainerUtil.mapNotNull((Collection)changes, it -> it.beforePath);
        List afterPaths = ContainerUtil.mapNotNull((Collection)changes, it -> it.afterPath);
        return ContainerUtil.filter((Collection)enabledProviders, it -> {
            Collection<GitCheckinExplicitMovementProvider.Movement> movements = it.collectExplicitMovements(project, beforePaths, afterPaths);
            List<GitCheckinExplicitMovementProvider.Movement> filteredMovements = GitCheckinEnvironment.filterExcludedChanges(movements, changes);
            return !filteredMovements.isEmpty();
        });
    }

    private static class CommitChange
    extends ChangedPath {
        @Nullable
        public final VcsRevisionNumber beforeRevision;
        @Nullable
        public final VcsRevisionNumber afterRevision;
        @Nullable
        public final String changelistId;
        @Nullable
        public final VirtualFile virtualFile;

        CommitChange(@NotNull Change change) {
            super(ChangesUtil.getBeforePath((Change)change), ChangesUtil.getAfterPath((Change)change));
            ContentRevision bRev = change.getBeforeRevision();
            ContentRevision aRev = change.getAfterRevision();
            this.beforeRevision = bRev != null ? bRev.getRevisionNumber() : null;
            this.afterRevision = aRev != null ? aRev.getRevisionNumber() : null;
            this.changelistId = change instanceof ChangeListChange ? ((ChangeListChange)change).getChangeListId() : null;
            this.virtualFile = aRev instanceof CurrentContentRevision ? ((CurrentContentRevision)aRev).getVirtualFile() : null;
        }

        CommitChange(@Nullable FilePath beforePath, @Nullable FilePath afterPath, @Nullable VcsRevisionNumber beforeRevision, @Nullable VcsRevisionNumber afterRevision, @Nullable String changelistId, @Nullable VirtualFile virtualFile) {
            super(beforePath, afterPath);
            this.beforeRevision = beforeRevision;
            this.afterRevision = afterRevision;
            this.changelistId = changelistId;
            this.virtualFile = virtualFile;
        }

        @Override
        public String toString() {
            return super.toString() + ", changelist: " + this.changelistId;
        }
    }

    private static class ChangedPath {
        @Nullable
        public final FilePath beforePath;
        @Nullable
        public final FilePath afterPath;

        ChangedPath(@Nullable FilePath beforePath, @Nullable FilePath afterPath) {
            assert (beforePath != null || afterPath != null);
            this.beforePath = beforePath;
            this.afterPath = afterPath;
        }

        public boolean isMove() {
            if (this.beforePath == null || this.afterPath == null) {
                return false;
            }
            return !ChangesUtil.CASE_SENSITIVE_FILE_PATH_HASHING_STRATEGY.equals((Object)this.beforePath, (Object)this.afterPath);
        }

        public String toString() {
            return String.format("%s -> %s", this.beforePath, this.afterPath);
        }
    }

    public class GitCheckinOptions
    implements CheckinChangeListSpecificComponent,
    RefreshableOnComponent,
    Disposable {
        @NotNull
        private final GitCommitOptionsUi myOptionsUi;

        GitCheckinOptions(@NotNull CheckinProjectPanel commitPanel, CommitContext commitContext, boolean showAmendOption) {
            this.myOptionsUi = new GitCommitOptionsUi(commitPanel, commitContext, showAmendOption);
            Disposer.register((Disposable)this, (Disposable)this.myOptionsUi);
        }

        @Nullable
        public String getAuthor() {
            VcsUser author = this.myOptionsUi.getAuthor();
            return author != null ? author.toString() : null;
        }

        public boolean isAmend() {
            return this.myOptionsUi.getAmendHandler().isAmendCommitMode();
        }

        public JComponent getComponent() {
            return this.myOptionsUi.getComponent();
        }

        public void restoreState() {
            this.myOptionsUi.restoreState();
        }

        public void refresh() {
            this.myOptionsUi.refresh();
        }

        public void saveState() {
            this.myOptionsUi.saveState();
        }

        public void onChangeListSelected(@NotNull LocalChangeList list) {
            this.myOptionsUi.onChangeListSelected(list);
        }

        public void dispose() {
        }
    }

    private static enum PartialOperation {
        NONE("none"),
        MERGE("merge"),
        CHERRY_PICK("cherry-pick");

        private final String myName;

        private PartialOperation(String name) {
            this.myName = name;
        }

        String getName() {
            return this.myName;
        }
    }
}

