/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitLocalBranch;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.branch.GitBranchUiHandler;
import git4idea.branch.GitBrancher;
import git4idea.branch.GitCheckoutNewBranchOperation;
import git4idea.branch.GitCheckoutOperation;
import git4idea.branch.GitCreateBranchOperation;
import git4idea.branch.GitDeleteBranchOperation;
import git4idea.branch.GitDeleteRemoteBranchOperation;
import git4idea.branch.GitDeleteRemoteTagOperation;
import git4idea.branch.GitDeleteTagOperation;
import git4idea.branch.GitMergeOperation;
import git4idea.branch.GitRebaseParams;
import git4idea.branch.GitRenameBranchOperation;
import git4idea.changes.GitChangeUtils;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.i18n.GitBundle;
import git4idea.rebase.GitRebaseUtils;
import git4idea.repo.GitRepository;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class GitBranchWorker {
    private static final Logger LOG = Logger.getInstance(GitBranchWorker.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final Git myGit;
    @NotNull
    private final GitBranchUiHandler myUiHandler;
    @NotNull
    private final GitVcs myVcs;

    public GitBranchWorker(@NotNull Project project, @NotNull Git git, @NotNull GitBranchUiHandler uiHandler) {
        this.myProject = project;
        this.myGit = git;
        this.myUiHandler = uiHandler;
        this.myVcs = GitVcs.getInstance(this.myProject);
    }

    public void checkoutNewBranch(@NotNull String name, @NotNull List<? extends GitRepository> repositories) {
        GitBranchWorker.updateInfo(repositories);
        repositories = ContainerUtil.filter(repositories, repository -> {
            GitLocalBranch currentBranch = repository.getCurrentBranch();
            return currentBranch == null || !currentBranch.getName().equals(name);
        });
        if (!repositories.isEmpty()) {
            new GitCheckoutNewBranchOperation(this.myProject, this.myGit, this.myUiHandler, repositories, name).execute();
        } else {
            LOG.error("Creating new branch the same as current in all repositories: " + name);
        }
    }

    public void createBranch(@NotNull String name, @NotNull Map<GitRepository, String> startPoints) {
        this.createBranch(name, startPoints, false);
    }

    public void createBranch(@NotNull String name, @NotNull Map<GitRepository, String> startPoints, boolean force) {
        GitBranchWorker.updateInfo(startPoints.keySet());
        new GitCreateBranchOperation(this.myProject, this.myGit, this.myUiHandler, name, startPoints, force).execute();
    }

    public void createNewTag(@NotNull String name, @NotNull String reference, @NotNull List<? extends GitRepository> repositories) {
        for (GitRepository gitRepository : repositories) {
            GitCommandResult result2 = this.myGit.createNewTag(gitRepository, name, null, reference);
            gitRepository.getRepositoryFiles().refreshTagsFiles();
            if (result2.success()) continue;
            String error = GitBundle.message("branch.worker.could.not.create.tag", name, GitUtil.getRepositoryManager(gitRepository.getProject()).getRepositories().size(), DvcsUtil.getShortRepositoryName((Repository)gitRepository));
            VcsNotifier.getInstance((Project)this.myProject).notifyError(error, result2.getErrorOutputAsHtmlString(), true);
            break;
        }
    }

    public void checkoutNewBranchStartingFrom(@NotNull String newBranchName, @NotNull String startPoint, @NotNull List<? extends GitRepository> repositories) {
        this.checkoutNewBranchStartingFrom(newBranchName, startPoint, false, repositories);
    }

    public void checkoutNewBranchStartingFrom(@NotNull String newBranchName, @NotNull String startPoint, boolean overwriteIfNeeded, @NotNull List<? extends GitRepository> repositories) {
        GitBranchWorker.updateInfo(repositories);
        new GitCheckoutOperation(this.myProject, this.myGit, this.myUiHandler, repositories, startPoint, false, overwriteIfNeeded, true, newBranchName).execute();
    }

    public void checkout(@NotNull String reference, boolean detach, @NotNull List<? extends GitRepository> repositories) {
        GitBranchWorker.updateInfo(repositories);
        new GitCheckoutOperation(this.myProject, this.myGit, this.myUiHandler, repositories, reference, detach, false, false, null).execute();
    }

    public void deleteBranch(@NotNull String branchName, @NotNull List<? extends GitRepository> repositories) {
        GitBranchWorker.updateInfo(repositories);
        new GitDeleteBranchOperation(this.myProject, this.myGit, this.myUiHandler, repositories, branchName).execute();
    }

    public void deleteTag(@NotNull String tagName, @NotNull List<? extends GitRepository> repositories) {
        GitBranchWorker.updateInfo(repositories);
        new GitDeleteTagOperation(this.myProject, this.myGit, this.myUiHandler, repositories, tagName).execute();
    }

    public void deleteRemoteTag(@NotNull String tagName, @NotNull Map<GitRepository, String> repositories) {
        GitBranchWorker.updateInfo(repositories.keySet());
        new GitDeleteRemoteTagOperation(this.myProject, this.myGit, this.myUiHandler, repositories, tagName).execute();
    }

    public void deleteRemoteBranch(@NotNull String branchName, @NotNull List<? extends GitRepository> repositories) {
        this.deleteRemoteBranches(Collections.singletonList(branchName), repositories);
    }

    public void deleteRemoteBranches(@NotNull List<String> branchNames, @NotNull List<? extends GitRepository> repositories) {
        GitBranchWorker.updateInfo(repositories);
        new GitDeleteRemoteBranchOperation(this.myProject, this.myGit, this.myUiHandler, repositories, branchNames).execute();
    }

    public void merge(@NotNull String branchName, @NotNull GitBrancher.DeleteOnMergeOption deleteOnMerge, @NotNull List<? extends GitRepository> repositories) {
        GitBranchWorker.updateInfo(repositories);
        new GitMergeOperation(this.myProject, this.myGit, this.myUiHandler, repositories, branchName, deleteOnMerge).execute();
    }

    public void rebase(@NotNull List<? extends GitRepository> repositories, @NotNull String branchName) {
        GitBranchWorker.updateInfo(repositories);
        GitRebaseUtils.rebase(this.myProject, repositories, new GitRebaseParams(this.myVcs.getVersion(), branchName), this.myUiHandler.getProgressIndicator());
    }

    public void rebaseOnCurrent(@NotNull List<? extends GitRepository> repositories, @NotNull String branchName) {
        this.rebase(repositories, "HEAD", branchName);
    }

    public void rebase(@NotNull List<? extends GitRepository> repositories, @NotNull String upstream, @NotNull String branchName) {
        GitBranchWorker.updateInfo(repositories);
        GitRebaseUtils.rebase(this.myProject, repositories, new GitRebaseParams(this.myVcs.getVersion(), branchName, null, upstream, false, false), this.myUiHandler.getProgressIndicator());
    }

    public void renameBranch(@NotNull String currentName, @NotNull String newName, @NotNull List<? extends GitRepository> repositories) {
        GitBranchWorker.updateInfo(repositories);
        new GitRenameBranchOperation(this.myProject, this.myGit, this.myUiHandler, currentName, newName, repositories).execute();
    }

    @NotNull
    public static Collection<Change> loadTotalDiff(@NotNull Repository repository, @NotNull String branchName) throws VcsException {
        return GitChangeUtils.getDiffWithWorkingDir(repository.getProject(), repository.getRoot(), branchName, null, true);
    }

    private static void updateInfo(@NotNull Collection<? extends GitRepository> repositories) {
        for (GitRepository gitRepository : repositories) {
            gitRepository.update();
        }
    }
}

