/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.CommonBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xml.util.XmlStringUtil;
import git4idea.DialogManager;
import git4idea.GitCommit;
import git4idea.GitUtil;
import git4idea.branch.GitBranchIsNotFullyMergedDialog;
import git4idea.branch.GitBranchUiHandler;
import git4idea.branch.GitSmartOperationDialog;
import git4idea.commands.Git;
import git4idea.i18n.GitBundle;
import git4idea.merge.GitConflictResolver;
import git4idea.repo.GitRepository;
import git4idea.util.GitUntrackedFilesHelper;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitBranchUiHandlerImpl
implements GitBranchUiHandler {
    @NonNls
    private static final String RESOLVE_HREF_ATTRIBUTE = "resolve";
    @NotNull
    private final Project myProject;
    @NotNull
    private final Git myGit;
    @NotNull
    private final ProgressIndicator myProgressIndicator;

    public GitBranchUiHandlerImpl(@NotNull Project project, @NotNull Git git, @NotNull ProgressIndicator indicator) {
        this.myProject = project;
        this.myGit = git;
        this.myProgressIndicator = indicator;
    }

    @Override
    public boolean notifyErrorWithRollbackProposal(@Nls(capitalization=Nls.Capitalization.Title) @NotNull String title, @Nls @NotNull String message, @Nls @NotNull String rollbackProposal) {
        AtomicBoolean ok = new AtomicBoolean();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            StringBuilder description = new StringBuilder();
            if (!StringUtil.isEmptyOrSpaces((String)message)) {
                description.append(message).append("<br/>");
            }
            description.append(rollbackProposal);
            ok.set(0 == DialogManager.showOkCancelDialog(this.myProject, XmlStringUtil.wrapInHtml((CharSequence)description), title, GitBundle.message("branch.ui.handler.rollback", new Object[0]), GitBundle.message("branch.ui.handler.do.not.rollback", new Object[0]), Messages.getErrorIcon()));
        });
        return ok.get();
    }

    @Override
    public void showUnmergedFilesNotification(final @NotNull String operationName, final @NotNull Collection<? extends GitRepository> repositories) {
        String title = GitBranchUiHandlerImpl.unmergedFilesErrorTitle(operationName);
        String description = GitBranchUiHandlerImpl.unmergedFilesErrorNotificationDescription(operationName);
        VcsNotifier.getInstance((Project)this.myProject).notifyError(title, description, new NotificationListener(){

            public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED && event.getDescription().equals(GitBranchUiHandlerImpl.RESOLVE_HREF_ATTRIBUTE)) {
                    GitConflictResolver.Params params = new GitConflictResolver.Params(GitBranchUiHandlerImpl.this.myProject).setMergeDescription(GitBundle.message("branch.ui.handler.merge.notification.description", operationName)).setErrorNotificationTitle(GitBundle.message("branch.ui.handler.merge.error.notification.title", new Object[0]));
                    new GitConflictResolver(GitBranchUiHandlerImpl.this.myProject, GitUtil.getRootsFromRepositories(repositories), params).merge();
                }
            }
        });
    }

    @Override
    public boolean showUnmergedFilesMessageWithRollback(@NotNull String operationName, @NotNull String rollbackProposal) {
        AtomicBoolean ok = new AtomicBoolean();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            String description = XmlStringUtil.wrapInHtml((CharSequence)GitBundle.message("branch.ui.handler.you.have.to.resolve.all.conflicts.before.operation.name", operationName, rollbackProposal));
            ok.set(0 == DialogManager.showOkCancelDialog(this.myProject, description, GitBranchUiHandlerImpl.unmergedFilesErrorTitle(operationName), GitBundle.message("branch.ui.handler.rollback", new Object[0]), GitBundle.message("branch.ui.handler.do.not.rollback", new Object[0]), Messages.getErrorIcon()));
        });
        return ok.get();
    }

    @Override
    public void showUntrackedFilesNotification(@NotNull String operationName, @NotNull VirtualFile root, @NotNull Collection<String> relativePaths) {
        GitUntrackedFilesHelper.notifyUntrackedFilesOverwrittenBy(this.myProject, root, relativePaths, operationName, null);
    }

    @Override
    public boolean showUntrackedFilesDialogWithRollback(@NotNull String operationName, @NotNull String rollbackProposal, @NotNull VirtualFile root, @NotNull Collection<String> relativePaths) {
        return GitUntrackedFilesHelper.showUntrackedFilesDialogWithRollback(this.myProject, operationName, rollbackProposal, root, relativePaths);
    }

    @Override
    @NotNull
    public ProgressIndicator getProgressIndicator() {
        return this.myProgressIndicator;
    }

    @Override
    public GitSmartOperationDialog.Choice showSmartOperationDialog(@NotNull Project project, @NotNull List<? extends Change> changes, @NotNull Collection<String> paths, @NotNull String operation, @Nullable @Nls(capitalization=Nls.Capitalization.Title) String forceButtonTitle) {
        Ref exitCode = Ref.create();
        ApplicationManager.getApplication().invokeAndWait(() -> exitCode.set((Object)GitSmartOperationDialog.show(project, changes, paths, StringUtil.capitalize((String)operation), forceButtonTitle)));
        return (GitSmartOperationDialog.Choice)((Object)exitCode.get());
    }

    @Override
    public boolean showBranchIsNotFullyMergedDialog(@NotNull Project project, @NotNull Map<GitRepository, List<GitCommit>> history, @NotNull Map<GitRepository, String> baseBranches, @NotNull String removedBranch) {
        AtomicBoolean restore = new AtomicBoolean();
        ApplicationManager.getApplication().invokeAndWait(() -> restore.set(GitBranchIsNotFullyMergedDialog.showAndGetAnswer(this.myProject, history, baseBranches, removedBranch)));
        return restore.get();
    }

    @Override
    @NotNull
    public GitBranchUiHandler.DeleteRemoteBranchDecision confirmRemoteBranchDeletion(@NotNull List<String> branchNames, @NotNull Collection<String> trackingBranches, @NotNull Collection<GitRepository> repositories) {
        String deleteButtonText;
        boolean deleteMultipleBranches = branchNames.size() > 1;
        String title = GitBundle.message("branch.ui.handler.delete.remote.branches", branchNames.size());
        String remoteBranches = deleteMultipleBranches ? StringUtil.join(branchNames, (String)", ") : branchNames.iterator().next();
        String message = GitBundle.message("branch.ui.handler.delete.remote.branches.question", branchNames.size(), remoteBranches);
        String string = deleteButtonText = deleteMultipleBranches ? GitBundle.message("branch.ui.handler.delete.all", new Object[0]) : CommonBundle.message((String)"button.delete", (Object[])new Object[0]);
        if (trackingBranches.isEmpty()) {
            return 0 == DialogManager.showOkCancelDialog(this.myProject, message, title, deleteButtonText, CommonBundle.getCancelButtonText(), Messages.getQuestionIcon()) ? GitBranchUiHandler.DeleteRemoteBranchDecision.DELETE : GitBranchUiHandler.DeleteRemoteBranchDecision.CANCEL;
        }
        String forBranch = GitBundle.message("branch.ui.handler.delete.tracking.local.branch.as.well", trackingBranches.iterator().next());
        String forBranches = XmlStringUtil.wrapInHtml((CharSequence)(GitBundle.message("branch.ui.handler.delete.tracking.local.branches", new Object[0]) + "<br/>" + StringUtil.join(trackingBranches, (String)", <br/>")));
        final String checkboxMessage = trackingBranches.size() == 1 ? forBranch : forBranches;
        final Ref deleteChoice = Ref.create((Object)false);
        boolean delete = ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)title, (String)message).project(this.myProject)).yesText(deleteButtonText)).noText(CommonBundle.getCancelButtonText())).doNotAsk((DialogWrapper.DoNotAskOption)new DialogWrapper.DoNotAskOption.Adapter(){

            public void rememberChoice(boolean isSelected, int exitCode) {
                deleteChoice.set((Object)isSelected);
            }

            @NotNull
            public String getDoNotShowMessage() {
                return checkboxMessage;
            }
        })).show() == 0;
        boolean deleteTracking = (Boolean)deleteChoice.get();
        return delete ? (deleteTracking ? GitBranchUiHandler.DeleteRemoteBranchDecision.DELETE_WITH_TRACKING : GitBranchUiHandler.DeleteRemoteBranchDecision.DELETE) : GitBranchUiHandler.DeleteRemoteBranchDecision.CANCEL;
    }

    @NotNull
    private static String unmergedFilesErrorTitle(@NotNull String operationName) {
        return GitBundle.message("branch.ui.handler.can.not.operation.name.because.of.unmerged.files", operationName);
    }

    @NotNull
    private static String unmergedFilesErrorNotificationDescription(String operationName) {
        return GitBundle.message("branch.ui.handler.unmerged.files.error.notification", RESOLVE_HREF_ATTRIBUTE, operationName);
    }
}

