/*
 * Decompiled with CFR 0.152.
 */
package git4idea.annotate;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.VcsAnnotationRefresher;
import com.intellij.util.messages.Topic;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryChangeListener;
import org.jetbrains.annotations.NotNull;

public class GitRepositoryForAnnotationsListener {
    public static void registerListener(final @NotNull Project project, @NotNull Disposable disposable) {
        project.getMessageBus().connect(disposable).subscribe(GitRepository.GIT_REPO_CHANGE, (Object)new GitRepositoryChangeListener(){

            @Override
            public void repositoryChanged(@NotNull GitRepository repository) {
                VcsAnnotationRefresher refresher = (VcsAnnotationRefresher)BackgroundTaskUtil.syncPublisher((Project)project, (Topic)VcsAnnotationRefresher.LOCAL_CHANGES_CHANGED);
                refresher.dirtyUnder(repository.getRoot());
            }
        });
    }
}

