/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitUtil;
import git4idea.branch.GitRebaseParams;
import git4idea.i18n.GitBundle;
import git4idea.rebase.GitRebaseDialog;
import git4idea.rebase.GitRebaseUtils;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class GitRebase
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        super.update(e);
        Project project = e.getProject();
        if (project == null || !GitUtil.hasGitRepositories(project)) {
            e.getPresentation().setEnabledAndVisible(false);
        } else {
            e.getPresentation().setVisible(true);
            e.getPresentation().setEnabled(GitRebaseUtils.getRebasingRepositories(project).size() < GitUtil.getRepositories(project).size());
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        final Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        ArrayList<GitRepository> repositories = new ArrayList<GitRepository>(GitUtil.getRepositories(project));
        repositories.removeAll(GitRebaseUtils.getRebasingRepositories(project));
        ArrayList<VirtualFile> roots = new ArrayList<VirtualFile>(GitUtil.getRootsFromRepositories(DvcsUtil.sortRepositories(repositories)));
        VirtualFile defaultRoot = DvcsUtil.guessVcsRoot((Project)project, (VirtualFile)((VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE)));
        GitRebaseDialog dialog2 = new GitRebaseDialog(project, roots, defaultRoot);
        if (dialog2.showAndGet()) {
            final VirtualFile root = dialog2.gitRoot();
            final GitRebaseParams selectedParams = dialog2.getSelectedParams();
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, GitBundle.getString("rebase.progress.indicator.title")){

                public void run(@NotNull ProgressIndicator indicator) {
                    GitRepository selectedRepository = (GitRepository)Objects.requireNonNull(GitRepositoryManager.getInstance(project).getRepositoryForRoot(root));
                    GitRebaseUtils.rebase(project, Collections.singletonList(selectedRepository), selectedParams, indicator);
                }
            });
        }
    }
}

