/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.inline;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiReference;
import javax.swing.JRadioButton;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringSettings;
import org.jetbrains.kotlin.idea.refactoring.inline.AbstractKotlinInlineDialog;
import org.jetbrains.kotlin.idea.refactoring.inline.KotlinInlineFunctionProcessor;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B)\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\tH\u0014J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0014J\b\u0010\u000f\u001a\u00020\tH\u0014R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/inline/KotlinInlineNamedFunctionDialog;", "Lorg/jetbrains/kotlin/idea/refactoring/inline/AbstractKotlinInlineDialog;", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "function", "reference", "Lcom/intellij/psi/PsiReference;", "editor", "Lcom/intellij/openapi/editor/Editor;", "allowToInlineThisOnly", "", "(Lorg/jetbrains/kotlin/psi/KtNamedFunction;Lcom/intellij/psi/PsiReference;Lcom/intellij/openapi/editor/Editor;Z)V", "canInlineThisOnly", "doAction", "", "doHelpAction", "isInlineThis", "kotlin.idea"})
public final class KotlinInlineNamedFunctionDialog
extends AbstractKotlinInlineDialog<KtNamedFunction> {
    private final boolean allowToInlineThisOnly;

    protected boolean isInlineThis() {
        return KotlinRefactoringSettings.Companion.getInstance().INLINE_METHOD_THIS;
    }

    public void doAction() {
        KtNamedFunction ktNamedFunction = (KtNamedFunction)this.getDeclaration();
        PsiReference psiReference = this.getReference();
        boolean bl = this.isInlineThisOnly() || this.allowToInlineThisOnly;
        boolean bl2 = !this.isInlineThisOnly() && !this.isKeepTheDeclaration() && !this.allowToInlineThisOnly;
        Editor editor2 = this.getEditor();
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        this.invokeRefactoring(new KotlinInlineFunctionProcessor(ktNamedFunction, psiReference, bl, bl2, editor2, project2));
        KotlinRefactoringSettings settings = KotlinRefactoringSettings.Companion.getInstance();
        JRadioButton jRadioButton = this.myRbInlineThisOnly;
        Intrinsics.checkNotNullExpressionValue((Object)jRadioButton, (String)"myRbInlineThisOnly");
        if (jRadioButton.isEnabled()) {
            JRadioButton jRadioButton2 = this.myRbInlineAll;
            Intrinsics.checkNotNullExpressionValue((Object)jRadioButton2, (String)"myRbInlineAll");
            if (jRadioButton2.isEnabled()) {
                settings.INLINE_METHOD_THIS = this.isInlineThisOnly();
            }
        }
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp(this.getDeclaration() instanceof KtConstructor ? "refactoring.inlineConstructor" : "refactoring.inlineMethod");
    }

    @Override
    protected boolean canInlineThisOnly() {
        return this.allowToInlineThisOnly;
    }

    public KotlinInlineNamedFunctionDialog(@NotNull KtNamedFunction function2, @Nullable PsiReference reference2, @Nullable Editor editor2, boolean allowToInlineThisOnly) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        super((KtNamedDeclaration)function2, reference2, editor2);
        this.allowToInlineThisOnly = allowToInlineThisOnly;
        this.init();
    }
}

