/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.highlighter.KotlinRecursiveCallLineMarkerProviderKt;
import org.jetbrains.kotlin.idea.inspections.RecursivePropertyAccessorInspection;
import org.jetbrains.kotlin.idea.util.ExtensionUtils;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.scopes.receivers.Receiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00062\u0016\u0010\b\u001a\u0012\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\n0\tj\u0002`\u000bH\u0016J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000e\u001a\u00020\u0007H\u0016J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/KotlinRecursiveCallLineMarkerProvider;", "Lcom/intellij/codeInsight/daemon/LineMarkerProvider;", "()V", "collectSlowLineMarkers", "", "elements", "", "Lcom/intellij/psi/PsiElement;", "result", "", "Lcom/intellij/codeInsight/daemon/LineMarkerInfo;", "Lorg/jetbrains/kotlin/idea/highlighter/markers/LineMarkerInfos;", "getEnclosingFunction", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "stopOnNonInlinedLambdas", "", "getLineMarkerInfo", "", "isRecursiveCall", "RecursiveMethodCallMarkerInfo", "kotlin.idea"})
public final class KotlinRecursiveCallLineMarkerProvider
implements LineMarkerProvider {
    @Nullable
    public Void getLineMarkerInfo(@NotNull PsiElement element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        return null;
    }

    public void collectSlowLineMarkers(@NotNull List<? extends PsiElement> elements2, @NotNull Collection<? super LineMarkerInfo<?>> result2) {
        Intrinsics.checkNotNullParameter(elements2, (String)"elements");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        HashSet<Integer> markedLineNumbers = new HashSet<Integer>();
        for (PsiElement psiElement2 : elements2) {
            int lineNumber;
            ProgressManager.checkCanceled();
            if (!(psiElement2 instanceof KtElement) || markedLineNumbers.contains(lineNumber = KotlinRecursiveCallLineMarkerProviderKt.access$getLineNumber(psiElement2)) || !this.isRecursiveCall((KtElement)psiElement2)) continue;
            markedLineNumbers.add(lineNumber);
            result2.add(new RecursiveMethodCallMarkerInfo(KotlinRecursiveCallLineMarkerProviderKt.getElementForLineMark(psiElement2)));
        }
    }

    private final KtNamedFunction getEnclosingFunction(KtElement element3, boolean stopOnNonInlinedLambdas) {
        for (PsiElement parent2 : PsiUtilsKt.getParents((PsiElement)((PsiElement)element3))) {
            PsiElement psiElement2 = parent2;
            if (psiElement2 instanceof KtFunctionLiteral) {
                if (!stopOnNonInlinedLambdas || InlineUtil.isInlinedArgument((KtFunction)((KtFunction)parent2), (BindingContext)ResolutionUtils.analyze$default((KtElement)((KtElement)parent2), null, (int)1, null), (boolean)false)) continue;
                return null;
            }
            if (psiElement2 instanceof KtNamedFunction) {
                PsiElement psiElement3 = ((KtNamedFunction)parent2).getParent();
                if (psiElement3 instanceof KtBlockExpression || psiElement3 instanceof KtClassBody || psiElement3 instanceof KtFile || psiElement3 instanceof KtScript) {
                    return (KtNamedFunction)parent2;
                }
                if (!stopOnNonInlinedLambdas || InlineUtil.isInlinedArgument((KtFunction)((KtFunction)parent2), (BindingContext)ResolutionUtils.analyze$default((KtElement)((KtElement)parent2), null, (int)1, null), (boolean)false)) continue;
                return null;
            }
            if (!(psiElement2 instanceof KtClassOrObject)) continue;
            return null;
        }
        return null;
    }

    private final boolean isRecursiveCall(KtElement element3) {
        if (RecursivePropertyAccessorInspection.Companion.isRecursivePropertyAccess(element3)) {
            return true;
        }
        if (RecursivePropertyAccessorInspection.Companion.isRecursiveSyntheticPropertyAccess(element3)) {
            return true;
        }
        Name name2 = KotlinRecursiveCallLineMarkerProviderKt.access$getCallNameFromPsi(element3);
        if (name2 == null) {
            return false;
        }
        Name resolveName = name2;
        KtNamedFunction ktNamedFunction = this.getEnclosingFunction(element3, false);
        if (ktNamedFunction == null) {
            return false;
        }
        KtNamedFunction enclosingFunction = ktNamedFunction;
        String enclosingFunctionName = enclosingFunction.getName();
        if (Intrinsics.areEqual((Object)enclosingFunctionName, (Object)OperatorNameConventions.INVOKE.asString()) ^ true && Intrinsics.areEqual((Object)enclosingFunctionName, (Object)resolveName.asString()) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual((Object)enclosingFunction, (Object)this.getEnclosingFunction(element3, true)) ^ true) {
            return false;
        }
        BindingContext bindingContext2 = ResolutionUtils.analyze$default((KtElement)element3, null, (int)1, null);
        SimpleFunctionDescriptor simpleFunctionDescriptor = (SimpleFunctionDescriptor)bindingContext2.get((ReadOnlySlice)BindingContext.FUNCTION, (Object)enclosingFunction);
        if (simpleFunctionDescriptor == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)simpleFunctionDescriptor, (String)"bindingContext[BindingCo\u2026Function] ?: return false");
        SimpleFunctionDescriptor enclosingFunctionDescriptor = simpleFunctionDescriptor;
        Call call = (Call)bindingContext2.get((ReadOnlySlice)BindingContext.CALL, (Object)element3);
        if (call == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)call, (String)"bindingContext[BindingCo\u2026 element] ?: return false");
        Call call2 = call;
        ResolvedCall resolvedCall2 = (ResolvedCall)bindingContext2.get((ReadOnlySlice)BindingContext.RESOLVED_CALL, (Object)call2);
        if (resolvedCall2 == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)resolvedCall2, (String)"bindingContext[BindingCo\u2026LL, call] ?: return false");
        ResolvedCall resolvedCall3 = resolvedCall2;
        CallableDescriptor callableDescriptor = resolvedCall3.getCandidateDescriptor();
        Intrinsics.checkNotNullExpressionValue((Object)callableDescriptor, (String)"resolvedCall.candidateDescriptor");
        if (Intrinsics.areEqual((Object)callableDescriptor.getOriginal(), (Object)enclosingFunctionDescriptor) ^ true) {
            return false;
        }
        Function1<Receiver, Boolean> $fun$isDifferentReceiver$1 = new Function1<Receiver, Boolean>(bindingContext2, enclosingFunctionDescriptor){
            final /* synthetic */ BindingContext $bindingContext;
            final /* synthetic */ SimpleFunctionDescriptor $enclosingFunctionDescriptor;

            public final boolean invoke(@Nullable Receiver receiver) {
                boolean bl;
                DeclarationDescriptor receiverOwner;
                if (!(receiver instanceof ReceiverValue)) {
                    return false;
                }
                DeclarationDescriptor declarationDescriptor = ExtensionUtils.getReceiverTargetDescriptor((ReceiverValue)((ReceiverValue)receiver), (BindingContext)this.$bindingContext);
                if (declarationDescriptor == null) {
                    return true;
                }
                DeclarationDescriptor declarationDescriptor2 = receiverOwner = declarationDescriptor;
                if (declarationDescriptor2 instanceof SimpleFunctionDescriptor) {
                    bl = Intrinsics.areEqual((Object)receiverOwner, (Object)this.$enclosingFunctionDescriptor) ^ true;
                } else if (declarationDescriptor2 instanceof ClassDescriptor) {
                    bl = Intrinsics.areEqual((Object)receiverOwner, (Object)this.$enclosingFunctionDescriptor.getContainingDeclaration()) ^ true;
                } else {
                    return true;
                }
                return bl;
            }
            {
                this.$bindingContext = bindingContext2;
                this.$enclosingFunctionDescriptor = simpleFunctionDescriptor;
                super(1);
            }
        };
        return !$fun$isDifferentReceiver$1.invoke((Receiver)resolvedCall3.getDispatchReceiver());
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\n\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/KotlinRecursiveCallLineMarkerProvider$RecursiveMethodCallMarkerInfo;", "Lcom/intellij/codeInsight/daemon/LineMarkerInfo;", "Lcom/intellij/psi/PsiElement;", "callElement", "(Lcom/intellij/psi/PsiElement;)V", "createGutterRenderer", "Lcom/intellij/openapi/editor/markup/GutterIconRenderer;", "kotlin.idea"})
    private static final class RecursiveMethodCallMarkerInfo
    extends LineMarkerInfo<PsiElement> {
        @Nullable
        public GutterIconRenderer createGutterRenderer() {
            return (GutterIconRenderer)new LineMarkerInfo.LineMarkerGutterIconRenderer<PsiElement>(this, (LineMarkerInfo)this){
                final /* synthetic */ RecursiveMethodCallMarkerInfo this$0;

                @Nullable
                public Void getClickAction() {
                    return null;
                }
                {
                    this.this$0 = this$0;
                    super($super_call_param$1);
                }
            };
        }

        public RecursiveMethodCallMarkerInfo(@NotNull PsiElement callElement2) {
            Intrinsics.checkNotNullParameter((Object)callElement2, (String)"callElement");
            super(callElement2, callElement2.getTextRange(), AllIcons.Gutter.RecursiveMethod, 11, (Function)1.INSTANCE, null, GutterIconRenderer.Alignment.RIGHT);
        }
    }
}

