/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.codevision;

import com.intellij.codeInsight.hints.ChangeListener;
import com.intellij.codeInsight.hints.ImmediateConfigurable;
import com.intellij.codeInsight.hints.InlayHintsCollector;
import com.intellij.codeInsight.hints.InlayHintsProvider;
import com.intellij.codeInsight.hints.InlayHintsSink;
import com.intellij.codeInsight.hints.NoSettings;
import com.intellij.codeInsight.hints.SettingsKey;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiFile;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.layout.LCFlags;
import com.intellij.ui.layout.LayoutBuilder;
import com.intellij.ui.layout.LayoutImplKt;
import com.intellij.ui.layout.LayoutKt;
import java.awt.Container;
import java.util.List;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.codeInsight.codevision.KotlinCodeVisionHintsCollector;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0002H\u0016J\b\u0010$\u001a\u00020\u0002H\u0016J*\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010#\u001a\u00020\u00022\u0006\u0010+\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020\u000b2\u0006\u0010.\u001a\u00020/H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0015\u001a\u0004\u0018\u00010\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\u001a\u0010\u0017\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\f\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\f\"\u0004\b\u001d\u0010\u001aR\u001a\u0010\u001e\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0007\"\u0004\b \u0010\t\u00a8\u00060"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/codevision/KotlinCodeVisionProvider;", "Lcom/intellij/codeInsight/hints/InlayHintsProvider;", "Lcom/intellij/codeInsight/hints/NoSettings;", "()V", "inheritorsLimit", "", "getInheritorsLimit", "()I", "setInheritorsLimit", "(I)V", "isVisibleInSettings", "", "()Z", "key", "Lcom/intellij/codeInsight/hints/SettingsKey;", "getKey", "()Lcom/intellij/codeInsight/hints/SettingsKey;", "name", "", "getName", "()Ljava/lang/String;", "previewText", "getPreviewText", "showInheritors", "getShowInheritors", "setShowInheritors", "(Z)V", "showUsages", "getShowUsages", "setShowUsages", "usagesLimit", "getUsagesLimit", "setUsagesLimit", "createConfigurable", "Lcom/intellij/codeInsight/hints/ImmediateConfigurable;", "settings", "createSettings", "getCollectorFor", "Lcom/intellij/codeInsight/hints/InlayHintsCollector;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "sink", "Lcom/intellij/codeInsight/hints/InlayHintsSink;", "isLanguageSupported", "language", "Lcom/intellij/lang/Language;", "kotlin.idea"})
public final class KotlinCodeVisionProvider
implements InlayHintsProvider<NoSettings> {
    @NotNull
    private final SettingsKey<NoSettings> key = new SettingsKey("CodeVision");
    @NotNull
    private final String name = KotlinBundle.message("hints.title.codevision", new Object[0]);
    @Nullable
    private final String previewText;
    private int usagesLimit = 100;
    private int inheritorsLimit = 100;
    private boolean showUsages;
    private boolean showInheritors;
    private final boolean isVisibleInSettings;

    @NotNull
    public SettingsKey<NoSettings> getKey() {
        return this.key;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getPreviewText() {
        return this.previewText;
    }

    public final int getUsagesLimit() {
        return this.usagesLimit;
    }

    public final void setUsagesLimit(int n) {
        this.usagesLimit = n;
    }

    public final int getInheritorsLimit() {
        return this.inheritorsLimit;
    }

    public final void setInheritorsLimit(int n) {
        this.inheritorsLimit = n;
    }

    public final boolean getShowUsages() {
        return this.showUsages;
    }

    public final void setShowUsages(boolean bl) {
        this.showUsages = bl;
    }

    public final boolean getShowInheritors() {
        return this.showInheritors;
    }

    public final void setShowInheritors(boolean bl) {
        this.showInheritors = bl;
    }

    public boolean isVisibleInSettings() {
        return this.isVisibleInSettings;
    }

    public boolean isLanguageSupported(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        return language instanceof KotlinLanguage;
    }

    @NotNull
    public ImmediateConfigurable createConfigurable(@NotNull NoSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        return new ImmediateConfigurable(){
            @NotNull
            private final List<ImmediateConfigurable.Case> cases;
            @NotNull
            private final String mainCheckboxText;

            @NotNull
            public JPanel createComponent(@NotNull ChangeListener listener2) {
                LayoutBuilder builder$iv;
                Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
                LCFlags[] constraints$iv = new LCFlags[]{};
                String title$iv = null;
                boolean $i$f$panel = false;
                LayoutBuilder $this$panel = builder$iv = LayoutImplKt.createLayoutBuilder();
                boolean bl = false;
                DialogPanel panel$iv = ComponentsKt.DialogPanel((String)title$iv, null);
                builder$iv.getBuilder().build((Container)panel$iv, constraints$iv);
                LayoutKt.initPanel((LayoutBuilder)builder$iv, (DialogPanel)panel$iv);
                return (JPanel)panel$iv;
            }

            @NotNull
            public List<ImmediateConfigurable.Case> getCases() {
                return this.cases;
            }

            @NotNull
            public String getMainCheckboxText() {
                return this.mainCheckboxText;
            }
            {
                this.cases = CollectionsKt.emptyList();
                this.mainCheckboxText = "";
            }
        };
    }

    @NotNull
    public NoSettings createSettings() {
        return new NoSettings();
    }

    @Nullable
    public InlayHintsCollector getCollectorFor(@NotNull PsiFile file, @NotNull Editor editor2, @NotNull NoSettings settings, @NotNull InlayHintsSink sink) {
        boolean showInheritorsResolved;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        boolean showUsagesResolved = Registry.is((String)"kotlin.code-vision.usages", (boolean)false) || this.showUsages;
        boolean bl = showInheritorsResolved = Registry.is((String)"kotlin.code-vision.inheritors", (boolean)false) || this.showInheritors;
        if (!showUsagesResolved && !showInheritorsResolved) {
            return null;
        }
        return (InlayHintsCollector)new KotlinCodeVisionHintsCollector(editor2, showUsagesResolved, showInheritorsResolved, this.usagesLimit, this.inheritorsLimit);
    }
}

