/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.rename;

import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class TextOccurrencesRenamer {
    private final Editor myEditor;
    private final String myOldName;
    private final List<TextRange> myOccurrences;
    private final TextRange myOccurrenceAtCaret;
    private final long myInitialModificationStamp;

    TextOccurrencesRenamer(@NotNull Editor editor, @NotNull String occurrenceText, @NotNull Collection<TextRange> occurrences, @NotNull TextRange occurrenceAtCaret) {
        this.myEditor = editor;
        this.myOldName = occurrenceText;
        this.myOccurrences = new ArrayList<TextRange>(occurrences);
        this.myOccurrences.sort(Comparator.comparingInt(TextRange::getStartOffset));
        this.myOccurrenceAtCaret = occurrenceAtCaret;
        this.myInitialModificationStamp = this.myEditor.getDocument().getModificationStamp();
    }

    @NotNull
    public String getOldName() {
        return this.myOldName;
    }

    @NotNull
    public Editor getEditor() {
        return this.myEditor;
    }

    public void renameTo(@NotNull String newName) {
        Document document = this.myEditor.getDocument();
        CharSequence documentText = document.getImmutableCharSequence();
        if (document.getModificationStamp() != this.myInitialModificationStamp || !this.isValid(documentText)) {
            return;
        }
        String result = this.getNewDocumentText(documentText, newName);
        WriteAction.run(() -> {
            int prevCount = (int)this.myOccurrences.stream().filter(range -> range.getStartOffset() < this.myOccurrenceAtCaret.getStartOffset()).count();
            Caret caret = this.myEditor.getCaretModel().getPrimaryCaret();
            int newCaretOffset = caret.getOffset() + (newName.length() - this.myOldName.length()) * prevCount;
            CommandProcessor.getInstance().executeCommand(this.myEditor.getProject(), () -> {
                document.setText((CharSequence)result);
                caret.moveToOffset(newCaretOffset);
            }, null, null, document);
        });
    }

    @NotNull
    private String getNewDocumentText(@NotNull CharSequence documentText, @NotNull String newName) {
        TextRange prevOccurrence = null;
        StringBuilder result = new StringBuilder(documentText.length() + (newName.length() - this.myOldName.length()) * this.myOccurrences.size());
        for (TextRange occurrence : this.myOccurrences) {
            result.append(documentText.subSequence(prevOccurrence != null ? prevOccurrence.getEndOffset() : 0, occurrence.getStartOffset()));
            result.append(newName);
            prevOccurrence = occurrence;
        }
        result.append(documentText.subSequence(prevOccurrence != null ? prevOccurrence.getEndOffset() : 0, documentText.length()));
        return result.toString();
    }

    private boolean isValid(@NotNull CharSequence text) {
        for (TextRange occurrence : this.myOccurrences) {
            if (StringUtil.startsWith((CharSequence)text, (int)occurrence.getStartOffset(), (CharSequence)this.myOldName)) continue;
            return false;
        }
        return true;
    }
}

