/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh;

import com.intellij.icons.AllIcons;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewModelBase;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.TreeBasedStructureViewBuilder;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.lang.PsiStructureViewFactory;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.editor.Editor;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.sh.ShBundle;
import com.intellij.sh.psi.ShFile;
import com.intellij.sh.psi.ShFunctionDefinition;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShStructureViewFactory
implements PsiStructureViewFactory {
    @Nullable
    public StructureViewBuilder getStructureViewBuilder(final @NotNull PsiFile psiFile) {
        if (!(psiFile instanceof ShFile)) {
            return null;
        }
        return new TreeBasedStructureViewBuilder(){

            @NotNull
            public StructureViewModel createStructureViewModel(@Nullable Editor editor) {
                return new Model(psiFile);
            }
        };
    }

    private static class Element
    implements StructureViewTreeElement,
    ItemPresentation,
    NavigationItem {
        private final PsiElement myElement;

        private Element(PsiElement element) {
            this.myElement = element;
        }

        public Object getValue() {
            return this.myElement;
        }

        public void navigate(boolean requestFocus) {
            ((Navigatable)this.myElement).navigate(requestFocus);
        }

        public boolean canNavigate() {
            return ((Navigatable)this.myElement).canNavigate();
        }

        public boolean canNavigateToSource() {
            return ((Navigatable)this.myElement).canNavigateToSource();
        }

        @Nullable
        public String getName() {
            return this.myElement instanceof ShFunctionDefinition ? Element.getFunctionName((ShFunctionDefinition)this.myElement) : null;
        }

        private static String getFunctionName(ShFunctionDefinition myElement) {
            String name = myElement.getName();
            return name == null ? ShBundle.message("sh.unnamed.element.presentable.name", new Object[0]) : name;
        }

        @NotNull
        public ItemPresentation getPresentation() {
            return this;
        }

        public TreeElement @NotNull [] getChildren() {
            return (TreeElement[])SyntaxTraverser.psiTraverser((PsiElement)this.myElement).children((Object)this.myElement).flatMap(ch -> (SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)ch).expand(psiElement -> !(psiElement instanceof ShFunctionDefinition))).filter(ShFunctionDefinition.class).map(Element::new).toArray((Object[])new Element[0]);
        }

        public String getPresentableText() {
            if (this.myElement instanceof ShFunctionDefinition) {
                return Element.getFunctionName((ShFunctionDefinition)this.myElement);
            }
            if (this.myElement instanceof ShFile) {
                return ((ShFile)this.myElement).getName();
            }
            if (this.myElement instanceof PsiNamedElement) {
                return ((PsiNamedElement)this.myElement).getName();
            }
            throw new AssertionError((Object)this.myElement.getClass().getName());
        }

        @Nullable
        public String getLocationString() {
            return null;
        }

        public Icon getIcon(boolean open) {
            if (!this.myElement.isValid()) {
                return null;
            }
            if (this.myElement instanceof ShFunctionDefinition) {
                return AllIcons.Nodes.Lambda;
            }
            return this.myElement.getIcon(0);
        }
    }

    private static class Model
    extends StructureViewModelBase
    implements StructureViewModel.ElementInfoProvider {
        private Model(@NotNull PsiFile psiFile) {
            super(psiFile, (StructureViewTreeElement)new Element((PsiElement)psiFile));
            this.withSuitableClasses(new Class[]{ShFile.class, ShFunctionDefinition.class});
        }

        public boolean isAlwaysShowsPlus(StructureViewTreeElement structureViewTreeElement) {
            return false;
        }

        public boolean isAlwaysLeaf(StructureViewTreeElement structureViewTreeElement) {
            return false;
        }
    }
}

