/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement.extended;

import com.intellij.application.options.CodeStyle;
import com.intellij.application.options.codeStyle.properties.AbstractCodeStylePropertyMapper;
import com.intellij.application.options.codeStyle.properties.CodeStyleFieldAccessor;
import com.intellij.application.options.codeStyle.properties.CodeStylePropertyAccessor;
import com.intellij.application.options.codeStyle.properties.GeneralCodeStylePropertyMapper;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.modifier.CodeStyleSettingsModifier;
import com.intellij.psi.codeStyle.modifier.CodeStyleStatusBarUIContributor;
import com.intellij.psi.codeStyle.modifier.TransientCodeStyleSettings;
import com.intellij.util.ObjectUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import org.editorconfig.Utils;
import org.editorconfig.configmanagement.EditorConfigFilesCollector;
import org.editorconfig.configmanagement.EditorConfigNavigationActionsFactory;
import org.editorconfig.configmanagement.extended.EditorConfigCodeStyleStatusBarUIContributor;
import org.editorconfig.configmanagement.extended.EditorConfigIntellijNameUtil;
import org.editorconfig.configmanagement.extended.EditorConfigPropertyKind;
import org.editorconfig.configmanagement.extended.IntellijPropertyKindMap;
import org.editorconfig.core.EditorConfig;
import org.editorconfig.core.EditorConfigException;
import org.editorconfig.core.ParserCallback;
import org.editorconfig.core.ParsingException;
import org.editorconfig.language.messages.EditorConfigBundle;
import org.editorconfig.plugincomponents.SettingsProviderComponent;
import org.editorconfig.settings.EditorConfigSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorConfigCodeStyleSettingsModifier
implements CodeStyleSettingsModifier {
    private static final Map<String, List<String>> DEPENDENCIES = new HashMap<String, List<String>>();
    private static final Logger LOG = Logger.getInstance(EditorConfigCodeStyleSettingsModifier.class);
    public static final ProgressIndicator EMPTY_PROGRESS_INDICATOR = new EmptyProgressIndicator();
    private static boolean ourEnabledInTests;

    private static void addDependency(@NotNull String name, String ... dependentNames) {
        DEPENDENCIES.put(name, Arrays.asList(dependentNames));
    }

    public boolean modifySettings(@NotNull TransientCodeStyleSettings settings, @NotNull PsiFile psiFile) {
        Project project;
        VirtualFile file = psiFile.getVirtualFile();
        if (Utils.isFullIntellijSettingsSupport() && file != null && (!ApplicationManager.getApplication().isUnitTestMode() || EditorConfigCodeStyleSettingsModifier.isEnabledInTests()) && !(project = psiFile.getProject()).isDisposed() && Utils.isEnabled((CodeStyleSettings)settings)) {
            try {
                MyContext context = new MyContext((CodeStyleSettings)settings, psiFile);
                return EditorConfigCodeStyleSettingsModifier.runWithCheckCancelled(() -> {
                    EditorConfigCodeStyleSettingsModifier.processEditorConfig(project, psiFile, context);
                    if (EditorConfigCodeStyleSettingsModifier.applyCodeStyleSettings(context)) {
                        settings.addDependencies(context.getEditorConfigFiles());
                        ObjectUtils.consumeIfNotNull((Object)EditorConfigNavigationActionsFactory.getInstance(psiFile), navigationFactory -> navigationFactory.updateEditorConfigFilePaths(context.getFilePaths()));
                        return true;
                    }
                    return false;
                }, EditorConfigCodeStyleSettingsModifier.getIndicator());
            }
            catch (EditorConfigException context) {
            }
            catch (ProcessCanceledException pce) {
                throw pce;
            }
            catch (Exception ex) {
                LOG.error((Throwable)ex);
            }
        }
        return false;
    }

    private static boolean runWithCheckCancelled(@NotNull Callable<Boolean> callable, @NotNull ProgressIndicator progressIndicator) throws Exception {
        Future future = ApplicationManager.getApplication().executeOnPooledThread(callable);
        try {
            return (Boolean)ApplicationUtil.runWithCheckCanceled((Future)future, (ProgressIndicator)progressIndicator);
        }
        catch (ProcessCanceledException pce) {
            future.cancel(true);
            throw pce;
        }
    }

    @NotNull
    private static ProgressIndicator getIndicator() {
        return (ProgressIndicator)ObjectUtils.notNull((Object)ProgressIndicatorProvider.getInstance().getProgressIndicator(), (Object)EMPTY_PROGRESS_INDICATOR);
    }

    @Nullable
    public CodeStyleStatusBarUIContributor getStatusBarUiContributor(@NotNull TransientCodeStyleSettings transientSettings) {
        return new EditorConfigCodeStyleStatusBarUIContributor();
    }

    private static boolean applyCodeStyleSettings(@NotNull MyContext context) {
        AbstractCodeStylePropertyMapper mapper = EditorConfigCodeStyleSettingsModifier.getPropertyMapper(context);
        HashSet<String> processed = new HashSet<String>();
        boolean isModified = EditorConfigCodeStyleSettingsModifier.processOptions(context, mapper, false, processed);
        isModified = EditorConfigCodeStyleSettingsModifier.processOptions(context, mapper, true, processed) || isModified;
        return isModified;
    }

    @NotNull
    private static AbstractCodeStylePropertyMapper getPropertyMapper(@NotNull MyContext context) {
        LanguageCodeStyleSettingsProvider provider = LanguageCodeStyleSettingsProvider.findUsingBaseLanguage((Language)context.getLanguage());
        if (provider != null) {
            return provider.getPropertyMapper(context.getSettings());
        }
        return new GeneralCodeStylePropertyMapper(context.getSettings());
    }

    public boolean mayOverrideSettingsOf(@NotNull Project project) {
        return Utils.isEnabled(CodeStyle.getSettings((Project)project)) && Utils.editorConfigExists(project);
    }

    public String getName() {
        return EditorConfigBundle.message("editorconfig");
    }

    private static boolean processOptions(@NotNull MyContext context, @NotNull AbstractCodeStylePropertyMapper mapper, boolean languageSpecific, Set<String> processed) {
        String langPrefix = languageSpecific ? mapper.getLanguageDomainId() + "_" : null;
        boolean isModified = false;
        for (EditorConfig.OutPair option : context.getOptions()) {
            Object dataObject;
            String optionKey = option.getKey();
            String intellijName = EditorConfigIntellijNameUtil.toIntellijName(optionKey);
            CodeStylePropertyAccessor<?> accessor = EditorConfigCodeStyleSettingsModifier.findAccessor(mapper, intellijName, langPrefix);
            if (accessor == null) continue;
            String val = EditorConfigCodeStyleSettingsModifier.preprocessValue(context, optionKey, option.getVal());
            if (DEPENDENCIES.containsKey(optionKey)) {
                for (String dependency : DEPENDENCIES.get(optionKey)) {
                    CodeStylePropertyAccessor<?> dependencyAccessor;
                    if (processed.contains(dependency) || (dependencyAccessor = EditorConfigCodeStyleSettingsModifier.findAccessor(mapper, dependency, null)) == null) continue;
                    isModified |= dependencyAccessor.setFromString(val);
                }
            }
            isModified |= accessor.setFromString(val);
            if (accessor instanceof CodeStyleFieldAccessor && (dataObject = ((CodeStyleFieldAccessor)accessor).getDataObject()) instanceof CommonCodeStyleSettings.IndentOptions) {
                ((CommonCodeStyleSettings.IndentOptions)dataObject).setOverrideLanguageOptions(true);
            }
            processed.add(intellijName);
        }
        return isModified;
    }

    private static String preprocessValue(@NotNull MyContext context, @NotNull String optionKey, @NotNull String optionValue) {
        if ("indent_size".equals(optionKey) && "tab".equals(optionValue)) {
            return context.getTabSize();
        }
        return optionValue;
    }

    @Nullable
    private static CodeStylePropertyAccessor<?> findAccessor(@NotNull AbstractCodeStylePropertyMapper mapper, @NotNull String propertyName, @Nullable String langPrefix) {
        if (langPrefix != null) {
            String prefixlessName;
            EditorConfigPropertyKind propertyKind;
            if (propertyName.startsWith(langPrefix) && ((propertyKind = IntellijPropertyKindMap.getPropertyKind(prefixlessName = StringUtil.trimStart((String)propertyName, (String)langPrefix))) == EditorConfigPropertyKind.LANGUAGE || propertyKind == EditorConfigPropertyKind.COMMON)) {
                return mapper.getAccessor(prefixlessName);
            }
        } else {
            return mapper.getAccessor(propertyName);
        }
        return null;
    }

    private static void processEditorConfig(@NotNull Project project, @NotNull PsiFile psiFile, @NotNull MyContext context) throws EditorConfigException {
        try {
            String filePath = Utils.getFilePath(project, psiFile.getVirtualFile());
            if (filePath != null) {
                Set<String> rootDirs = SettingsProviderComponent.getInstance().getRootDirs(project);
                context.setOptions(new EditorConfig().getProperties(filePath, rootDirs, (ParserCallback)context));
            } else {
                LOG.error("No file path for " + psiFile.getName());
            }
        }
        catch (ParsingException pe) {
            LOG.debug((Throwable)pe);
        }
    }

    @Nullable
    public Consumer<CodeStyleSettings> getDisablingFunction() {
        return settings -> {
            EditorConfigSettings editorConfigSettings = (EditorConfigSettings)settings.getCustomSettings(EditorConfigSettings.class);
            editorConfigSettings.ENABLED = false;
        };
    }

    private static boolean isEnabledInTests() {
        return ourEnabledInTests;
    }

    public static void setEnabledInTests(boolean isEnabledInTests) {
        ourEnabledInTests = isEnabledInTests;
    }

    static {
        EditorConfigCodeStyleSettingsModifier.addDependency("indent_size", "continuation_indent_size");
    }

    private static class MyContext
    extends EditorConfigFilesCollector {
        @NotNull
        private final CodeStyleSettings mySettings;
        @Nullable
        private List<EditorConfig.OutPair> myOptions;
        @NotNull
        private final PsiFile myFile;

        private MyContext(@NotNull CodeStyleSettings settings, @NotNull PsiFile file) {
            this.mySettings = settings;
            this.myFile = file;
        }

        public void setOptions(@NotNull List<EditorConfig.OutPair> options) {
            this.myOptions = options;
        }

        @NotNull
        private CodeStyleSettings getSettings() {
            return this.mySettings;
        }

        @NotNull
        private List<EditorConfig.OutPair> getOptions() {
            return this.myOptions == null ? Collections.emptyList() : this.myOptions;
        }

        @NotNull
        private Language getLanguage() {
            return this.myFile.getLanguage();
        }

        private String getTabSize() {
            for (EditorConfig.OutPair pair : this.getOptions()) {
                if (!"tab_width".equals(pair.getKey())) continue;
                return pair.getVal();
            }
            CommonCodeStyleSettings.IndentOptions indentOptions = this.mySettings.getIndentOptions(this.myFile.getFileType());
            return String.valueOf(indentOptions.TAB_SIZE);
        }
    }
}

